
Unit KeyDPMI;

{$A+,B-,D-,E-,F-,I-,L-,N-,O-,P-,Q-,R-,S-,T-,V-,X+,Y-} {* compilerswitches *}



{                                                       }
{  KEYDPMI  preliminary beta version 0.1                }
{                                                       }
{  October 1995    by Erik de Neve    CIS:100121,1070   }
{                                                       }
{  See KEYDPMI.DOC for explanation and scancode lists   }
{                                                       }



 {$G+ }     { note: 286+ use automatically assumed for DPMI compilation }


 INTERFACE



 CONST

  MaxNewScan = $69;



 VAR

  Oldint9:Pointer;
  NewKeyFlag:byte;  { set whenever a MAKE (pressed) code comes in  }
  KeyArray: array [0..MaxNewScan] of Boolean;

  { internal flags to recognize prefixed code sequences }

  E0E1flag:byte;

  PauseStatus:boolean;  {always updated }

  AsciiTranslate:boolean; {if False, only the Keyarray is updated.}


  { BIOS functionality }

  KeyBuffer: array [0..31] of Word;    { works just like the BIOS buffer }
  KeyBufNextchar :word;
  KeyBufFirstFree:word;

  StatusFlags1:byte; { equivalent to BIOS keyboard status byte at $40:$17 }

  { pascal functionality workspace }

  ExtKeySave: char;


  { for DEBUGGING }

  Int9Counter: word;
  Int9Key: byte;
  ErrorCounter:word;



Procedure UpdateLEDS(LedStatus:byte);
Procedure FlushKeys;
Procedure ResetKeyArray;
Procedure UpdateBios;  {copy our status byte to BIOS status byte }
Procedure BiosCopy;   {copy BIOS status byte to our status byte }
Procedure FlushBIOSbuffer; {flush the BIOS buffer}
Procedure InstallKeyHandler;
Procedure RemoveKeyHandler;

Function  ScanAvail:boolean;
Function  ReadScan:word;
Function  NewKeyPressed:Boolean;
Function  NewReadKey:Char;
Function  EnhKbdDetect:Boolean;


 IMPLEMENTATION


 CONST

  ScanPadFirst = $47;
  ScanPadLast  = $53;

  ShiftLeft = $2a;
  ShiftRight= $36;
  CtrlLeft  = $1d;
  CtrlRight = $5a;
  AltLeft   = $38;
  AltRight  = $5b;

  InsertFlag     = $80;
  CapsLockFlag   = $40;
  NumLockFlag    = $20;
  ScrollLockFlag = $10;


NormalAscii: array [0..MaxNewScan] of byte =

  ($00,$1B,$31,$32,$33,$34,$35,$36,$37,$38,$39,$30,$2D,$3D,$08,$09,  {  0x }
   $71,$77,$65,$72,$74,$79,$75,$69,$6F,$70,$5B,$5D,$0D,$FF,$61,$73,  {  1x }
   $64,$66,$67,$68,$6A,$6B,$6C,$3B,$27,$60,$FF,$5C,$7A,$78,$63,$76,  {  2x }
   $62,$6E,$6D,$2C,$2E,$2F,$FF,$2A,$FF,$20,$FE,$00,$00,$00,$00,$00,  {  3x }

   $00,$00,$00,$00,$00,$FE,$FE,$00,$00,$00,$2D,$00,$00,$00,$2B,$00,  {  4x }
   $00,$00,$00,$00,$FF,$FF,$82,$80,$81,$83,$FF,$FF,$84,$85,$86,$87,  {  5x }
   $88,$FF,$89,$FF,$8A,$8B,$8C,$8D,$8E,$00                           {  6x }
  );
  {  0   1   2   3   4   5   6   7   8   9   A   B   C   D   E   F }


NormalExceptions: array [0..14] of word =
                                { fixed normal }
   ( $8500,   {80   F11                 57 }
     $8600,   {81   F12                 58 }
     $2B5C,   {82   spare key           56 }
     $1C0D,   {83   Pad enter       59     }
     $4700,   {84   6pad Home       5C     }
     $4800,   {85   4pad Up         5d     }
     $4900,   {86   6pad Pgup       5e     }
     $352F,   {87  17pad Slash      5f     }

     $4B00,   {88   4pad Left       60     }
     $4D00,   {89   4pad Right      62     }
     $4F00,   {8A    pad End        64     }
     $5000,   {8B    pad Down       65     }
     $5100,   {8C    pad PageDown   66     }
     $5200,   {8D    pad Insert     67     }
     $5300    {8E    pad Delete     68     }
   );




ShiftAscii: array [0..MaxNewScan] of byte =

 ( $00,$1B,$21,$40,$23,$24,$25,$5E,$26,$2A,$28,$29,$5F,$2B,$08,$00,  {  0x }
   $51,$57,$45,$52,$54,$59,$55,$49,$4F,$50,$7B,$7D,$0D,$FF,$41,$53,  {  1x }
   $44,$46,$47,$48,$4A,$4B,$4C,$3A,$22,$7E,$FF,$7C,$5A,$58,$43,$56,  {  2x }
   $42,$4E,$4D,$3C,$3E,$3F,$FF,$2A,$FF,$20,$FE,$8F,$90,$91,$92,$93,  {  3x }

   $94,$95,$96,$97,$98,$FE,$FE,$37,$38,$39,$2D,$34,$35,$36,$2B,$31,  {  4x }
   $32,$33,$30,$2E,$FF,$FF,$82,$80,$81,$83,$FF,$FF,$84,$85,$86,$87,  {  5x }
   $88,$FF,$89,$FF,$8A,$8B,$8C,$8D,$8E,$00                           {  6x }
  );

  {  0   1   2   3   4   5   6   7   8   9   A   B   C   D   E   F }


ShiftExceptions: array [0..24] of word =
                                { fixed normal }
   ( $8700,   {80   F11                 57 }
     $8800,   {81   F12                 58 }
     $2B7C,   {82   spare key           56 }
     $1C0D,   {83   Pad enter       59     }
     $4700,   {84   6pad Home       5C     }
     $4800,   {85   4pad Up         5d     }
     $4900,   {86   6pad Pgup       5e     }
     $353F,   {87  17pad Slash      5f     }
     $4B00,   {88   4pad Left       60     }
     $4D00,   {89   4pad Right      62     }
     $4F00,   {8A   6pad End        64     }
     $5000,   {8B   4pad Down       65     }
     $5100,   {8C   6pad PageDown   66     }
     $5200,   {8D   6pad Insert     67     }
     $5300,   {8E   6pad Delete     68     }

     $5400,   {8F    F1                 3B }
     $5500,   {90    F2                 3C }
     $5600,   {91    F3                 3D }
     $5700,   {92    F4                 3E }
     $5800,   {93    F5                 3F }
     $5900,   {94    F6                 40 }
     $5A00,   {95    F7                 41 }
     $5B00,   {96    F8                 42 }
     $5C00,   {97    F9                 43 }
     $5D00    {98    F10                44 }
   );

CtrlAscii: array [0..MaxNewScan] of byte =

 ( $00,$1B,$FF,$00,$FF,$FF,$FF,$1E,$FF,$FF,$FF,$FF,$1F,$FF,$7F,$9E,  {  0x }
   $11,$17,$05,$12,$14,$19,$15,$09,$0F,$10,$1B,$1D,$0A,$FF,$01,$13,  {  1x }
   $04,$06,$07,$08,$0A,$0B,$0C,$FF,$FF,$FF,$FF,$1C,$1A,$18,$03,$16,  {  2x }
   $02,$0E,$0D,$FF,$FF,$FE,$FE,$9C,$FF,$20,$FE,$91,$92,$93,$94,$95,  {  3x }

   $96,$97,$98,$99,$9A,$FE,$FE,$84,$85,$86,$87,$88,$89,$8A,$8B,$8C,  {  4x }
   $8D,$8E,$8F,$90,$9D,$FF,$82,$80,$81,$83,$FF,$FF,$84,$85,$86,$9B,  {  5x }
   $88,$FF,$8A,$FF,$8C,$8D,$8E,$8F,$90,$00                           {  6x }
   );

  {  0   1   2   3   4   5   6   7   8   9   A   B   C   D   E   F }



CtrlExceptions: array [0..30] of word =
                                { fixed normal }
   ( $8900,   {80   F11                 57 }
     $8A00,   {81   F12                 58 }
     $2B1C,   {82   spare key \|        56 }
     $1C0A,   {83   Pad enter       59     }
     $7700,   {84        Home       5C  47 }
     $8D00,   {85        Up         5d  48 }
     $8400,   {86        Pgup       5e  49 }
     $8E00,   {87    keypad -       ..  4A }
     $7300,   {88        Left       60  4B }
     $8F00,   {89    keypad 5       ..  4C }
     $7400,   {8A        Right      62  4D }
     $9000,   {8B    keypad +       ..  4E }
     $7500,   {8C        End        64  4F }
     $9100,   {8D        Down       65  50 }
     $7600,   {8E        PageDown   66  51 }
     $9200,   {8F        Insert     67  52 }
     $9300,   {90        Delete     68  53 }

     $5E00,   {91    F1                 3B }
     $5F00,   {92    F2                 3C }
     $6000,   {93    F3                 3D }
     $6100,   {94    F4                 3E }
     $6200,   {95    F5                 3F }
     $6300,   {96    F6                 40 }
     $6400,   {97    F7                 41 }
     $6500,   {98    F8                 42 }
     $6600,   {99    F9                 43 }
     $6700,   {9A    F10                44 }

     $9500,   {9B   pad  Slash      5f     }
     $9600,   {9C   keypad *            37 }
     $7200,   {9D   Ctrl-SysReq/prtscr  54 }

     $9400    {9E   Ctrl-TAB            0f }
   );


AltAscii: array [0..MaxNewScan] of byte =

 ( $00,$00,$9A,$9B,$9C,$9D,$9E,$9F,$A0,$A1,$A2,$A3,$A4,$A5,$00,$A6,  {  0x }
   $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$FF,$00,$00,  {  1x }
   $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$FF,$00,$00,$00,$00,$00,  {  2x }
   $00,$00,$00,$00,$00,$00,$FF,$00,$FF,$20,$FE,$90,$91,$92,$93,$94,  {  3x }

   $95,$96,$97,$98,$99,$FE,$FE,$84,$85,$86,$00,$88,$FF,$89,$8A,$8B,  {  4x }
   $8C,$8D,$8E,$8F,$FF,$FF,$82,$80,$81,$83,$FF,$FF,$84,$85,$86,$87,  {  5x }
   $88,$FF,$89,$FF,$8B,$8C,$8D,$8E,$8F,$00                           {  6x }
   );

  {  0   1   2   3   4   5   6   7   8   9   A   B   C   D   E   F }


AltExceptions: array [0..38] of word =
                                { fixed normal }
   ( $8B00,   {80   F11                 57 }
     $8C00,   {81   F12                 58 }

     $2B00,   {82   spare key \|    56     }
     $A600,   {83   Pad enter       59     }
     $9700,   {84        Home       5C  47 }
     $9800,   {85        Up         5d  48 }
     $9900,   {86        Pgup       5e  49 }
     $A400,   {87   Pad  Slash      5f     }
     $9b00,   {88        Left       60  4B }
     $9D00,   {89        Right      62  4D }
     $4E00,   {8A        Plus       ..  4E }
     $9F00,   {8B        End        64  4F }
     $A000,   {8C        Down       65  50 }
     $A100,   {8D        PageDown   66  51 }
     $A200,   {8E        Insert     67  52 }
     $A300,   {8F        Delete     68  53 }

     $6800,   {90    F1                 3B }
     $6900,   {91    F2                 3C }
     $6A00,   {92    F3                 3D }
     $6B00,   {93    F4                 3E }
     $6C00,   {94    F5                 3F }
     $6D00,   {95    F6                 40 }
     $6E00,   {96    F7                 41 }
     $6F00,   {97    F8                 42 }
     $7000,   {98    F9                 43 }
     $7100,   {99    F10                44 }

     $7800,   {9A    1                  02 }
     $7900,   {9B    2                  03 }
     $7A00,   {9C    3                  04 }
     $7B00,   {9D    4                  05 }
     $7C00,   {9E    5                  06 }
     $7D00,   {9F    6                  07 }
     $7E00,   {A0    7                  08 }
     $7F00,   {A1    8                  09 }
     $8000,   {A2    9                  0A }
     $8100,   {A3    0                  0B }
     $8200,   {A4    -                  0C }
     $8300,   {A5    =                  0D }

     $A500    {A6   Ctrl-TAB            0F }
   );




Procedure NewInt9;
Assembler;
asm

{==== new INT9 / IRQ1 complete keyboard interrupt handler ========}

  push ax
  push bx
  push ds

  mov ax,seg @data               { load DATA segment/selector }
  xor bx,bx                      { set BX ready for indexing or fast 0-compare }
  mov ds,ax

  in al,$60                      { read keyboard }

  mov Int9key,al                 { for DEBUGGING }
  inc Int9Counter

  cmp  E0E1flag,1                { See if last scancode was E0/E1 }
  jae  @E0E1prefixed
  cmp  al,$E0                    { or current code is E0/E1  }
  jae  @handleE0E1

 @RecordKey:                     { update the boolean array with (adapted) AL }

  mov bl,al
  and bl,07Fh

  add al,al                      { if hi bit set, carry=1 }
  mov al,1
  sbb al,0                       { carry from key-release makes this zero. }

  mov byte ptr KeyArray[bx],al
  jz @EndRecord                  {  key released, no translation necessary }

  Mov NewKeyFlag,AL              {  flag set to 1 on any keypress }

  cmp byte ptr ASCIITranslate,0  {  if no ASCII wanted, quick exit    }
  jnz @OldstyleDigestKey         {  now BL contains key to translate  }
      @EndDigest:

 @EndRecord:

  mov al,$20                     { send End-Of-Interrupt to 8259  }
  out $20,al

  pop  ds
  pop  bx
  pop  ax
 iret

{ ........................... }

 @HandleE0E1:
  ja    @handleE1
  mov   E0E1flag,1      { treat next 1 code as E0-prefixed }
 jmp    @EndRecord

 @HandleE1:
  cmp   al,$E1
  jne   @HandleKbMsg    { even higher than E1 -> FA=ACK, FE=resend, FF=error }
  mov   E0E1flag,$20    { treat next 2 codes as E1-prefixed  }
 jmp    @EndRecord

 @HandleKbMsg:         { counts all kbd responses <>$FA as errors }
  cmp al,$FA           { ACK ? }
  je @Endrecord
  inc ErrorCounter     { for DEBUGGING }
 jmp @endrecord


@E0E1prefixed:
   ja @E1prefixed    {eq= E0 flag set; above =E1 prefix active }
   mov byte ptr E0E1flag,bl    { bl 0 on entry.. }

   mov bl,al
   and bl,$7F   { get the make-code }

   cmp al,$46   { PRESSED E0,46, = ctrl-pause (break) }
  je @TogglePauseState

{....................................

  Now, create THESE extra codes from the prefixed
  codes; mostly from the small 4/6 key pads

 Normal  Fixed
    35   5F  forward slash (/) on keypad
    37   54  prefixed * means PrtScr -> always translated to SysReq

    1C   59  pad ENTER    ( $58=F12 )
    1D   5A  RIGHT CTRL
    38   5B  RIGHT alT

    47   5C  enh HOME     ( new PAD stuff )
    48   5D  enh UP
    49   5E  enh PageUp
    4B   60  enh LEFT
    4C   61  ........     ( does not exist as prefixed code )
    4D   62  enh RIGHT
    4E   63  .........    ( does not exist as prefixed code )
    4F   64  enh End
    50   65  enh DOWN
    51   66  enh PageDown
    52   67  enh INSERT
    53   68  enh Delete

.......................................... }

   cmp bl,$2A        { ignore any fake left/right  shift press/release }
   je @EndRecord
   cmp bl,$36
   je @EndRecord

   mov ah,$1C-$59    { preloaded correction}
   cmp bl,$1C        { keypad enter }
   je @ApplyNewCode

   mov ah,$1D-$5A
   cmp bl,$1D        { right ctrl }
   je @ApplyNewCode

   mov ah,$35-$5F
   cmp bl,$35        { keypad SLASH }
   je @ApplyNewCode

   mov ah,$37-$54
   cmp bl,$37        { prefixed '*' means PRtscr/sysrq key }
   je @ApplyNewCode

   mov ah,$38-$5B
   cmp bl,$38        { react to right alt }
   je @ApplyNewCode

  { now Check all the 6/4 pad keys }
   mov ah,$47-$5C
   cmp bl,ScanPadFirst { $47 }
   JB @EndRecord
   cmp bl,ScanPadLast  { $53 }
   ja @EndRecord {we've Checked all 'E0' keys we know...}

  { convert all the 6-pad/4-pad keys to new scancodes }
  @ApplyNewCode:
     SUB al,ah

  jmp @RecordKey

{......................}

@E1prefixed:                  { prefixed by E1, only the PAUSE key. }
   SUB byte ptr E0E1Flag,$10  { $20 -> $10 -> $00 }
   cmp al,$1D                 { E1 1D sequence is unique to the PAUSE make-code. }
   jne @EndRecord
@TogglePauseState:
   xor byte ptr PauseStatus,1  { toggle only on pressing }
jmp @EndRecord

{========================================}

@OldstyleDigestKey: { make ASCII depending on keyboard status, plus update LEDS}
 push cx
 push di
 push si

 { bl has our key , BH = 0 }

 { == now calculate BIOS code to put in our buffer == }
 {    which depents on the shift/alt/ctrl state...    }
 { first get shift state by looking in the keypress-array }

 mov  cl,StatusFlags1

 mov  al,byte ptr KeyArray[AltLeft]
 or   al,byte ptr KeyArray[AltRight]
 add  al,al

 or   al,byte ptr KeyArray[CtrlLeft]
 or   al,byte ptr KeyArray[CtrlRight]
 add  al,al

 or   al,byte ptr KeyArray[ShiftLeft]
 add  al,al
 or   al,byte ptr KeyArray[ShiftRight]

 and  cl,0F0h  { mask out old states }
 or   cl,al    { set new states }
 mov StatusFlags1,cl

 and  al,0Fh

 { now  ALT:CTRL:SHIFTLEFT:SHIFTRIGHT  are low 4 bits of al }

 mov si,offset AltAscii
 mov di,offset AltExceptions
 cmp al,8
 jae @Translation    { alt takes precedence over ctrl and shift }

 mov si,offset CtrlAscii
 mov di,offset CtrlExceptions
 cmp al,4
 jae @TransLation    { ctrl takes precedence over shift }

 mov si,offset ShiftAscii
 mov di,offset ShiftExceptions
 cmp al,0
 jnz  @TestNumLockFirst  { any >0 state must be a shift here }

 mov si,offset NormalAscii
 mov di,offset NormalExceptions

  @TestNumLockFirst:     { only needed in shifted/nonshifted states... }
  test cl,NumLockFlag
  jnz  @NumLockChanges
  @FromNumLockChanges:


{ ========== translate only ASCII or entire 16-bit code ================ }

@Translation:

{ bl is our scan key / BH = 0 }

  cmp bl,MaxNewScan                   {max code to translate}
  ja @EndTranslation

  mov  ah,bl                    { scancode in ah }
  mov  al,byte ptr [si+bx]      { asciitable offset si -> ASCII into al }
  cmp  al,0FEh                  { FF=ignore, FE= a status-toggler key   }
  ja @EndTranslation
  je @CheckStatusKeys

  test cl,CapsLockFlag          { caps lock acts on ASCII codes A-Z, a-z }
  jnz  @CapsLockChanges
   @FromCapsLockChanges:

  test al,al
 jns @NoException               { high bit set= translate }
  { Load Exception }
   mov bl,al
   add bl,bl  { bl now immediately word ptr (high bit discarded) }
   mov ax,word ptr [di+bx]  { Exceptions offset in di }
 @NoException:


@axintoBuffer: {ax: al must have ASCII,ah the SCANCODE}
  mov si,KeyBufFirstFree
  mov bx,si

  add si,2      { point to next word in buffer }
  and si,$3F    { 3f = 64 bytes = 32 words, cyclic buffer }

  cmp si,KeyBufNextchar { new FirstFree cannot be NextChar, so }
 je @EndTranslation     { the buffer is full }

  mov word ptr KeyBuffer[bx],ax  { put 16-bit code into keyboard buffer }
  mov KeyBufFirstFree,si         { update pointer }

 @EndTranslation:  { end of PutInBuffer coroutine }
  pop si
  pop di
  pop cx
 jmp @EndDigest   { jump back to exit the interrupt }

{ ..................... }


@CapsLockChanges: {change only ASCII-keys A to Z, a to z }

 cmp  al,'A'
 jb   @FromCapsLockChanges
 cmp  al,'z'
 ja   @FromCapsLockChanges

 cmp  al,'a'
 jae  @Togglecaps
 cmp  al,'Z'
 ja   @FromCapsLockChanges

@togglecaps:
 xor al,$20             {toggles between lower and upper case}
jmp @axintobuffer

{....................... }

@NumLockChanges:
 cmp bl,$47
 jb @FromNumLockChanges
 cmp bl,$53
 ja @FromNumLockChanges

 { now reverse the shifted/nonshifted array indexes..}

  test al,al   { zero =nonshifted state}
 jnz @toggletoNormal

  mov si,offset ShiftAscii
  mov di,offset ShiftExceptions
jmp @FromNumLockChanges

 @ToggletoNormal:
  mov si,offset NormalAscii
  mov di,offset NormalExceptions
jmp @FromNumLockChanges


{ .............. }

@CheckStatusKeys:  { does bl contain a status key make-code? }

{ update status-toggles from bl }

mov ah,CapsLockFlag
cmp bl,$3A
je  @UpdateStatus

mov ah,NumLockFlag
cmp bl,$45
je  @UpdateStatus

mov ah,ScrollLockFlag
cmp bl,$46
jne  @EndTranslation

{.........}

@UpdateStatus:
 { mov cl,StatusFlags1 : already.. }
  xor ah,cl            { StatusFlags1 flag update }
  mov StatusFlags1,ah
  mov bl,$ED           { command ED : update LEDS *plus*  internal kbd status }
  call @KeyCommand
  jnz  @Endtranslation { Z flag clear in case of command-wait overflow }
  mov bl,ah
  shr bl,4
  and bl,7
  call @KeyCommand
jmp @EndTranslation

{=========================}

@KeyCommand:
  mov    cx,$2000 { safety timeout count, usually less than 100 cycles needed }
 @Port64Wait:
  in     al,064h
  and    al,002h
 Loopnz  @Port64Wait
 jnz @Exit64Error
  mov    al,bl
  out    060h,al { unlike most BIOS Int9 handlers, don't wait for kbd ACK }
 @Exit64Error:
  retn

end;

{==== end of INT9/IRQ1 keyboard interrupt server  ========}







Procedure UpdateLEDS(LedStatus:byte);
Assembler;
asm
jmp @UpdateMain

 {== write-to-kbd procedure ==}
  @KeyCommand:

   mov    cx,$2000   {  safety timeout loop counter }
  @Port64Wait:
   in     al,064h
   and    al,002h
  loopnz  @Port64Wait
 jnz  @exit64Error

  @IssueCommand:
   mov    al,bl
   out    060h,al

  @exit64Error:
  retn
 {============================}

@updateMain:
  mov  bl,$ED            { led + status update command }
  call @Keycommand
  jnz @exit              { error, 64 not ready }
  mov  bl,LedStatus
  and  bl,7
  call @Keycommand
  @Exit:
end;

{
            7-3210 Keyboard Status Indicator Option Byte
                   Scroll-Lock indicator  (0=off, 1=on)
                  Num-Lock indicator  (0=off, 1=on)
                 Caps-Lock indicator  (0=off, 1=on)
               reserved (must be zero)
}









Function  ScanAvail:boolean;
Assembler;
asm
 mov  ax,KeyBufFirstFree    {if these ptrs are not equal there are keys waiting }
 cmp  ax,KeyBufNextChar
 mov  al,0
 je   @Exit
 inc  ax
 @Exit:
end;




Function  ReadScan:word;
Assembler;
asm
  mov   ax,KeyBufNextChar
 @waitforkey:
  cmp   ax,KeyBufFirstFree
 je @WaitForKey   { repeat until INT9 puts something in buffer }

  mov   si,ax
  add   ax,2
  and   ax,$3F
  mov   KeybufNextChar,ax { cycle scancode ptr one word forward}

  mov   ax,word ptr keybuffer[si]  { AX is output from buffer}
end;




Function NewKeyPressed:Boolean;
Assembler;
asm
                       { key is pressed when (ScanAvail) or (ExtKeySave<>0) }
 mov ax,1
 cmp ExtKeySave,ah     { compare to 0 }
 jnz @exit

 call ScanAvail        { also returns boolean, AL = 0 or 1 for False or True }
 @exit:
end;




Function NewReadKey:Char;
Assembler;
asm

 @WaitforNewKey:
  call    NewKeyPressed
  test    al,al
 jz      @WaitforNewKey

 xor  ax,ax
 xchg al,ExtKeySave     { first look if we saved an extended scancode byte}
 test al,al
 jnz @exit

 call  ReadScan         { if al<>0 it is a simple, single ASCII code}
 test  al,al
 jnz @exit
 mov  ExtKeySave,AH     { if al=0 then save scancode byte as second character }

 @exit:
end;




Procedure FlushKeys;
Assembler;
asm
 xor ax,ax
 mov KeybufFirstfree,ax
 mov KeybufNextchar,ax
 mov ExtKeySave,al
 mov NewKeyFlag,al
end;




Procedure ResetKeyArray;
Assembler;
asm
 xor  ax,ax
 mov  di,offset KeyArray
 mov  cx,maxnewscan
 inc  cx

 cld               { officially CLD is not needed in Borland pascal }

 push ds
 pop  es           { keyarray must be in BP's data segment }
 shr  cx,1         { byte count -> word count }
 rep  stosw
 jnc @exit
      stosb        { possible odd byte to do }
 @exit:
end;




Procedure UpdateBios;Assembler;  {copy our status flags to BIOS status flags }
asm
 mov  es,Seg0040
 mov  al,StatusFlags1

 {update BIOS' Status Flags 1  }
 mov  es:[017h],al

 {make sure LED states in Status Byte 2 match those in Status Flags 1}
 shr al,4
 and al,7

 and byte ptr es:[097h],$F8
 or  byte ptr es:[097h],al
end;




Procedure BiosCopy;Assembler;   {copy BIOS status flags to our status flags }
asm
 mov  es,Seg0040
 mov  al,es:[017h]
 or   StatusFlags1,al
end;



Procedure FlushBIOSbuffer;Assembler; {flush the BIOS buffer}
asm
 mov es,Seg0040
 mov ax,es:[01Ah]  {set next-char ptr and first-free ptr to same location}
 mov es:[01Ch],ax
end;




Procedure InstallKeyHandler;  Assembler;
asm

 {get current int9 address}
 mov  ax,03509h
 int  021h             { es:bx contain current int9 address}

 mov ax,cs
 mov dx,offset newint9

 mov cx,es
 cmp ax,cx             { is it our handler ? }
 jne @DovectorChange
 cmp dx,bx
 je  @SkipVectorChange { to prevent double installation }

 @DoVectorChange:

 {save old address in OLDINT9 }
 mov  word ptr oldint9   ,bx
 mov  word ptr oldint9+2 ,es

 {set int 9 vector to newint9 }
 push ds
  mov  ds,ax            { ds:dx is new vector,  dx already loaded }
  mov  ax,02509h
  int  021h
 pop ds

 @SkipVectorChange:

 call ResetKeyArray
 call FlushKeys

 mov E0E1flag,0

end;





Procedure RemoveKeyHandler;   Assembler;
asm

 { restore int 9 handler from OLDINT9 }
 push ds
  lds  dx,dword ptr oldint9
  mov  ax,02509h
  int  021h
 pop  ds

end;




Function EnhKbdDetect:Boolean; Assembler;
asm
  { check if enhanced kbd BIOS functions are supported }
  { by verifying the effect of the INT  16/AH=05h stuff key function }

  call FlushBiosBuffer

  mov ax,00500h
  mov cx,01234h
  int 016h

  mov ax,01100h    { try and read back dummy key}
  int 016h
  cmp ax,01234h
  jne  @exitfalse

  call FlushBiosBuffer { flush the stuffed key }

  @exitTrue:
    mov al,1
    jmp @exit

  @exitFalse:
    mov al,0
  @exit:

end;






END.
