
Program KeyTest;

{$A+,B-,D-,E-,F-,I-,L-,N-,O-,P-,Q-,R-,S-,T-,V-,X+,Y-} {* compilerswitches *}

uses KEYDPMI,CRT;

{                                                       }
{  Test program for KEYDPMI  beta version 0.1           }
{                                                       }
{  October 1995    by Erik de Neve    CIS:100121,1070   }
{                                                       }
{  See KEYDPMI.DOC for explanation and scancode lists   }
{                                                       }



const

CapsLockFlag   = $40;
NumLockFlag    = $20;
ScrollLockFlag = $10;


Function Int2Hex(L: LongInt; N:Integer): String;
Const    Digits : Array[0..15] Of Char = '0123456789ABCDEF';
Var      S : String;
Begin
  S:='';
  While N>0 Do Begin
    S:=Digits[L And $F]+S;
    Dec(N);
    L:=L Shr 4;
  End;
  Int2Hex:=S;
End;




Procedure DrawKeyGrid;
 var D:byte;
begin
    ClrScr;

    GotoXY(24,1);

{$IFDEF DPMI}
    Write('KEYDPMI keyboard handler running in protected mode');
{$ELSE}
    Write('KEYDPMI keyboard handler running in real mode');
{$ENDIF}

    GotoXY(1,1);
    WriteLn('  0123456789ABCDEF');

     WriteLn(' Ŀ');
    for D:=0 to 6 do
    WriteLn(D,'                ');
     WriteLn(' ');


    GotoXY(26,3);
    Write('press SHIFT-ESC to exit   ESC to clear screen');

    GotoXY(40,5);
    Write(' Errors: ');
    GotoXY(40,6);
    Write(' Last error input:');

    GotoXY(28,10);
    Write('Reported by NewKeyPressed: ');

    GotoXY(1,19);
    Write(' int 9 / IRQ1 counter [     ]');


    GotoXY(38,15);
    Write('"BIOS" scan word:');

    GotoXY(38,17);
    Write('ASCII:');


    GotoXY(1,21);
    WriteLn(' Raw port $60 input ');
    WriteLn('> ');

end;





Procedure TestKeyGrid;

type
  KeyGridType=array[0..127] of boolean;

var
  KeyGrid2: KeyGridType;
  Cyclkey:byte;
  Countaux:word;
  CharCount:word;
  Bufword:word;
  D:word;
  CH:char;

  OldErrorCounter:word;
  LastErrScan:byte;

begin

    InstallKeyHandler;
    BiosCopy;
    AsciiTranslate:=True;

    Int9Counter:=0;
    CountAux:=1;

    cyclkey:=0;
    lasterrscan:=0;
    charcount:=0;

    ErrorCounter:=0;
    olderrorcounter:=0;


    DrawKeyGrid;

     For D:=0 to MaxNewScan do KeyArray[D]:=False; {erase 'presseds'}
     for D:=0 to MaxNewScan do KeyGrid2[d]:=KeyArray[D];


    Repeat;
     repeat until Int9Counter<>CountAux;
     CountAux:=Int9Counter;


     if int9key=$81  then begin {ESC release resets screen}
                                ClrScr;
                                CyclKey:=0;
                                Int9Counter:=0;
                                Int9Counter:=0;
                                charcount:=0;
                                DrawKeyGrid;
                               end;


     For D:=0 to MaxNewScan do begin { write differences only }
                        if KeyGrid2[D]<>KeyArray[D] then begin
                               GotoXY(3+ D and 15,3+ D div 16);

                               if KeyArray[D]=True then
                               Write('') else Write('');

                               KeyGrid2[D]:=KeyArray[D];
                              end;

                        end;

          If ScanAvail then BufWord:=KeyBuffer[keybufnextchar shr 1];





          If NewKeyPressed then begin
                             GotoXY(54,10);
                             WriteLn('                ');

                             gotoXY(54,10);
                            While NewKeyPressed do begin
                             ch:=NewReadKey;
                             Write(Int2Hex(byte(ch),2):4);
                             if byte(CH)>=32 then Write('[',ch,']');
                            end;
                           end;


                   if errorCounter<>OldErrorCounter then begin
                        oldErrorCounter:=ErrorCounter;
                        LastErrScan:=Int9Key;
                        end;


          GotoXY(50,5);
          Write(ErrorCounter);
          GotoXY(58,6);
          Write(LastErrScan);


          GotoXY(4,12);If (StatusFlags1 and ScrollLockFlag)<>0 then
                                             Write('ScrollLock') else
                                             Write('          ');

          GotoXY(4,13);If (StatusFlags1 and CapsLockFlag)<>0 then
                                             Write('CapsLock') else
                                              Write('        ');


          GotoXY(4,14);If (StatusFlags1 and NumLockFlag)<>0 then
                                              Write('NumLock') else
                                              Write('       ');

          GotoXY(4,11);if PauseStatus then Write('PAUSE') else Write('     ');



          GotoXY(56,15);
          Write(Int2Hex(BufWord,4));

          GotoXY(45,17);
          if Lo(BufWord)>=32 then Write(char( Lo(BufWord) ) );


          GotoXY(24,19);Write(Int9Counter:5);

          if CyclKey>0 then begin
                  GotoXY(3+cyclkey*3,22);
                  Write(Int2Hex(int9key,2));
                  end;

          Inc(CyclKey);
          if cyclkey>25 then cyclkey:=1;


    Until (KeyArray[1] and (keyarray[$2a] or keyarray[$36])); {shift-ESC ends}

    RemoveKeyHandler;
    UpdateBios;

end;




begin

  if EnhKbdDetect then TestKeyGrid
     else WriteLn(' No enhanced keyboard detected.');

end.


