#ifndef __BIOS10_
	#include "C:\tc\bios10.h"
#endif
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
int Get_Tick(void)
{
// this function uses the internal time keeper timer i.e. the one that goes
// at 18.2 clicks/sec.  You can find a 32 bit value of
// this timer at 0000:046Ch
unsigned int far *clock = (unsigned int far *)0x0000046CL;
unsigned int now;
// get current time
now = abs(*clock);
return now;
}



// disolve the screen...in one line I might add!
void Desolve_256(void)
{
for (long index=0; index<=300000; index++,Plot_Pixel_Fast(rand()%320, rand()%200, 0));
return;
} // end Desolve_PCX_256


void Plot_Pixel_Fast(int x,int y,unsigned char color)
{

// plots the pixel in the desired color a little quicker using binary shifting
// to accomplish the multiplications

// use the fact that 320*y = 256*y + 64*y = y<<8 + y<<6

video_buffer[((y<<8) + (y<<6)) + x] = color;

} // end Plot_Pixel_Fast


/*******************************************************
Function: void Write_Char_Page2(char chr,int page,int num)
INT 10 AH= 0x0A or 0x10
Description:
*******************************************************/
void Write_Char_Page2(char chr,int page,int num)
{
   union REGS regs;
   regs.h.ah = 0x0A;
   regs.h.bh = page;
   regs.h.al = chr;
   regs.x.cx = num;
   int86(0x10, &regs, &regs);
return;
}
/* ******************************************************
Function: void Write_Char_Page(char chr,int page,int num,int color)
INT 10 ah = 0x09
Description:Attribute set,Cursor not moved,Control characters
	    not processed
****************************************************** */
void Write_Char_Page(char chr,int page,int num,int color)
{
   union REGS regs;
   regs.h.ah = 0x09;
   regs.h.bh = page;
   regs.h.bl = color;
   regs.h.al = chr;
   regs.x.cx = num;
   int86(0x10, &regs, &regs);
return;
}


/*******************************************************
Function: void Write_Teletype(char ch,int color,int page)
INT 10 AH = 0x0E or 0x14
Description:
*******************************************************/
void Write_Teletype(char ch,int color,int page)
{
   union REGS regs;
   regs.h.ah = 0x0E;
   regs.h.al = ch;
   regs.h.bh = page;
   regs.h.bl = color;
   int86(0x10, &regs, &regs);
return;
}
//Same as above but accepts ASCII value
void Write_Teletype(int ch,int color,int page)
{
   union REGS regs;
   regs.h.ah = 0x0E;
   regs.h.al = ch;
   regs.h.bh = page;
   regs.h.bl = color;
   int86(0x10, &regs, &regs);
return;
}
//Same as above but gets current page twice as slow
void Write_Teletype(char ch,int color)
{
   union REGS regs;
   regs.h.ah = 0x0E;
   regs.h.al = ch;
   regs.h.bh = Get_Current_Page();
   regs.h.bh = color;
   int86(0x10, &regs, &regs);
return;
}








int Read_Pixel(int X,int Y,int page)
{
   union REGS regs;
   regs.h.ah = 0x0D;
   regs.h.bh = page;
   regs.x.cx = X;
   regs.x.dx = Y;
   int86(0x10, &regs, &regs);
return regs.h.al;
}


int Read_Pixel(int X,int Y)
{
   union REGS regs;
   regs.h.ah = 0x0D;
   regs.h.bh = Get_Current_Page();
   regs.x.cx = X;
   regs.x.dx = Y;
   int86(0x10, &regs, &regs);
return regs.h.al;
}



void Write_Pixel_XOR(int X,int Y,int color,int page)
{

   union REGS regs;
   regs.h.ah = 0x0C;
   regs.h.al = color; //Bit 7 of color if true will XOR it, HOW?????
   regs.h.bh = page;
   regs.x.cx = X;
   regs.x.dx = Y;
   int86(0x10, &regs, &regs);
return;
}


void Write_Pixel2(int X,int Y,int color)
{
   union REGS regs;
   regs.h.ah = 0x0C;
   regs.h.al = color;
   regs.h.bh = 0;
   regs.x.cx = X;
   regs.x.dx = Y;
   int86(0x10, &regs, &regs);
return;
}



void Write_Pixel(int X,int Y,int color,int page)
{
   union REGS regs;
   regs.h.ah = 0x0C;
   regs.h.al = color;
   regs.h.bh = page;
   regs.x.cx = X;
   regs.x.dx = Y;
   int86(0x10, &regs, &regs);
return;
}


void Write_Pixel(int X,int Y,int color)
{
   union REGS regs;
   regs.h.ah = 0x0C;
   regs.h.al = color;
   regs.h.bh = Get_Current_Page();
   regs.x.cx = X;
   regs.x.dx = Y;
   int86(0x10, &regs, &regs);
return;
}

void Write_Pixel(int X,int Y)
{
   union REGS regs;
   regs.h.ah = 0x0C;
   regs.h.bh = Get_Current_Page();
   regs.x.cx = X;
   regs.x.dx = Y;
   int86(0x10, &regs, &regs);
return;
}



void Border_Color(int color)
{
   union REGS regs;
   regs.h.ah = 0x0B;
   regs.h.bl = color;
   regs.h.bh = 0x00;
   int86(0x10, &regs, &regs);
return;
}

char Read_Char_Page(int *attribute,int page)
{
   union REGS regs;
   regs.h.ah = 0x08;
   regs.h.bh = page;
   int86(0x10, &regs, &regs);
   *attribute = regs.h.al;
return regs.h.al;
}

char Read_Char(int *attribute)
{
   union REGS regs;
   regs.h.ah = 0x08;
   regs.h.bh = Get_Current_Page();
   int86(0x10, &regs, &regs);
   *attribute = regs.h.al;
return regs.h.al;
}





/*******************************************************
Function: void Select_Page(int page)

Description:
*******************************************************/
void Select_Page(int page)
{
   union REGS regs;
   regs.h.ah = 0x05;
   regs.h.al = page;
   int86(0x10, &regs, &regs);
return;
}




/*******************************************************
Function: unsigned int Get_Current_Mode_Col(void)

Description:
*******************************************************/
unsigned int Get_Current_Mode_Col(void)
{
   union REGS regs;
   regs.h.ah = 0x0F;
   int86(0x10, &regs, &regs);
return  regs.h.al;
}





/*******************************************************
Function: unsigned int Get_Current_Page(void)

Description: Returns Current Page
*******************************************************/
unsigned int Get_Current_Page(void)
{
   union REGS regs;
   regs.h.ah = 0x0F;
   int86(0x10, &regs, &regs);
return regs.h.bh;
}


/*******************************************************
Function: void Get_CursorXY(int page,int *X,int *Y)

Description: Gets X&Y Location
*******************************************************/
void Get_CursorXY(int page,int *X,int *Y)
{
   union REGS regs;
   regs.h.ah = 0x03;
   regs.h.bh = page;
   int86(0x10, &regs, &regs);
   *X = regs.h.dl;
   *Y = regs.h.dh;
return;
}
int  Get_CursorY(int page)
{
   union REGS regs;
   regs.h.ah = 0x03;
   regs.h.bh = page;
   int86(0x10, &regs, &regs);
return regs.h.dh;
}
int Get_CursorX(int page)
{
   union REGS regs;
   regs.h.ah = 0x03;
   regs.h.bh = page;
   int86(0x10, &regs, &regs);
return regs.h.dl;
}



/*******************************************************
Function: void Get_Cursor_Type(int *cl,int *ch,int page)

Description:
*******************************************************/
void Get_Cursor_Type(int *cl,int *ch,int page)
{
   union REGS regs;
   regs.h.ah = 0x03;
   regs.h.bh = page;
   int86(0x10, &regs, &regs);
   *cl = regs.h.ch;
   *ch = regs.h.cl;
return;
}



/*******************************************************
Function: void Move_Cursor(int X,int Y,int page)

Description:
*******************************************************/
void Move_Cursor(int X,int Y,int page)
{
   union REGS regs;
   regs.h.ah = 0x02;
   regs.h.dl = X ;
   regs.h.dh = Y ;
   regs.h.bh = page;
   int86(0x10, &regs, &regs);
return;
}
void Move_Cursor(int X,int Y)
{
   union REGS regs;
   regs.h.ah = 0x02;
   regs.h.dl = X ;
   regs.h.dh = Y ;
   regs.h.bh = Get_Current_Page();
   int86(0x10, &regs, &regs);
return;
}
void Cursor_Home(void)
{
   union REGS regs;
   regs.h.ah = 0x02;
   regs.h.dl = 0 ;
   regs.h.dh = 0 ;
   regs.h.bh = 0;
   int86(0x10, &regs, &regs);
return;
}




/*******************************************************
Function: void Set_Cursor(int cl,int ch)

Description: Changes Cursor
*******************************************************/
void Set_Cursor(int cl,int ch)
{
   union REGS regs;
   regs.h.ah = 0x01;
   regs.h.ch = ch;
   regs.h.cl = cl;
   int86(0x10, &regs, &regs);
return;
}
void BLOCK_Cursor(void)
{
   union REGS regs;
   regs.h.ah = 0x01;
   regs.h.ch = 0;
   regs.h.cl = 7;

   int86(0x10, &regs, &regs);
return;
}
void NORMAL_Cursor(void)
{
   union REGS regs;
   regs.h.ah = 0x01;
   regs.h.ch = 6;
   regs.h.cl = 6;
   int86(0x10, &regs, &regs);
return;
}
void HIDDEN_Cursor(void)
{
   union REGS regs;
   regs.h.ah = 0x01;
   regs.h.ch = 20;
   regs.h.cl = 0;
   int86(0x10, &regs, &regs);
return;
}



/*******************************************************
Function: void Set_Mode(int mode)

Description: Changes Video Mode
*******************************************************/
void Set_Mode(int mode)
//INT 10H AH = 00h Set Video Mode
{
   union REGS regs;
   regs.h.ah = 0x00;
   regs.h.al = (unsigned char)mode;
   int86(0x10, &regs, &regs);
return;  //Returns 0 if valid
}
void VGA13_Mode(void)
{
   union REGS regs;
   regs.h.ah = 0x00;
   regs.h.al = 13;
   int86(0x10, &regs, &regs);
return;
}
void TEXT_Mode(void)
{
   union REGS regs;
   regs.h.ah = 0x00;
   regs.h.al = 3;
   int86(0x10, &regs, &regs);
return;
}





/*******************************************************
Function: unsigned int Get_Current_Mode(void)

Description:
*******************************************************/
unsigned int Get_Current_Mode(void)
{
   union REGS regs;
   regs.h.ah = 0x0F;
   int86(0x10, &regs, &regs);
return  regs.h.al;
}




