#include <graphics.h>
#include <conio.h>
#include <stdio.h>
#include <process.h>
#include <stdlib.h>
#include "c:\tc\graphvga.h"


//Global
int Max_X;
int Max_Y;

//******************************************************************
//********* Sets up Graphics mode for Mode you choose **************
//******************************************************************
//This is set up to default to VGA mode 9 640 by 480 16 colors
void InitGraphics(int VIDEOMODE=9)
{
int gdriver,gmode,errorcode;

/* register a driver that was added into graphics.lib */
/* For information on adding the driver, see the
/* BGIOBJ section of UTIL.DOC */
errorcode = registerbgidriver(EGAVGA_driver);

/* report any registration errors */
if (errorcode < 0)
{
   printf("Graphics error: %s\n", grapherrormsg(errorcode));
   printf("Press any key to halt:");
   getch();
   exit(1); /* terminate with an error code */
}

switch(VIDEOMODE)
	{
     case 1:  gdriver = CGA, gmode = CGAHI; break;
     case 2:  gdriver = EGA, gmode = EGAHI; break;
     case 3:  gdriver = EGA, gmode = EGALO; break;
     case 4:  gdriver = EGA64, gmode = EGALO;break;
     case 5:  gdriver = EGA64, gmode = EGAHI;break;
     case 6:  gdriver = VGA, gmode = VGALO; break;
     case 7:  gdriver = VGA, gmode = VGAMED; break;
     case 8:  gdriver = IBM8514, gmode = IBM8514LO; break;
     case 9:  gdriver = VGA, gmode = VGAHI; break;
     default:
	 detectgraph(&gdriver, &gmode);
	 break;
	}

   initgraph(&gdriver, &gmode, "");
   if ( (errorcode = graphresult()) != grOk)
   {
	printf("Graphics error: %s\n", grapherrormsg(errorcode));
	printf("Press any key to halt:");
	getch();
	exit(1); /* terminate with an error code */
   }
cleardevice();
Max_X = getmaxx();
Max_Y = getmaxy();
return;
}



//******************************************************************
//********************** Draws a Box *******************************
//******************************************************************
// X     -> upper left horiz corner of box
// Y     -> upper left vert  corner of box
//width  -> width of box starting from X to the right
//height -> height of box starting from Y down
//color well is color ...it restores color before leaving
//fillsw ->  1 Draws a filled box using indiviual pixels
//           0 Draws a empty box
//           3 Draws a filled box using floodfill()
//NOW E...-> There are other ways to draw a filled box, but
//this is easier to understand. Basically less different
//graphics calls.
//This is set up with default peramaters to fill screen with a blue
//Background
void DrawBox(int X=1,int Y=1,int width=Max_X,int height=Max_Y,int color=BLUE,int fillsw=3)
{
int Local_X;
int Local_Y;
int Local_Width = X + width;
int Local_Height = Y + height;
int oldcolor = getcolor();
Hide_Mouse();
   if(fillsw == 1)
    {
	for(Local_Y = Y;Local_Y < Local_Height; Local_Y++)
	  {
	       for(Local_X = X;Local_X < Local_Width;Local_X++)
		{
		putpixel(Local_X,Local_Y,color);
		}
	   }
     }
    else if(fillsw == 0)
     {
	setcolor(color);
	line(X,Y,X+width,Y);
	line(X+width,Y,X+width,Y+height);
	line(X+width,Y+height,X,Y+height);
	line(X,Y+height,X,Y);
	setcolor(oldcolor);
     }
    else if(fillsw == 3)
     {
	setcolor(color);
	line(X,Y,X+width,Y);
	line(X+width,Y,X+width,Y+height);
	line(X+width,Y+height,X,Y+height);
	line(X,Y+height,X,Y);
	setfillstyle(SOLID_FILL,color);
	floodfill(X+(width/2),Y+(height/2),color);
	setcolor(oldcolor);
     }
Display_Mouse();
return;
}





void DrawLine2(int x1,int y1,int x2,int y2,int sprite2=TRUE,int Line_Color=TRUE,int Line_Mouse = TRUE,int Line_Thickness=TRUE,int Line_Style=TRUE,int Line_Pattern=TRUE)
{
if(!Line_Mouse) Hide_Mouse();

struct linesettingstype lineinfo;

/* get information about current line settings */
getlinesettings(&lineinfo);
int oldstyle = lineinfo.linestyle;
int oldthick = lineinfo.thickness;
int oldpattern = lineinfo.upattern;

if(!Line_Thickness) setlinestyle(Line_Style,Line_Pattern,Line_Thickness);


int default_color = getcolor();
if(!Line_Color)     setcolor(Line_Color);


if(!sprite2) setwritemode(XOR_PUT);

line(x1,y1,x2,y2);

if(!sprite2) setwritemode(COPY_PUT);



if(!Line_Color)     setcolor(default_color);
if(!Line_Thickness) setlinestyle(oldstyle,oldpattern,oldthick);
if(!Line_Mouse) Display_Mouse();
return;
}







void DrawLine(int x1,int y1,int x2,int y2,int sprite2=TRUE)
{

if(!sprite2) setwritemode(XOR_PUT);

line(x1,y1,x2,y2);

//if(!sprite2) setwritemode(COPY_PUT);

return;
}
