#ifndef __MOUSE_H
	#define __MOUSE_H


#define TRUE -1
#define FALSE 0
#define OR ||
#define AND &&
#define	RESETMOUSE 0x0000
#define MOUSE_INTERRUPT 0x33
#define SHOWMOUSE 0x01
#define HIDEMOUSE 0x02
#define MOUSEPOSITION 0x03
#define MOVEMOUSE 0x04
#define BUTTON_PRESS_XY 0x05
#define BUTTON_RELEASE_XY 0x06
#define MOUSELIMITX 0x07
#define MOUSELIMITY 0x08
#define CURSORSHAPE 0x09
#define HIDEMOUSEXY 0x10
#define MOUSEMOTION 0x0B
#define SETMOUSESENSITIVITY 0x1A
#define GETMOUSESENSITIVITY 0x1B
#define JOYSTICK_RESET 0x8400
#define JOYSTICK_INTERRUPT 0x15
#define JOYSTICKBUTTONS 0
#define BOOL(x) (!(!(x)))
#define JOYSTICK_XY 1
#include "c:\tc\mouse.cpp"

//Mouse Functions



 //Checks to see if mouse is present and sets MousePresent to TRUE or FALSE
 //Returns True if Mouse present, FALSE otherwise
extern int Detect_Mouse(void);

 //Returns number of mouse buttons available.
 //Uses same call as Detect_Mouse, just wanted a seperate function
 //for it, but it will reset mouse!
extern int Number_Of_Buttons(void);

//Moves mouse to new X,Y position.
extern void Move_Mouse(int Mouse_X,int Mouse_Y);

//Shows Mouse cursor
extern void Display_Mouse(void);

//Hides Mouse cursor
extern void Hide_Mouse(void);

//X & Y are set to current mouse X,Y position
//returns 0x00 if no     mouse button pressed
//        0x01 if left   mouse button pressed
//        0x02 if right  mouse button pressed
//        0x04 if center mouse button pressed
extern int Mouse_Position(int *Mouse_X,int *Mouse_Y);

//Same as above, will return the value of the button HELD down
//Simplier function call
extern int Mouse_Status(void);//Checks to see if any mouse buttons held down

//Sets Mouse Y limits of movement
extern void Vert_Mouse_Limit(int Mouse_Y_Min,int Mouse_Y_Max);

//Sets Mouse X limits of movement
extern void Horiz_Mouse_Limit(int Mouse_X_Min,int Mouse_X_Max);

//Gets the current mouse settings Speed_X   = Horiz mickeys per 8 pixels
//                                Speed_Y   = Vert  mickeys per 8 pixels
//                                threshold = Double speed threshold in mickeys per second
extern void Mouse_Sens(int Speed_X,int Speed_Y,int threshold);

//Same as above but sets the values.
void Mouse_Sens(int Speed_X,int Speed_Y,int threshold);


//Mickeys_X and Y returns the number of mickeys moved since
//LAST call to this function
extern void Mouse_Motion(int *Mickeys_X,int *Mickeys_Y);

//Changes current mouse shape
//default         0 >   Arrow
//cursor_select = 1     Space Ship
//                2     Car
//                3     Hand
//                4     HourGlass
//                5     Text
//                6     Pencil
extern void Cursor_Shape(int cursor_select);

//This Function starts a Forever LOOP until the mouse
//Button is released!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
extern void Button_Up(void);


//Button_Check is set to the same value as below
//this will check the particular button and then
//the function will
//return 0x00 if no     mouse button pressed
//       0x01 if left   mouse button pressed
//       0x02 if right  mouse button pressed
//       0x04 if center mouse button pressed
//X & Y are set to current mouse X,Y position of Button Release
int Button_Release_XY(int *Mouse_X,int *Mouse_Y,int Button_Check);



//Joystick Functions
extern int JoyStick_Switches(int *switch_0,int *switch_1,int *switch_2,int *switch_3);
extern int JoyStick_XY(int *A_X,int *A_Y,int *B_X,int *B_Y);

//**********************************************************
//**** Hide's mouse in a particular section of screen      *
//**** This will turn off Mouse Display                    *
//**** & won't turn it back on so use Display_Mouse        *
//**** It's better to just test the mouse X,Y so that      *
//**** when it's in a region you can just use Hide_Mouse() *
//**********************************************************
extern void Hide_Mouse_XY(int left_X,int right_X,int top_Y,int bottom_Y);

#endif
//EOF