//PCX Picture Viewer
//(C) as Freeware 1994 by Marty A. Lineberry
//Only in 480 by 640 but can easily be modified
#ifndef action.cpp
#define action.cpp
#endif


//*******************************************************************
//*********** Function Photo-Types ***********************************
//*******************************************************************
int Display_PCX(char *FILENAME);
void DrawBitPlane(int n, int Vertical_Y_Line, char *Picture_Buffer);





//**********************************************************
//****************** Global Variables **********************
//**********************************************************
struct PCXHEADER
{
      char           Check_For_10;          	// Always 10 for PCX
      char           PCX_Version_Number;   	// Version info
      char           RLE_Encoding;     		// Set to 1
      char           Bits_Per_Pixel;  		// Bits per pixel
      unsigned short Upper_Left_X;     		// Image bounds in pixels
      unsigned short Upper_Left_Y;     		//     "
      unsigned short Lower_Right_X;    		//     "
      unsigned short Lower_Right_Y;     	//     "
      unsigned short Horiz_Resolution; 		// Image resolution in dpi
      unsigned short Vert_Resolution;           //     "
      unsigned char  Color_Palette_16_[48];     // Palette
      char           BIOS_Video_Mode;           // Junk info
      char           Number_Of_BitPlanes;     	// Plane count (v2.5=0)
      unsigned short Bits_Per_Line;    		// Bytes per line
      unsigned short Color_or_BW; 		// 1 for color, 2 for gray
      unsigned short Screen_Width;       	// Screen size in pixels
      unsigned short Screen_Height;       	//     "
      char           Junk_54_Zeros[54];		// Junk...just 0's

};


// Default palette.
char Default_Palette[48] =
{
   0x00,0x00,0x0E,0x00,0x52,0x07,0x2C,0x00,
   0x0E,0x00,0x00,0x00,0xF8,0x01,0x2C,0x00,
   0x85,0x0F,0x42,0x00,0x21,0x00,0x00,0x00,
   0x00,0x00,0x6A,0x24,0x9B,0x49,0xA1,0x5E,
   0x90,0x5E,0x18,0x5E,0x84,0x14,0xD9,0x95,
   0xA0,0x14,0x12,0x00,0x06,0x00,0x68,0x1F
};
unsigned char pcxpalette[48];
PCXHEADER pcx_header_info;
char *screenLinePointers[480];





//***************************************************
//************* Displays PCX Picture ****************
//***************************************************

int Display_PCX(char *FILENAME)
{
//variables declarations
FILE *PCX_FILE_HANDLE;
char *Picture_Buffer = new char[320];
int PCX_Header_Size = sizeof(PCXHEADER);
int bytesRead;
int byteCount, data, runCount, temp;
int Vertical_Y_Line;

// Initialize addresses of screen lines.
for (temp=0; temp<480; ++temp)
   screenLinePointers[temp] = (char *)MK_FP(0xa000, temp*80);

//Clears Graphics screen
cleardevice();

//Opens File for Reading Only as Binary
PCX_FILE_HANDLE = fopen(FILENAME,"rb");

//Checks to see if file exist
if(PCX_FILE_HANDLE == NULL)
	{
	cout << "Graphics File Not Found\n";
	fclose(PCX_FILE_HANDLE);
	return FALSE;
	}
//Gets a copy of PCX Header and store it in HEADER Stucture
if(fread(&pcx_header_info,PCX_Header_Size,1,PCX_FILE_HANDLE) != 1)
	{
	cout << "Graphics Header File Corrupt\n";
	fclose(PCX_FILE_HANDLE);
	return FALSE;
	}
//Checks to see if it is PCX File
if(pcx_header_info.Check_For_10 != 10)
	{
	cout << "This is not a PCX Graphics File\n";
	fclose(PCX_FILE_HANDLE);
	return FALSE;
	}
//Checks PCX Version to wether or not use default Palette color info
if(pcx_header_info.PCX_Version_Number == 3)
	memcpy(pcxpalette,Default_Palette,48);
else
	memcpy(pcxpalette,pcx_header_info.Color_Palette_16_ ,48);


//seek to beggining of picture data
fseek(PCX_FILE_HANDLE,((unsigned long)PCX_Header_Size),SEEK_SET);

// Map EGA registers to first 16 DAC registers.
for (temp=0; temp<15; ++temp)
   setpalette(temp, temp);

// Store the palette in the DAC registers.
for (temp=0; temp<15; ++temp)
   {
   setrgbpalette(temp, pcxpalette[temp*3]>>2,
   pcxpalette[temp*3+1]>>2, pcxpalette[temp*3+2]>>2);
   }

   // Read and display 480 lines with four bit planes each.
   for (Vertical_Y_Line=0; Vertical_Y_Line<480; ++Vertical_Y_Line)
   {
	byteCount = 0;
	while (byteCount < 320)
	{
		// Get a byte of data.
		data = fgetc(PCX_FILE_HANDLE);

		// If this is a run-count byte...
		if (data > 192)
		{
			// Calculate the run count.
			runCount = data & 0x3f;

			// Get the data byte.
			data = fgetc(PCX_FILE_HANDLE);

			// Duplicate the data byte runCount times.
			for (temp=0; temp<runCount; ++temp)
			Picture_Buffer[byteCount++] = data;
		}
		else Picture_Buffer[byteCount++] = data;
	}

      // Output four bit planes.
      DrawBitPlane(1, Vertical_Y_Line, Picture_Buffer);
      DrawBitPlane(2, Vertical_Y_Line, &Picture_Buffer[80]);
      DrawBitPlane(4, Vertical_Y_Line, &Picture_Buffer[160]);
      DrawBitPlane(8, Vertical_Y_Line, &Picture_Buffer[240]);
   }

outp(0x3c4, 2);
outp(0x3c5, 15);
delete Picture_Buffer;
fclose(PCX_FILE_HANDLE);
return TRUE;
}

void DrawBitPlane(int n, int Vertical_Y_Line, char *Picture_Buffer)
{
   outp(0x3c4, 2);
   outp(0x3c5, n);
   for (int byte=0; byte<80; ++byte)

      screenLinePointers[Vertical_Y_Line][byte] = Picture_Buffer[byte];
}

