unit Mdiformu;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Menus;

type
  TMainForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    GRPEditor1: TMenuItem;
    INIEditor1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    Window1: TMenuItem;
    Cascade1: TMenuItem;
    ArrangeIcons1: TMenuItem;
    Help1: TMenuItem;
    Contents1: TMenuItem;
    SearchforHelpOn1: TMenuItem;
    HowtoUseHelp1: TMenuItem;
    N2: TMenuItem;
    AboutCOA1: TMenuItem;
    OpenDialog1: TOpenDialog;
    OpenDialog2: TOpenDialog;
    Options1: TMenuItem;
    FlyoverHelp1: TMenuItem;
    MatchCase1: TMenuItem;
    FirstOnly1: TMenuItem;
    ConfirmReplace1: TMenuItem;
    N3: TMenuItem;
    Tile1: TMenuItem;
    procedure GRPEditor1Click(Sender: TObject);
    procedure INIEditor1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Cascade1Click(Sender: TObject);
    procedure ArrangeIcons1Click(Sender: TObject);
    procedure Contents1Click(Sender: TObject);
    procedure SearchforHelpOn1Click(Sender: TObject);
    procedure HowtoUseHelp1Click(Sender: TObject);
    procedure AboutCOA1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FlyoverHelp1Click(Sender: TObject);
    procedure ConfirmReplace1Click(Sender: TObject);
    procedure Tile1Click(Sender: TObject);
  private
    { Private declarations }
    procedure CreateParams(var Params: TCreateParams); override;
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation
uses
  IniFiles, IniModU, GrpModU, RepFormU, AboutBox;

{$R *.DFM}

procedure TMainForm.GRPEditor1Click(Sender: TObject);
begin
  WITH OpenDialog1 DO
    IF Execute THEN
      WITH TGrpModForm.Create(Application) DO
        LoadFromFile(Filename);
end;

procedure TMainForm.INIEditor1Click(Sender: TObject);
begin
  WITH OpenDialog2 DO
    IF Execute THEN
      WITH TIniModForm.Create(Application) DO
        LoadFromFile(Filename);
end;

procedure TMainForm.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.Cascade1Click(Sender: TObject);
begin
  Cascade;
end;

procedure TMainForm.ArrangeIcons1Click(Sender: TObject);
begin
  ArrangeIcons;
end;

procedure TMainForm.Contents1Click(Sender: TObject);
begin
  Application.HelpCommand(HELP_CONTENTS, 0);
end;

procedure TMainForm.SearchforHelpOn1Click(Sender: TObject);
VAR PartKey : ARRAY[0..0] OF Char;
begin
  PartKey[0] := #0;
  Application.HelpCommand(HELP_PARTIALKEY, LongInt(@PartKey));
end;

procedure TMainForm.HowtoUseHelp1Click(Sender: TObject);
begin
  Application.HelpCommand(HELP_HELPONHELP, 0);
end;

procedure TMainForm.AboutCOA1Click(Sender: TObject);
begin
  AboutForm.ShowModal;
end;

procedure TMainForm.CreateParams(var Params: TCreateParams);
BEGIN
  Inherited  CreateParams(Params);
  WITH TIniFile.Create(ChangeFileExt(
    ExtractFileName(Application.ExeName),'.INI')) DO
    try
      Params.X := ReadInteger('Main', 'Left', 0);
      Params.Y := ReadInteger('Main', 'Top', 0);
      Params.Width := ReadInteger('Main', 'Width', 450);
      Params.Height := ReadInteger('Main', 'Height', 440);
    finally
      Free;
    END;
END;

procedure TMainForm.FormCreate(Sender: TObject);
VAR WinDir : String;
begin
  WITH TIniFile.Create(ChangeFileExt(
    ExtractFileName(Application.ExeName),'.INI')) DO
    try
      MatchCase1.Checked := ReadBool('Options', 'Match Case', FALSE);
      FirstOnly1.Checked := ReadBool('Options', 'First Only', FALSE);
      ConfirmReplace1.Checked := ReadBool('Options', 'Confirm Replace', FALSE);
      FlyoverHelp1.Checked := ReadBool('Options', 'Flyover Help', True);
    finally
      Free;
    END;
  GetWindowsDirectory(@WinDir[1], 144);
  WinDir[0] := Char(StrLen(@WinDir[1]));
  OpenDialog1.InitialDir := WinDir;
  OpenDialog2.InitialDir := WinDir;
end;

procedure TMainForm.FormDestroy(Sender: TObject);
begin
  WITH TIniFile.Create(ChangeFileExt(
    ExtractFileName(Application.ExeName),'.INI')) DO
    try
      WriteBool('Options', 'Match Case', MatchCase1.Checked);
      WriteBool('Options', 'First Only', FirstOnly1.Checked);
      WriteBool('Options', 'Confirm Replace', ConfirmReplace1.Checked);
      WriteBool('Options', 'Flyover Help', FlyoverHelp1.Checked);
      WriteInteger('Main', 'Left', Left);
      WriteInteger('Main', 'Top', Top);
      WriteInteger('Main', 'Width', Width);
      WriteInteger('Main', 'Height', Height);
    finally
      Free;
    END;
  Application.HelpCommand(HELP_QUIT, 0);
  WindowState := wsNormal;
  WITH TIniFile.Create(ChangeFileExt(
    ExtractFileName(Application.ExeName),'.INI')) DO
    try
    finally
      Free;
    END;
end;

procedure TMainForm.FlyoverHelp1Click(Sender: TObject);
begin
  WITH Sender AS TMenuItem DO
    BEGIN
      Checked := NOT Checked;
      IF Checked THEN Application.HintPause := 800
      ELSE Application.HintPause := -1;
    END;
end;

procedure TMainForm.ConfirmReplace1Click(Sender: TObject);
begin
  WITH Sender AS TMenuItem DO
    Checked := NOT Checked;
end;

procedure TMainForm.Tile1Click(Sender: TObject);
begin
  TileMode := tbVertical;
  Tile;
end;

end.
