unit Mystring;

interface

FUNCTION Trim(CONST S : String) : String;
FUNCTION StrChange(StartLoc : Word;
  VAR S : String; CONST Find, Rep : String;
  FirstOnly, MatchCase : Boolean;
  VAR Confirm, Continu : Boolean) : Boolean;
FUNCTION Contains(CONST S, Find : String;
  MatchCase : Boolean) : Boolean;

implementation
USES ConfirmU, SysUtils, WinTypes;

FUNCTION Trim(CONST S : String) : String;
VAR
  First, Last : Byte;
BEGIN
    First := 1;
    WHILE (First < Length(S)) AND
      ((S[First] = ' ') OR
       (S[First] = #9)) DO Inc(First);
    Last := Length(S);
    WHILE (Last >= First) AND
      ((S[Last] = ' ') OR
       (S[Last] = #9)) DO Dec(Last);
    IF Last >= First THEN
      Result := Copy(S, First, Last-First+1)
    ELSE
      Result := '';
END;

FUNCTION StrChange(StartLoc : Word;
  VAR S : String; CONST Find, Rep : String;
  FirstOnly, MatchCase : Boolean;
  VAR Confirm, Continu : Boolean) : Boolean;
{NON-recursive function to change string Find to
 string Rep wherever found in string S}
VAR
  Loc, First : Word;
BEGIN
  Result := False;
  IF Length(Find) = 0 THEN Exit;
  IF Length(S)+1-StartLoc < Length(Find) THEN Exit;
  First := StartLoc;
  WHILE True DO
    BEGIN
      IF MatchCase THEN
        Loc := Pos(Find, Copy(S, First, 255))
      ELSE
        Loc := Pos(Uppercase(Find),
                   Uppercase(Copy(S, First, 255)));
      IF Loc = 0 THEN Exit;
      IF FirstOnly AND (Loc > 1) THEN Exit;
      Loc := First + Loc - 1;
      IF Confirm THEN
        WITH ConfirmForm DO
          BEGIN
            InWhatMemo.Clear;
            InWhatMemo.Lines.Add(S);
            RepLabel.Caption := Find;
            WithLabel.Caption := Rep;
            CASE ShowModal OF
              idYES    : ;
              idNo     : Exit;
              8        : Confirm := False;
              idCancel : BEGIN
                           Continu := False;
                           Exit;
                         END;
            END;
          END;
      System.Delete(S, Loc, length(Find));
      System.Insert(Rep, S, Loc);
      First := Loc + length(Rep);
      Result := True;
      IF FirstOnly THEN Exit;
    END;
END;

FUNCTION Contains(CONST S, Find : String;
  MatchCase : Boolean) : Boolean;
BEGIN
  Result := False;
  IF Length(S) < Length(Find) THEN Exit;
  IF MatchCase THEN
    Result := Pos(Find, S) > 0
  ELSE
    Result := Pos(UpperCase(Find), UpperCase(S)) > 0;
END;

end.

