unit Repformu;
{2/15/95}
interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, DdeMan,
  Outline, ShellApi,
  MyString, GroupFile, GroupItem, Buttons;

type
  TRepForm = class(TForm)
    DdeClientConv1: TDdeClientConv;
    PanelStatus: TPanel;
    Label1: TLabel;
    EditFind: TEdit;
    EditRepl: TEdit;
    Bevel1: TBevel;
    BtnDoIt: TSpeedButton;
    procedure EditFindChange(Sender: TObject);
    procedure EditFindDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure EditFindDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure BtnDoItClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    FUNCTION TrimStringLogical(S : String; Level, Typ : Word) : String;
    PROCEDURE WMGetMinMaxInfo(VAR Msg : TWMGetMinMaxInfo);
      message WM_GETMINMAXINFO;
    procedure CreateParams(var Params: TCreateParams); override;
  public
    { Public declarations }
    PROCEDURE GrabLine(vOut : TOutline);
  end;

var
  RepForm: TRepForm;

implementation
USES GenVuU, IniModU, GrpModU, MdiFormU, FlistU, ConfirmU, IniFiles;

{$R *.DFM}
procedure TRepForm.CreateParams(var Params: TCreateParams);
BEGIN
  Inherited  CreateParams(Params);
  WITH TIniFile.Create(ChangeFileExt(
    ExtractFileName(Application.ExeName),'.INI')) DO
    try
      Params.X := ReadInteger('FindReplace', 'Left', 190);
      Params.Y := ReadInteger('FindReplace', 'Top', 0);
      Params.Width := ReadInteger('FindReplace', 'Width', 239);
      Params.Height := ReadInteger('FindReplace', 'Height', 162);
    finally
      Free;
    END;
END;

PROCEDURE TRepForm.WMGetMinMaxInfo(VAR Msg : TWMGetMinMaxInfo);
BEGIN
  WITH Msg.MinMaxInfo^ DO
    BEGIN
      PtMaxTrackSize := Point(Screen.Width, 162);
      PtMinTrackSize := Point(240, 162);
    END;
  Msg.Result := 0;
END;


FUNCTION TRepForm.TrimStringLogical(S : String;
  Level, Typ : Word) : String;
VAR StartLoc : Word;
BEGIN
  Result := '';
  CASE Typ OF
    1  : BEGIN {INI file line}
      IF S[1] = '[' THEN Exit;
      IF S[1] = ';' THEN Exit;
      StartLoc := Pos('=', S);
      IF StartLoc = 0 THEN Exit;
      Delete(S, 1, StartLoc);
      Result := S;
    END;
    2  : BEGIN {GRP file line}
      IF Level <> 2 THEN Exit;
      StartLoc := Pos(': ', S);
      IF StartLoc = 0 THEN Exit;
      Delete(S, 1, StartLoc+1);
      Result := S;
    END;
    3 : BEGIN {reg database line}
      StartLoc := Pos(' = ', S);
      IF StartLoc = 0 THEN Exit;
      Result := Copy(S, StartLoc+3, 255);
    END;
  END;
END;

procedure TRepForm.EditFindChange(Sender: TObject);
begin
  BtnDoIt.Enabled := (EditFind.Text <> '') AND
    (EditRepl.Text <> '');
end;

procedure TRepForm.EditFindDragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
begin
  Accept := Source IS TOutline;
end;

PROCEDURE TRepForm.GrabLine(vOut : TOutline);
BEGIN
  IF vOut.SelectedItem <= vOut.ItemCount THEN
    WITH vOut, Items[SelectedItem] DO
      EditFind.Text := TrimStringLogical(Text, Level, Tag);
END;

procedure TRepForm.EditFindDragDrop(Sender, Source: TObject; X, Y: Integer);
begin
  WITH Source AS TOutline DO
    IF SelectedItem >= 0 THEN
      WITH Items[SelectedItem] DO
        TEdit(Sender).Text := TrimStringLogical(Text, Level, Tag);
end;

procedure TRepForm.BtnDoItClick(Sender: TObject);
VAR
  N : Word;
  FileName, TempName, BakName : String;
  Ext : String[4];
  ChangedINI : Boolean;

  PROCEDURE ChangeINI(CONST Filename : String);
  VAR
    Tin, Tout : TextFile;
    S         : String;
    Confirm,
    Continu,
    OneChange : Boolean;

    FUNCTION ChangeLine(VAR S : String) : Boolean;
    VAR
      eqLoc : Word;
      LastHalf : String;
    BEGIN
      Result := False;
      {Don't change comments}
      IF S[1] = ';' THEN Exit;
      {Don't change section headers}
      IF S[1] = '[' THEN Exit;
      eqLoc := Pos('=', S);
      IF eqLoc = 0 THEN Exit;
      IF eqLoc = Length(S) THEN Exit;
      Result := StrChange(eqLoc+1, S, EditFind.Text,
        EditRepl.Text, MainForm.FirstOnly1.Checked,
        MainForm.MatchCase1.Checked,
        Confirm, Continu);
    END;

  BEGIN
    BakName := ChangeFileExt(Filename, '.~IN');
    TempName := ChangeFileExt(Filename, '.$$$');
    AssignFile(Tin, Filename);
    AssignFile(Tout, TempName);
    OneChange := False;
    Confirm := MainForm.ConfirmReplace1.Checked;
    IF Confirm THEN ConfirmForm.WhereLabel.Caption :=
      UpperCase(ExtractFileName(FileName));
    Continu := True;
    Try
      Reset(Tin);
      Rewrite(Tout);
      WHILE Continu AND (NOT EoF(Tin)) DO
        BEGIN
          ReadLn(Tin, S);
          IF ChangeLine(S) THEN OneChange := True;
          WriteLn(Tout, S);
        END;
    Finally
      CloseFile(Tin);
      CloseFile(Tout);
    End;
    {Won't reach here unless above succeeded}
    IF OneChange THEN
      BEGIN
        DeleteFile(BakName);
        RenameFile(Filename, BakName);
        RenameFile(TempName, FileName);
        ChangedINI := TRUE;
      END;
  END;

  PROCEDURE ChangeGRP(CONST Filename : String);
  VAR
    TGF : TGroupFileObj;
    N   : Word;
    S   : String;
    NameTemp, NameSave : String;
    Confirm, Continu : Boolean;
  BEGIN
    TGF := TGroupFileObj.Create;
    TGF.LoadFromFile(Filename);
    Confirm := MainForm.ConfirmReplace1.Checked;
    IF Confirm THEN ConfirmForm.WhereLabel.Caption :=
      UpperCase(ExtractFileName(FileName));
    Continu := True;
    FOR N := 0 TO TGF.Items.Count-1 DO
      WITH TGF.Items.Objects[N] AS TItemDataObj DO
        BEGIN
          S := Command;
          IF StrChange(1, S, EditFind.Text,
            EditRepl.Text, MainForm.FirstOnly1.Checked,
            MainForm.MatchCase1.Checked,
            Confirm, Continu) THEN
            Command := S;
          IF NOT Continu THEN Break;
          S := IconPath;
          IF StrChange(1, S, EditFind.Text,
            EditRepl.Text, MainForm.FirstOnly1.Checked,
            MainForm.MatchCase1.Checked,
            Confirm, Continu) THEN
            IconPath:= S;
          IF NOT Continu THEN Break;
          S := WorkDir;
          IF StrChange(1, S, EditFind.Text,
            EditRepl.Text, MainForm.FirstOnly1.Checked,
            MainForm.MatchCase1.Checked,
            Confirm, Continu) THEN
            WorkDir := S;
          IF NOT Continu THEN Break;
        END;
    IF TGF.Changed THEN
      BEGIN
        NameTemp := ChangeFileExt(TGF.GrpFileName, '.$$$');
        NameSave := ChangeFileExt(TGF.GrpFileName, '.~GR');
        TGF.SaveToFile(NameTemp);
        DeleteFile(NameSave);
        IF RenameFile(TGF.GrpFileName, NameSave) THEN
          IF RenameFile(NameTemp, TGF.GrpFileName) THEN
            WITH DdeClientConv1 DO
              BEGIN
                ConnectMode := ddeManual;
                SetLink('ProgMan', 'ProgMan');
                OpenLink;
                S := '[Reload('+TGF.WindowName+')]'+#0;
                ExecuteMacro(@S[1], TRUE);
                WHILE WaitStat DO
                Application.ProcessMessages;
                WITH Application.MainForm  DO
                  BringWindowToTop(handle);
                CloseLink;
              END;
      END;
    TGF.Free;
  END;

  PROCEDURE ChangeRegDatabase;
  VAR
    Confirm, Continu : Boolean;

    PROCEDURE OneKey(hkFrom : hKey; SubKey : PChar);
    VAR
      hkNew       : hKey;
      buff, value : ARRAY[0..255] OF Char;
      Index       : LongInt;
      ValSize     : LongInt;
      S           : String;
    BEGIN
      IF RegOpenKey(hkFrom, SubKey, hkNew) = ERROR_SUCCESS THEN
        BEGIN
          Index := 0;
          WHILE RegEnumKey(hkNew, Index, buff, 80) = ERROR_SUCCESS DO
            BEGIN
              ValSize := 80;
              RegQueryValue(hkNew, buff, value, valSize);
              IF ValSize >= 2 THEN
                BEGIN
                  S := StrPas(Value);
                  IF StrChange(1, S, EditFind.Text,
                    EditRepl.Text, MainForm.FirstOnly1.Checked,
                      MainForm.MatchCase1.Checked,
                      Confirm, Continu) THEN
                    BEGIN
                      StrPCopy(Value, S);
                      ValSize := Length(S);
                      IF RegSetValue(hkNew, buff, REG_SZ,
                        value, ValSize) <> ERROR_SUCCESS THEN
                      MessageDlg('Failed to change ' + StrPas(Value),
                        mtInformation, [mbOk], 0);
                    END;
                  IF NOT Continu THEN Break;
                END;
              OneKey(hkNew, buff);
              Index := Index + 1;
            END;
          RegCloseKey(hkFrom);
        END;
    END;

  begin
    Confirm := MainForm.ConfirmReplace1.Checked;
    IF Confirm THEN ConfirmForm.WhereLabel.Caption :=
      'REGISTRATION DATABASE';
    Continu := True;
    Cursor := crHourglass;
    OneKey(HKEY_CLASSES_ROOT, NIL);
    Cursor := crDefault;
  END;

begin
  WITH Application.Mainform DO
    FOR N := MDIChildCount DOWNTO 0 DO
      BEGIN
        IF MDIChildren[N] IS TGrpModForm THEN
          MDIChildren[N].Close {closee GRP editors}
        ELSE IF MDIChildren[N] IS TIniModForm THEN
          MDIChildren[N].Close {close INI editors}
        ELSE IF MDIChildren[N] IS TGenViewer THEN
          WITH MDIChildren[N] AS TGenViewer DO
            IF Outline1.Tag <> 3 THEN Close; {close GRP and INI viewers}
      END;
  ChangedINI := FALSE;
  Application.ProcessMessages;
  WITH FileListForm.LstBxSelFiles DO
    IF Items.Count > 0 THEN
      FOR N := 0 TO Items.Count-1 DO
        BEGIN
          ItemIndex := N;
          FileName := Items[ItemIndex];
          PanelStatus.Caption := 'Processing ' +
            FileName + '...';
          Application.ProcessMessages;
          Ext := UpperCase(ExtractFileExt(FileName));
          IF Ext = '.INI' THEN
            ChangeINI(FileName)
          ELSE IF Ext = '.GRP' THEN
            ChangeGRP(FileName);
      END;
  PanelStatus.Caption := 'Processing Registration '+
    'Database...';
  Application.ProcessMessages;
  ChangeRegDatabase;
  PanelStatus.Caption := 'Reloading Registration '+
    'Database Viewer...';
  Application.ProcessMessages;
  GenViewer.ReloadData;
  PanelStatus.Caption := '';
  IF ChangedINI THEN
    IF MessageDlg('Some INI files were changed.  '+
      'Changes may not take effect until you '+
      'restart Windows.  Restart now?',
     mtConfirmation, [mbYes, mbNo, mbHelp], 17) = IDYES THEN
       ExitWindows(EW_RESTARTWINDOWS, 0);
end;

procedure TRepForm.FormResize(Sender: TObject);
begin
  EditFind.Width := Width - 120;
  EditRepl.Width := EditFind.Width;
end;

procedure TRepForm.FormDestroy(Sender: TObject);
begin
  WindowState := wsNormal;
  WITH TIniFile.Create(ChangeFileExt(
    ExtractFileName(Application.ExeName),'.INI')) DO
    try
      WriteInteger('FindReplace', 'Left', Left);
      WriteInteger('FindReplace', 'Top', Top);
      WriteInteger('FindReplace', 'Width', Width);
      WriteInteger('FindReplace', 'Height', Height);
    finally
      Free;
    END;
end;

procedure TRepForm.FormCreate(Sender: TObject);
begin
  FormResize(Self);
end;

end.

