{                        
************************************************************************
                         C N V T   v1.0

  This program was created by me, Ives, in order to find a way
  to create data files for art.pas (from art.zip).  ART.PAS was
  written by someone else, I give the author most of the credit
  for the functions and code used for the calculations and stuff.
  If you want the original program files, download ART.ZIP.
  
  --------------------------------------------------------------

To use this program...

     CNVT infile outfile [BIN/int]  where [..] is the infile type

   EXAMPLE: "CNVT cube.3dd cube.3di" or "CNVT cube.3dd cube.3di BIN"

    result: This would give you a text file with integer values of
            the object file's points and lines.

  EXAMPLE2: "CNVT letter.3di letter.3dd INT"

    result: The text file that you create will be converted into
            the binary format used by 3DEMO.EXE.
  
  --------------------------------------------------------------

note: If you would like more information on the file format, see
      the file FORMAT.TXT

************************************************************************
}
program CNVT;
{$I-}
uses crt,Dos;
const
  Bins=True;
  Ints=False;
var
  cnt : integer;
  Direction:boolean;
  FileIn,FileOut:string;
type
  Point = record
    x,y,z : real;
  end;
  Line  = record
    FP,TP : real;
  end;
  f_real= file of real;

procedure error(j:integer);
var
  C: Char;
begin
  writeln;
  case j of
    1:writeln('Open File Error / Input File Not Found');
    2:writeln('Error Creating Output File');
    3:begin
        writeln('Output File Exists, replace it? (Y/n)');
        C:=Readkey; if C='n' then begin
          writeln;halt(1);end else exit;
      end;
    4:begin
       writeln('  Syntax:  CNVT infile outfile [BIN/int]');writeln;
       writeln('           (default = Binary to Int)');writeln;writeln;
       writeln('    EXAMPLE:  CNVT box.3db box.3di BIN');
     end;
 end;
 halt(1);
end;

procedure ReadBin;
var
  fyle1       :f_real;
  fyle2       :text;
  t1,t2,t3    :real;
  i,j         :byte;
  numOfPoints :integer;
  numOfLines  :integer;
  Sfile       :string[79];
begin
  assign(fyle1,FileIn);
  reset(fyle1);
  if ioResult <>0 then error(1);
  Sfile:=FSearch(FileOut,'');if Sfile=FileOut then error(3);
  assign(fyle2,FileOut);rewrite(fyle2);
  if ioResult <>0 then error(2);
  begin
    read(fyle1,t1);
    numOfPoints:=trunc(t1);
    writeln(fyle2,numOfPoints);
    for j:=1 to numOfPoints do begin
      read(fyle1,t1,t2,t3);
      writeln(fyle2,trunc(t1),' ',trunc(t2),' ',trunc(t3));
    end;
    writeln(fyle2);
    read(fyle1,t1);
    numOfLines:=trunc(t1);
    writeln(fyle2,numOfLines);
    for j:=1 to numOfLines do begin
      read(fyle1,t1,t2);
      writeln(fyle2,trunc(t1),' ',trunc(t2));
    end;
  end;
  close(fyle1);close(fyle2);
end;

procedure ReadInt;
var
  fyle1       :text;
  fyle2       :f_real;
  t1,t2,t3    :real;
  i,j         :byte;
  numOfPoints :integer;
  numOfLines  :integer;
  Sfile       :string[79];
begin
  assign(fyle1,FileIn);
  reset(fyle1);
  if ioResult <>0 then error(ioresult);
  Sfile:=FSearch(FileOut,'');if Sfile=FileOut then error(3);
  assign(fyle2,FileOut);rewrite(fyle2);
  if ioResult <>0 then error(2);
  begin
    read(fyle1,t1);
    numOfPoints:=trunc(t1);
    write(fyle2,t1);
    for j:=1 to numOfPoints do begin
      read(fyle1,t1,t2,t3);
      write(fyle2,t1,t2,t3);
    end;
    read(fyle1,t1);
    numOfLines:=trunc(t1);
    write(fyle2,t1);
    for j:=1 to numOfLines do begin
      read(fyle1,t1,t2);
      write(fyle2,t1,t2);
    end;
  end;
  close(fyle1);close(fyle2);
end;

function FindDir : boolean;
begin
  FileIn:=ParamStr(1);FileOut:=ParamStr(2);
  if ParamCount < 2 then error(4);
  if ParamCount = 3 then begin
    if 'int'=ParamStr(3) then FindDir:=ints;
    if 'INT'=ParamStr(3) then FindDir:=ints;end
  else FindDir:=bins;
end;

begin;
  if FindDir then ReadBIN else ReadInt;
end.
