/*
  3dfrac 3.0 by Aaron Contorer 1987-1989
  Draws three-dimensional fractal landscapes.
  Version for EGA and VGA in Quick C 1.0

  Please send the author a copy of anything interesting you make
  that uses parts of this code or parts of its design.
*/


#include <graph.h>
#include <conio.h>


/*Graphic design*/
#define  DEEP 7
#define  PARTS 256
#define  XA 0
#define  XB 450
#define  YA 0
#define  ZA 0
#define  YADD 38


/* Color indices */
#define WATERCOLOR 1
#define LANDCOLOR 2

float steep;
int sealevel;
int ybottom;


/* Function to draw the actual pixels onto the screen is defined as a
macro to increase execution speed. */
#define addline(x0,y0,z0, x1,y1,z1) if (z1 == -9999) {\
  _setcolor(WATERCOLOR);_setpixel((y0 >> 1) + x0, YADD + y0 + z0);\
  } else { _setcolor(LANDCOLOR);\
  _moveto((y0 >> 1)+x0, YADD+y0+z0);_lineto((y1 >> 1)+x1, YADD+y1+z1); }



float random()
/* Return random value 0 <= x < 1 */
{
	return rand() / 32768.0;
}



void frac(depth, x0,y0,x2,y2,z0,z1,z2,z3)
{
  int newz; /* new center point */
  int xmid,ymid,z01,z12,z23,z30;

  if (kbhit()) return;

  if (rand() < 16384) /* 50% chance */
	 newz = (z0+z1+z2+z3) / 4 + (int)(random() * ((y2-y0)* steep));
  else
	 newz = (z0+z1+z2+z3) / 4 - (int)(random() * ((y2-y0)* steep));
  xmid = (x0+x2) >> 1;
  ymid = (y0+y2) >> 1;
  z12 = (z1+z2) >> 1;
  z30 = (z3+z0) >> 1;
  z01 = (z0+z1) >> 1;
  z23 = (z2+z3) >> 1;
  depth--;
  if (depth>=0 ) {
    frac(depth, x0,y0, xmid,ymid, z0,z01,newz,z30);
    frac(depth, xmid,y0, x2,ymid, z01,z1,z12,newz);
    frac(depth, x0,ymid, xmid,y2, z30,newz,z23,z3);
    frac(depth, xmid,ymid, x2,y2, newz,z12,z2,z23);
  } else {
    if (newz<=sealevel ) { /*above sea level*/
      /*L to R*/
      addline(xmid,ymid,newz, x2,ymid,z12);
      addline(xmid,ymid,newz, x0,ymid,z30);
    } else {
      /*below "sea level"*/
      addline(xmid,ymid,sealevel, 0,0,-9999);
    }
  }
}


void waitabit()
{
	long i;
	for (i=0; i<0xFFF; i++) {
		if (kbhit()) {
			getch();
			i=0xfffffff; /* abort waiting */
		}
	}
}


int main()
{
  char c;

  _clearscreen(_GCLEARSCREEN);
  printf("\n3dfrac version 3.0 by Aaron Contorer, 1987-1989\n");
  printf("This is a graphics demo program that creates images resembling\n");
  printf("landscapes using three-dimensional fractal geometry.  These\n");
  printf("images are generated as you watch, using random numbers and a\n");
  printf("simple mathematical formula.\n\n");
  printf("This program works only on machines with EGA or VGA graphics\n");
  printf("cards.  You are free to copy it if you wish.\n");
  printf("Press <space> to run it now, or <esc> to cancel.\n");
  printf("Once the program is running, presssing any key will stop it.\n\n");
  printf("Author:  Aaron Contorer, president, Contorer Computing\n");
  printf("Mailing address:  Post Office Box 5056, Champaign, IL 61825, USA\n");

  do {
    c=getch();
  } while (c != 27 && c != 32);
  if (c==32 ) {
	 ybottom = 450;
	 if (!_setvideomode(_VRES16COLOR)) {
		ybottom = 300;
		if (!_setvideomode(_ERESCOLOR)) {
		  printf("Sorry, this program requires EGA or VGA graphics.\n");
		  exit(1);
		}
	 }
	 _remappalette(LANDCOLOR,_GREEN);
	 _remappalette(WATERCOLOR,_LIGHTBLUE);
	 /* srand(something time-related) */
    while (!kbhit()) {
      _clearscreen(_GCLEARSCREEN);
		steep = (random() / 2.5) + 0.5;
      sealevel = (int)(17*random()) - 8;
		frac(DEEP, XA,YA,XB,ybottom,ZA,ZA,ZA,ZA);
      if (!kbhit()) waitabit();
    }
    _setvideomode(_DEFAULTMODE);
    getch();
  }
  return 0;
}
