%TITLE "This is a simple assembler demonstration program."

; ******************************************************************
; This short program uses the DOS_get_date function 02ah of int 21h
;  to retrieve  the "current" date and place it first into a memory
;  variable,  and then convert it and send it to the printer, which
;  in this case is connected to LPT1.
; ******************************************************************

;+++++++++++
; Define stack segment. Should try and allow minimum of 80h bytes. I 
;  usually allow at least f0h  because my finger hits the "f" easier
;  than the "8" key.  I  also  try  and load some kind of consistant  
;  value into each byte, so I can (if I so desire to) later check to
;  see how much of my  stack  was  actually used. A somewhat obvious 
;  trick, but one that I learned  from the well known programmer and
;  author Tom Swan.
storage segment stack 'stack'
        db      0f0h dup('#')
storage ends
;+++++++++++

;+++++++++++
; Define data segment. Preloading buffer  with  letters representing 
;  month, day, and year, is simply for appearance. The "/" is placed
;  there though, so we won't  have  to insert it later. The "m", "d",
;  and "year" too will be over-written. 
data    segment 'data'
datefill        db      ('0m/0d/year'),0dh,0ah,'$'    
data    ends
;+++++++++++

;+++++++++++
; Start of code segment
code    segment 'code'
;+++++++++++

;+++++++++++
; Good to let assembler know which segments are which
assume ss:storage, ds:data, cs:code
;+++++++++++

;+++++++++++
; Start routine. 

start:  

mov     ax, data        ; Initialize  DS and ES 
mov     ds, ax          ;  to  address  of data 
mov     es, ax          ;  segment by way of AX

std                     ; Set write direction to access "datefill"              
                        ;  variable from high to low memory during 
                        ;  the  convert  and  write  routine below
        
mov     ah, 2ah         ; Dos  "get date"  function. This function 
                        ;  of  int  21h, gets the current date and
                        ;  loads it into AX, CX, and DX.
int     21h             
push    ax              ; Save the day_of_week  on the stack
push    dx              ; Save  month  number on  the  stack
push    cx              ; Save year  by  pushing  onto stack 
pop     ax              ; Get  ready  to  process  the  year
mov     di, offset datefill+9   ; Year  goes  into byte 9 of
                                ;  'data' offset  "datefill"          
call    convert_it              ; Call subroutine to convert
                                ;  and store year  in memory

pop     ax              ; Get day  by popping AX, from stack      
                        ;  and  separating  day  from  month
push    ax              ; Save  month  (now in AH) for later
xor     ah, ah          ; Month  not  needed  yet so dump it
mov     di, offset datefill+4   ; Set stage  for placing day 
                                ;  into "datefill"  variable       
call    convert_it              ; Convert and then store day

pop     ax              ; Pop  AX  from stack since it still             
                        ;  holds the month number
xchg    ah, al          ; Swap  AH  (containing month)  with
                        ;  AL  (still  holding day),  so  we
                        ;  can now process month
xor     ah, ah          ; Zero AH
mov     di, offset datefill+1   ; Point to location in memory        
                                ;  where  we  want  to insert
                                ;  the converted  month value
call    convert_it      ; Convert  and  store  in  "datefill"
 
;+++++++++++
; Initialize printer on LPT1
mov     ah, 01h         ; BIOS function number  to  initialize           
                        ;  printer
mov     dx, 0000h       ; Select printer one                         
int     17h             ; BIOS printer services                       
;+++++++++++                                            

;+++++++++++
; Write memory contents to printer
mov     ah, 40h         ; DOS  function  to  write  to  file or     
                        ;  or device (namely "printer") .... :)
mov     bx, 04h         ; Load filehandle (printer=04)  into BX                                
mov     cx, 0ch        
mov     dx, offset datefill     ; Last-but-not-least of routine      
                                ;  to  retrieve  date,  convert, 
                                ;  and  save  in  our  variable.
                                ;  .... put the  coffee or cocoa
                                ;  on, we're almost done.
int     21h        
;+++++++++++                                        

;+++++++++++
; We're finished, so let's assemble, link, play with it for 
;  5 or 10 minutes, then move on to something else.........
exit:
mov     ah, 04ch        ; DOS function to wrap-it-up and get-out
int     21h             ; Call DOS.    ............ Seeya' later

;+++++++++++
; Procedure to convert
convert_it proc    

mov     cx, 000ah       ; Place in CX, the value of base that we 
                        ;  will be converting to 

do_it:
                                        
sub     dx, dx          ; C
div     cx              ;  o
xchg    dx, ax          ;   n
add     al, 30h         ;    v
stosb                   ;     e
xchg    dx, ax          ;      r
cmp     ax, 0000        ;       t  to decimal then to ascii decimal
jnz     do_it           ; And put in  location  pointed to by DS:DI
ret                      

convert_it endp

code    ends
end     start
end

