{

   TDBLookupCombo Plus Component Registration Module
   DB Aware Components for Delphi

   Copyright (c) 1995 Out & About Production, All Rights Reserved

}

unit Dbluplus;

interface

uses Classes, DsgnIntf, DBLup2;

procedure Register;

implementation

uses DBTables;

{ TDBStringProperty }

type
  TDBStringProperty = class(TStringProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure GetValueList(List: TStrings); virtual; abstract;
    procedure GetValues(Proc: TGetStrProc); override;
  end;

function TDBStringProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paValueList, paSortList, paMultiSelect];
end;

procedure TDBStringProperty.GetValues(Proc: TGetStrProc);
var
  I: Integer;
  Values: TStringList;
begin
  Values := TStringList.Create;
  try
    GetValueList(Values);
    for I := 0 to Values.Count - 1 do Proc(Values[I]);
  finally
    Values.Free;
  end;
end;

{ TIndexNameProperty }

type
  TIndexNameProperty = class(TDBStringProperty)
  public
    procedure GetValueList(List: TStrings); override;
  end;

procedure TIndexNameProperty.GetValueList(List: TStrings);
begin
  if (GetComponent(0) as TDBLookupComboPlus).LookUpSource <> nil then
  ((GetComponent(0) as TDBLookupComboPlus).LookUpSource.DataSet as TTable).GetIndexNames(List);
end;

procedure Register;
begin
  RegisterComponents('Data Controls', [TDBLookupComboPlus]);
  RegisterPropertyEditor(TypeInfo(string), TDBLookupComboPlus, 'LookupIndex', TIndexNameProperty);
end;

end.
