unit Main;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, Menus, Findfile, FileCtrl,
  TabNotBk;

type
  TMainForm = class(TForm)
    tabSearch: TTabbedNotebook;
    Label6: TLabel;
    ListBox1: TListBox;
    butDelete: TButton;
    chkConfirm: TCheckBox;
    FF1: TFindFiles;
    Label8: TLabel;
    DriveComboBox1: TDriveComboBox;
    dirList: TDirectoryListBox;
    Label9: TLabel;
    labStartDir: TLabel;
    chkSearchSubDirs: TCheckBox;
    GroupBox1: TGroupBox;
    chkBackups: TCheckBox;
    chkDelphi: TCheckBox;
    chkTemp: TCheckBox;
    chkText: TCheckBox;
    chkReadme: TCheckBox;
    chkArchive: TCheckBox;
    txtOther: TEdit;
    chkOther: TCheckBox;
    butScan: TButton;
    butClose: TButton;
    GroupBox2: TGroupBox;
    labCurDir: TLabel;
    labMatchCount: TLabel;
    labMatchSize: TLabel;
    labAllCount: TLabel;
    labAllSize: TLabel;
    Label4: TLabel;
    Label3: TLabel;
    Label2: TLabel;
    Label1: TLabel;
    Label5: TLabel;
    procedure butScanClick(Sender: TObject);
    procedure butCloseClick(Sender: TObject);
    procedure FF1DirChange(Sender: TObject);
    procedure FF1FileMatch(Sender: TObject);
    procedure DriveComboBox1Change(Sender: TObject);
    procedure butDeleteClick(Sender: TObject);
    procedure chkSearchSubDirsClick(Sender: TObject);
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.butScanClick(Sender: TObject);
begin
    ListBox1.Clear;
    butScan.Enabled := False;
    butDelete.Enabled := True;
    butClose.Caption := '&Cancel';

    FF1.InitDir := labStartDir.Caption;

    FF1.PatternList.Clear;
    if chkBackups.State = cbChecked then
        FF1.PatternList.Add('*.bak');
    if chkDelphi.State = cbChecked then
        FF1.PatternList.Add('*.~*');
    if chkTemp.State = cbChecked then
        FF1.PatternList.Add('*.tmp');
    if chkText.State = cbChecked then
        FF1.PatternList.Add('*.txt');
    if chkReadme.State = cbChecked then
        FF1.PatternList.Add('readme.*');
    if chkArchive.State = cbChecked then
    begin
        FF1.PatternList.Add('*.zip');
        FF1.PatternList.Add('*.arc');
    end;
    if chkOther.State = cbChecked then
        if txtOther.Text <> '' then
            FF1.PatternList.Add(txtOther.Text);

    tabSearch.PageIndex := 1;
    FF1.BeginFind;

    butScan.Enabled := True;
    butDelete.Enabled := True;
    butClose.Caption := '&Close';
end;

procedure TMainForm.butCloseClick(Sender: TObject);
begin
    if butClose.Caption = '&Cancel' then
        FF1.CancelFind
      else
        close;
end;

procedure TMainForm.FF1DirChange(Sender: TObject);
begin
    labCurDir.Caption := UpperCase(FF1.CurrentDir);
    labMatchCount.Caption := IntToStr(FF1.MatchCount);
    labMatchSize.Caption := IntToStr(FF1.MatchSize);
    labAllCount.Caption := IntToStr(FF1.TotalCount);
    labAllSize.Caption := IntToStr(FF1.TotalSize);
    application.processmessages;
end;

procedure TMainForm.FF1FileMatch(Sender: TObject);
begin
    ListBox1.Items.Add(FF1.CurrentDir+FF1.FileName);
end;

procedure TMainForm.DriveComboBox1Change(Sender: TObject);
begin
    FF1.InitDir := DriveComboBox1.Drive + ':\';
end;

procedure TMainForm.butDeleteClick(Sender: TObject);
var
    suba: longint;
    CurStr: Pchar;
begin
    CurStr := StrAlloc(255);
    for suba := 1 to ListBox1.Items.Count do
    begin
        if (ListBox1.Selected[suba-1]) and (ListBox1.Items.Strings[suba-1] <> '') then
        begin
            StrPCopy(CurStr, 'Are you sure you want to delete' + #10 + ListBox1.Items.Strings[suba-1]);
            if chkConfirm.State = cbChecked then
                if Application.MessageBox(CurStr,
                                         'Confirm Delete',
                                         mb_YesNo+mb_DefButton2+mb_IconQuestion) = IDYES then
                begin
                    DeleteFile(ListBox1.Items.Strings[suba-1]);
                    ListBox1.Items.Strings[suba-1] := '';
                end
                else
              else
                begin
                    DeleteFile(ListBox1.Items.Strings[suba-1]);
                    ListBox1.Items.Strings[suba-1] := '';
                end;
        end;
    end;
    StrDispose(CurStr);
end;

procedure TMainForm.chkSearchSubDirsClick(Sender: TObject);
begin
    if chkSearchSubDirs.State = cbChecked then
        FF1.SearchSubDirs := True
      else
        FF1.SearchSubDirs := False;
end;

end.
