{ ----------------------------------------------------------------------------}
{ A Multimedia Button component for Delphi.                                   }
{ Copyright 1995, Curtis White.  All Rights Reserved.                         }
{ This component can be freely used and distributed in commercial and private }
{ environments, provied this notice is not modified in any way.               }
{ ----------------------------------------------------------------------------}
{ Feel free to contact me if you have any questions, comments or suggestions  }
{ at cwhite@teleport.com                                                      }
{ ----------------------------------------------------------------------------}
{ Date last modified:  02/03/96                                               }
{ ----------------------------------------------------------------------------}
{ ----------------------------------------------------------------------------}
{ TMMButton v1.00                                                             }
{ ----------------------------------------------------------------------------}
{ Description:                                                                }
{   A button that plays multimedia files.  It will play avi video files as    }
{   well as wav and midi sound files.                                         }
{ Features:                                                                   }
{   Plays multimedia files when the button is clicked.                        }
{ ----------------------------------------------------------------------------}
{ ----------------------------------------------------------------------------}
{ Revision History:                                                           }
{ 1.00:  Initial release                                                      }
{ ----------------------------------------------------------------------------}

unit Mmbtn;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, MPlayer, DsgnIntf, MMBAbout;

type
  TMMButton = class(TBitBtn)
  private
    FMMBAbout: TMMBAboutBox;
    FMediaPlayer: TMediaPlayer;
    FMediaFile: string;
    FMediaDevice: TMPDeviceTypes;
    procedure SetMediaDevice(Value: TMPDeviceTypes);
  protected
    procedure PlayMediaFile;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Click; override;
  published
    property About: TMMBAboutBox read FMMBAbout write FMMBAbout;
    property MediaFile: string read FMediaFile write FMediaFile;
    property MediaDevice: TMPDeviceTypes read FMediaDevice write SetMediaDevice default dtAutoSelect;
  end;

  { Property AboutBox }
  TMMBPropAbout = class(TClassProperty)
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    procedure ShowAbout;
  end;

  procedure Register;

implementation

var
  MMBAboutBox: TMMBAboutBox;

constructor TMMButton.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FMediaDevice := dtAutoSelect;
  FMediaPlayer := TMediaPlayer.Create(Self);
  FMediaPlayer.Parent := GetParentForm(Self);
  FMediaPlayer.Visible := False;
  FMediaPlayer.DeviceType := FMediaDevice;
end;

destructor TMMButton.Destroy;
begin
  inherited Destroy;
end;

procedure TMMButton.SetMediaDevice(Value: TMPDeviceTypes);
begin
  if (FMediaDevice <> Value) then
  begin
    FMediaDevice := Value;
    FMediaPlayer.DeviceType := Value;
  end;
end;

procedure TMMButton.PlayMediaFile;
begin
  FMediaPlayer.Close;
  FMediaPlayer.Parent := GetParentForm(Self);
  FMediaPlayer.Filename := FMediaFile;
  FMediaPlayer.Open;
  FMediaPlayer.Wait := False;
  FMediaPlayer.Play;
end;

procedure TMMButton.Click;
begin
  if (FMediaFile <> '') then
  begin
    PlayMediaFile;
  end
  else
  begin
    if (FMediaDevice <> dtAutoSelect) then
    begin
      PlayMediaFile;
    end;
  end;
  inherited Click;
end;

{---------------------------------------------------------------------}

{ Property AboutBox }
procedure TMMBPropAbout.ShowAbout;
begin
  MMBAboutBox := TMMBAboutBox.Create(Application);
  MMBAboutBox.ShowModal;
  MMBAboutBox.Free;
end;

procedure TMMBPropAbout.Edit;
begin
  ShowAbout;
end;

function TMMBPropAbout.GetAttributes: TPropertyAttributes;
begin
  Result := [paMultiSelect, paDialog, paReadOnly];
end;

{---------------------------------------------------------------------}

procedure Register;
begin
  RegisterComponents('MyComps', [TMMButton]);
  RegisterPropertyEditor(TypeInfo(string), TMMButton, 'MediaFile', TMPFilenameProperty);
  RegisterPropertyEditor(TypeInfo(TMMBAboutBox), TMMButton, 'About', TMMBPropAbout);
end;

end.
