unit Example2;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls, Mainclss, Popupbox, Menus, TabNotBk, SysUtils;

type
  TForm2 = class(TForm)
    TabbedNotebook1: TTabbedNotebook;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    PopupBox1: TPopupBox;
    PopupMenu1: TPopupMenu;
    MenuAdd: TMenuItem;
    MenuInsert: TMenuItem;
    MenuEdit: TMenuItem;
    MenuDelete: TMenuItem;
    MenuBreak: TMenuItem;
    MenuDeleteAll: TMenuItem;
    Bevel1: TBevel;
    Label4: TLabel;
    Bevel2: TBevel;
    PopupBox2: TPopupBox;
    Label5: TLabel;
    Label6: TLabel;
    PopupBoxDates1: TPopupBoxDates;
    Bevel3: TBevel;
    Label7: TLabel;
    Label8: TLabel;
    BitBtn1: TBitBtn;
    procedure PopupMenu1Popup(Sender: TObject);
    procedure MenuAddClick(Sender: TObject);
    procedure MenuInsertClick(Sender: TObject);
    procedure MenuEditClick(Sender: TObject);
    procedure MenuDeleteClick(Sender: TObject);
    procedure MenuDeleteAllClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure PopupBox1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure PopupBox2DrawListItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure PopupBox2SetFieldValue(Sender: TObject; Index: Integer;
      var Value: OpenString; var Allowed: Boolean);
    procedure BitBtn1Click(Sender: TObject);
    procedure PopupBoxDates1Popup(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form2: TForm2;

implementation

{$R *.DFM}

uses
  Dialogs;

{Form create}
procedure TForm2.FormCreate(Sender: TObject);
VAR
  TmpY, TmpM, TmpD: Word;
begin
  {the list is sorted;
   duplicate strings can be added to the list}
  PopupBox1.ListItems.Duplicates:= dupAccept;
  with PopupBoxDates1 do begin
    DecodeDate(Date-14, TmpY, TmpM, TmpD);
    DateBeginYear:= TmpY; DateBeginMonth:= TmpM; DateBeginDay:= TmpD;

    DecodeDate(Date+14, TmpY, TmpM, TmpD);
    DateEndYear:= TmpY; DateEndMonth:= TmpM; DateEndDay:= TmpD;

    ListItemIndex:= 14;
    Text:= FormatDateTime(DateFormatField, Date);
  end;
end;

{Form show}
procedure TForm2.FormShow(Sender: TObject);
begin
  TabbedNotebook1.PageIndex:= 0;
  PopupBox1.SetFocus;
end;

{Menu opens up}
procedure TForm2.PopupMenu1Popup(Sender: TObject);
begin
  with PopupBox1 do begin
    MenuInsert.Enabled:= ValidSel;
    MenuEdit.Enabled:= ValidSel;
    MenuDelete.Enabled:= ValidSel;
    MenuDeleteAll.Enabled:= ListItems.Count > 0;
  end;
end;


{Add country}
procedure TForm2.MenuAddClick(Sender: TObject);
VAR
  NewValue: String;
begin
  NewValue:= '';
  if InputQuery('Give in the new country', 'country name:', NewValue) then
    PopupBox1.ListItemIndex:= PopupBox1.ListItems.Add(NewValue);
end;

{Insert country}
procedure TForm2.MenuInsertClick(Sender: TObject);
VAR
  NewValue: String;
begin
  if not PopupBox1.ValidSel then exit;
  NewValue:= '';
  if InputQuery('Give in the new value', 'country to insert:', NewValue) then
    PopupBox1.ListItems.Insert(PopupBox1.ListItemIndex, NewValue);
end;

{Edit country name}
procedure TForm2.MenuEditClick(Sender: TObject);
VAR
  ChangedValue: String;
begin
  with PopupBox1 do begin
    if not ValidSel then exit;
    ChangedValue:= ListItems[ListItemIndex];
    if ListSorted then begin
      if InputQuery('Edit value', 'Change country:', ChangedValue) then begin
        ListSorted:= False;
        ListItems[ListItemIndex]:= ChangedValue;
        ListSorted:= True;
        InvalidateRect(List.Handle, nil, False);
      end;
    end else
      if InputQuery('Edit value', 'value:', ChangedValue) then
        ListItems[ListItemIndex]:= ChangedValue;
  end;
end;

{Delete country}
procedure TForm2.MenuDeleteClick(Sender: TObject);
VAR
  CurrSelection: LongInt;
begin
  with PopupBox1 do begin
    if not ValidSel then exit;
    CurrSelection:= ListItemIndex;
    ListItems.Delete(CurrSelection);
    if ListItems.Count-1 < CurrSelection then
      {we select the last list item}
      ListItemIndex:= ListItems.Count-1
    else
      ListItemIndex:= CurrSelection;
  end;
end;

{Delete all countries}
procedure TForm2.MenuDeleteAllClick(Sender: TObject);
begin
  PopupBox1.ListItems.Clear;
end;

{OK-Button}
{Keyboard-Keys arrived on PopupBox}
procedure TForm2.PopupBox1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if ssCtrl in Shift then
    Case Key of
      ord('A'): MenuAddClick(Sender);
      ord('E'): MenuEditClick(Sender);
      ord('L'): MenuDeleteAllClick(Sender);
    End
  else
    Case Key of
      VK_DELETE: MenuDeleteClick(Sender);
      VK_INSERT: MenuInsertClick(Sender);
    End;
end;

procedure TForm2.PopupBox2DrawListItem(Control: TWinControl;
  Index: Integer; Rect: TRect; State: TOwnerDrawState);
VAR
  TempStr1, TempStr2: String;
  Rect1, Rect2: TRect;
begin
  TempStr1:= PopupBox2.ListItems[Index]; TempStr1[0]:= Char(3);
  TempStr2:= PopupBox2.ListItems[Index]; Delete(TempStr2, 1, 3);
  with (Control as TPopupBoxListBox).Canvas do begin
    SetRect(Rect1, Rect.Left, Rect.Top, Rect.Left + TextWidth('WWWW'), Rect.Bottom);
    SetRect(Rect2, Rect1.Right, Rect.Top, Rect.Right, Rect.Bottom);

    TextRect(Rect1, Rect1.Left, Rect1.Top, TempStr1);
    TextRect(Rect2, Rect2.Left, Rect2.Top, TempStr2);
  end;
end;

procedure TForm2.PopupBox2SetFieldValue(Sender: TObject; Index: Integer;
  var Value: OpenString; var Allowed: Boolean);
begin
  if Value = 'C   Cuba' then begin
    MessageDlg('You can not select Cuba!!', mtInformation, [mbYes], 0);
    Allowed:= False;
  end else
    Value[0]:= Char(3);
end;

procedure TForm2.BitBtn1Click(Sender: TObject);
begin
  Close;
end;

procedure TForm2.PopupBoxDates1Popup(Sender: TObject);
begin
  with PopupBoxDates1 do
    if ListItemIndex >= 4 then
      ListTopIndex:= ListItemIndex - 4;
end;

end.
