unit EDSUtil;
interface
uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Controls, Graphics, Forms,
  Menus, StdCtrls, ExtCtrls;

type
  TEnterEdit = class(TEdit)
    private
      { Private declarations }
    protected
      { Protected declarations }
      procedure KeyPress(var Key: Char); override;
      procedure KeyDown (var Key: Word; Shift: TShiftState);  override;
    public
      { Public declarations }
    published
      { Published declarations }
  end;  { TEnterEdit }

  TNewListBox = Class(TListBox)
    private
      { Private declarations }
      FOnChange : TNotifyEvent;
      FLastSel : integer;
      procedure Click; override;
    protected
      { Protected declarations }
      procedure Change; Virtual;
    published
      { Published declarations }
      property OnChange : TNotifyEvent read FOnChange write FOnChange;
    public
      { Public declarations }
      constructor create(AOwner : TComponent); override;
  end;  { TNewListBox }

procedure Register;

implementation

procedure TEnterEdit.KeyPress(var Key: Char);
var
   MYForm: TForm;
begin
  if Key = #13 then
  begin
    MYForm := GetParentForm( Self );
    if not (MYForm = nil ) then
      SendMessage(MYForm.Handle, WM_NEXTDLGCTL, 0, 0);
    Key := #0;
  end;  { if... }
  if Key <> #0 then inherited KeyPress(Key);
end;  { TEnterEdit.KeyPress }

procedure TEnterEdit.KeyDown (var Key: Word; Shift: TShiftState);
var
  St: string;
begin
  case Key of
    VK_UP: if ssCtrl in Shift then
           begin
             Text := UpperCase (Text);
             Key  := 0;
           end;  { if... }
    VK_DOWN: if ssCtrl in Shift then
             begin
               St    := UpperCase (Text);
               St[1] := UpCase (St[1]);
               Text  := St;
               Key  := 0;
             end;  { case }
  end;  { case }
end;  { TEnterEdit.KeyDown }

constructor TNewListBox.Create;
begin
  inherited Create(AOwner);
  FLastSel := -1;
end;  { TNewListBox.Create }

procedure TNewListBox.Change;
begin
  if assigned(FOnChange) then FOnChange(self);
end;  { TNewListBox.Change }

procedure TNewListBox.Click;
begin
  inherited Click;
  if FLastSel <> ItemIndex then
     Change;
end;  { TNewListBox.Click }

procedure Register;
begin
  RegisterComponents('Domain', [TEnterEdit, TNewListBox]);
end;

end.  { EDSUtil }
