unit PrintDlg;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Print, Printers, EDSPrint, EDSUtil, Buttons,
  ExtCtrls;

type
  TAdvPrnForm = class(TForm)
    PrinterSetupDialog1: TPrinterSetupDialog;
    Test: TButton;
    PrintDialog1: TPrintDialog;
    PrintSet1: TPrintSet;
    imgPrinter: TImage;
    rbDefault: TRadioButton;
    rbOther: TRadioButton;
    cbPrinters: TComboBox;
    gbSettings: TGroupBox;
    lblPaperSize: TLabel;
    cbPaperSizes: TComboBox;
    lblPaperSource: TLabel;
    cbBinSources: TComboBox;
    SaveDefaultsBtn: TBitBtn;
    lblOrientation: TLabel;
    cbOrientation: TComboBox;
    SavePrinterBtn: TBitBtn;
    lblPrinter: TLabel;
    PrintBtn: TBitBtn;
    PrinterSetupBtn: TBitBtn;
    OkBtn: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure cbPrintersChange(Sender: TObject);
    procedure rbDefaultClick(Sender: TObject);
    procedure SavePrinterBtnClick(Sender: TObject);
    procedure rbOtherClick(Sender: TObject);
    procedure SaveDefaultsBtnClick(Sender: TObject);
    procedure cbPaperSizesChange(Sender: TObject);
    procedure cbBinSourcesChange(Sender: TObject);
    procedure cbOrientationChange(Sender: TObject);
    procedure PrinterSetupBtnClick(Sender: TObject);
    procedure OkBtnClick(Sender: TObject);
    procedure PrintBtnClick(Sender: TObject);
  private
    { Private declarations }
    procedure SetPrinterList;
      {-sets the combobox for available printers}
    procedure SetPaperSizes;
      {-sets the combobox for paper sizes}
    procedure SetBinSources;
      {-sets the combobox for bin sources}
    procedure SetOrientation;
      {-sets the current orientation for the current printer}
  public
    { Public declarations }
  end;

var
  AdvPrnForm: TAdvPrnForm;

implementation

{$R *.DFM}

procedure TAdvPrnForm.FormCreate(Sender: TObject);
begin
  SetPrinterList;
  SetPaperSizes;
  SetBinSources;
  SetOrientation;
end;

procedure TAdvPrnForm.SetPrinterList;
  {-sets the combobox for available printers}
begin
  cbPrinters.Items.Clear;
  cbPrinters.Items.Assign (Printer.Printers);
  cbPrinters.ItemIndex := 0;
  lblPrinter.Caption := PrintSet1.PrinterName;
end;  { TAdvPrnForm.SetPrinterList }

procedure TAdvPrnForm.SetPaperSizes;
  {-sets the combobox for paper sizes}
var
  PaperList: TStringList;
begin
  cbPaperSizes.Items.Clear;
  PaperList := PrintSet1.GetPaperList;
  if PaperList <> nil then
  begin
    cbPaperSizes.Items.Assign (PaperList);
    if cbPaperSizes.Items.Count <> 0 then
    begin
      cbPaperSizes.Enabled := TRUE;
      cbPaperSizes.ItemIndex := PrintSet1.PaperIndex;
    end {:} else
      cbPaperSizes.Enabled := FALSE;
    PaperList.Free;
  end {:} else
    cbPaperSizes.Enabled := FALSE;
end;  { TAdvPrnForm.SetPaperSizes }

procedure TAdvPrnForm.SetBinSources;
  {-sets the combobox for bin sources}
var
  BinList: TStringList;
begin
  cbBinSources.Items.Clear;
  BinList := PrintSet1.GetBinSourceList;
  if BinList <> nil then
  begin
    cbBinSources.Items.Assign (BinList);
    if cbBinSources.Items.Count <> 0 then
    begin
      cbBinSources.Enabled := TRUE;
      cbBinSources.ItemIndex := PrintSet1.BinIndex;
    end {:} else
      cbBinSources.Enabled := FALSE;
    BinList.Free;
  end {:} else
    cbBinSources.Enabled := FALSE;
end;  { TAdvPrnForm.SetBinSources }

procedure TAdvPrnForm.SetOrientation;
  {-sets the current orientation for the current printer}
begin
  cbOrientation.ItemIndex := Ord (Printer.Orientation);
end;  { TAdvPrnForm.SetOrientation }

procedure TAdvPrnForm.cbPrintersChange(Sender: TObject);
begin
  Printer.PrinterIndex := cbPrinters.ItemIndex;
  if rbOther.Checked
    then rbOtherClick (Sender)
    else rbOther.Checked := TRUE;
end;

procedure TAdvPrnForm.rbDefaultClick(Sender: TObject);
begin
  Printer.PrinterIndex := (-1);
  lblPrinter.Caption := PrintSet1.PrinterName;
  SetPaperSizes;
  SetBinSources;
  SetOrientation;
  SavePrinterBtn.Enabled := FALSE;
end;

procedure TAdvPrnForm.SavePrinterBtnClick(Sender: TObject);
begin
  PrintSet1.SavePrinterAsDefault;
  lblPrinter.Caption := PrintSet1.PrinterName;
end;

procedure TAdvPrnForm.rbOtherClick(Sender: TObject);
begin
  rbDefault.Checked := not rbOther.Checked;
  SetPaperSizes;
  SetBinSources;
  SetOrientation;
  SavePrinterBtn.Enabled := TRUE;
end;

procedure TAdvPrnForm.SaveDefaultsBtnClick(Sender: TObject);
begin
  PrintSet1.SaveToDefaults;
end;

procedure TAdvPrnForm.cbPaperSizesChange(Sender: TObject);
begin
  PrintSet1.PaperIndex := cbPaperSizes.ItemIndex;
end;

procedure TAdvPrnForm.cbBinSourcesChange(Sender: TObject);
begin
  PrintSet1.BinIndex := cbBinSources.ItemIndex;
end;

procedure TAdvPrnForm.cbOrientationChange(Sender: TObject);
begin
  PrintSet1.Orientation := cbOrientation.ItemIndex;
end;

procedure TAdvPrnForm.PrinterSetupBtnClick(Sender: TObject);
begin
  PrintSet1.ResetPrinterDialogs;
  PrinterSetupDialog1.Execute;
end;

procedure TAdvPrnForm.OkBtnClick(Sender: TObject);
begin
  Close;
end;

procedure TAdvPrnForm.PrintBtnClick(Sender: TObject);
begin
  PrintSet1.ResetPrinterDialogs;
  PrintDialog1.Execute;
end;

end.
