unit Target;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
     StdCtrls, ExtCtrls, FileCtrl,Dialogs,Decla;

Type Rep = record
            Numb : integer;
            Driv : string [1];
            Path : string;
           end;

type
  TTargetDialog = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    Bevel1: TBevel;
    Label1: TLabel;
    DirectoryList: TListBox;
    TargetDrive: TDriveComboBox;
    DriveList: TDriveComboBox;
    TargetList: TDirectoryListBox;
    TargetDirectory: TEdit;
    Label2: TLabel;
    Label3: TLabel;
    Bevel2: TBevel;
    Bevel3: TBevel;
    Label4: TLabel;
    Bevel4: TBevel;
    Label5: TLabel;
    Label6: TLabel;
    CreateBtn: TBitBtn;
    DeleteBtn: TBitBtn;
    procedure OKBtnClick(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure ChangeDir(Sender: TObject);
    procedure SetDirect(Sender: TObject);
    procedure CreateBtnClick(Sender: TObject);
    procedure Initialise(Sender: TObject);
    procedure DeleteBtnClick(Sender: TObject);
  private
    Number_Dir : integer;
    ListOfDir : array [1 .. (Max_Path - 1)] of Rep;
    Current   : integer;
    procedure BuildList;
    { Private declarations }
  public
    { Public declarations }
  end;

var
  TargetDialog: TTargetDialog;

implementation

{$R *.DFM}

(* Ok button *)
procedure TTargetDialog.OKBtnClick(Sender: TObject);
var Bcl : integer;
begin
 Number_Direc := Number_Dir;
 for Bcl := 1 to Number_Dir do
 begin
  With ListOfDir [Bcl] do
  begin
   if (Driv <> '') and (Path <> '') then
   begin
    With VPath [Bcl] do
    begin
     LettDriv := Driv + ':';
     PathDriv := Path;
    end;
   end;
  end;
 end;
 CreateBtn.Caption := '&Create';
 DeleteBtn.Enabled := true;
 ModalResult := mrOk;
end;

(* Cancel button *)
procedure TTargetDialog.CancelBtnClick(Sender: TObject);
begin
 CreateBtn.Caption := '&Create';
 DeleteBtn.Enabled := true;
 ModalResult := mrCancel;
end;

(* change directory *)
procedure TTargetDialog.ChangeDir(Sender: TObject);
begin
 TargetDirectory.Text := TargetList.Directory;
end;

(* put directory for modification *)
procedure TTargetDialog.SetDirect(Sender: TObject);
begin
 if DirectoryList.ItemIndex <> -1 then
 begin
  Current := DirectoryList.ItemIndex + 1;
  With ListOfDir [Current] do
  begin
   DriveList.Drive := 'C';
   TargetList.Drive := 'C';
   TargetList.Directory := '\';
   TargetDrive.Drive := Driv [1];
   TargetDirectory.Text := Path;
   CreateBtn.Caption := '&Modif.';
   DeleteBtn.Enabled := false;
  end;
 end
 else
  Current := 0;
end;

(* Create button *)
procedure TTargetDialog.CreateBtnClick(Sender: TObject);
var Tmp : string;
    Cur : integer;
begin
 if Current <> 0 then
 (* modification *)
 begin
  With ListOfDir [Current] do
  begin
   Driv := TargetDrive.Drive;
   Tmp := TargetDirectory.Text;
   if pos (':',Tmp) <> 0 then
    Delete (Tmp,1,pos (':',Tmp));
   Path := Tmp;
   CreateBtn.Caption := '&Create';
   DeleteBtn.Enabled := true;
  end;
 end
 else
 (* new one *)
 begin
  if DirectoryList.Items.Count <= 0 then
   Cur := 1
  else
   Cur := DirectoryList.Items.Count + 1;
  if Cur > (Max_Path -1) then
   MessageDlg ('Maximum of targets reached',mtInformation,[mbok],0)
  else
  begin
   Inc (Number_Dir);
   With ListOfDir [Cur] do
   begin
    Driv := TargetDrive.Drive;
    Tmp := TargetDirectory.Text;
    if pos (':',Tmp) <> 0 then
     Delete (Tmp,1,pos (':',Tmp));
    Path := Tmp;
   end;
  end;
 end;
 BuildList;
end;

(* build targets list *)
procedure TTargetDialog.BuildList;
var Bcl : integer;
begin
 DirectoryList.Clear;
 if Number_Dir > 0 then
 begin
  For Bcl := 1 to Number_Dir do
  begin
   with ListOfDir [Bcl] do
   begin
    if (Driv <> '') and (Path <> '') then
    DirectoryList.Items.Add (Driv + ':' + Path);
   end;
  end;
 end;
 DirectoryList.ItemIndex := -1;
 Current := 0;
end;

(* init dialog *)
procedure TTargetDialog.Initialise(Sender: TObject);
var Bcl : integer;
    Cur : integer;
begin
 Current := 0;
 (* making a duplicate list *)
 if Number_Direc > 0 then
 begin
  for Bcl := 1 to Number_Direc do
  begin
   With VPath [Bcl] do
   begin
    With ListOfDir [Bcl] do
    begin
     Driv := LettDriv [1];
     Path := PathDriv;
    end;
   end;
  end;
 end;
 for Bcl := (Number_Direc + 1) to (Max_Path - 1) do
 begin
  With ListOfDir [Bcl] do
  begin
   Driv := '';
   Path := ''
  end;
 end;
 Number_Dir := Number_Direc;
 (* init component *)
 DriveList.Drive := 'C';
 TargetList.Drive := 'C';
 TargetList.Directory := '\';
 TargetDrive.Drive := 'C';
 TargetDirectory.Text := '\';
 BuildList;
end;

(* delete button *)
procedure TTargetDialog.DeleteBtnClick(Sender: TObject);
var Bcl : integer;
    Cur : integer;
begin
 if DirectoryList.ItemIndex <> -1 then
 begin
  Cur := DirectoryList.ItemIndex + 1;
  DirectoryList.Items.Delete (Cur - 1);
  if Number_Dir > 1 then
  begin
   For Bcl := Cur to Number_Dir do
   begin
    ListOfDir [Bcl] := ListOfDir [Bcl + 1];
   end;
  end;
  with ListOfDir [Number_Dir] do
  begin
   Numb := 0;
   Driv := '';
   Path := '';
  end;
  Dec (Number_Dir);
 end;
 DirectoryList.ItemIndex := -1;
 Current := 0;
end;

end.
