//
//	MORSE.H
//		Global morse header.
//

//	Standard libraries

#include <io.h>
#include <dos.h>
#include <time.h>
#include <alloc.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

//	Convenient types

typedef unsigned int UINT;
typedef unsigned char UCHAR;
typedef unsigned long ULONG;
typedef signed char SCHAR;

//	Other headers

#include "sb.h"
#include "vid.h"

//	Video constants

#define BOXTOP		0x00				// 0-based line of box top
#define BOXDIV		0x0B				// 0-based line of box divider
#define BOXBOT		0x16				// 0-based line of box bottom
#define	BOXLEF		0x00				// 0-based column of box left
#define BOXRIG		0x23				// 0-based column of box right
#define VIDSEG		0xB800				// assume color display
#define GRAPHTOP	72					// rightmost graph character
#define BLU			42					// left of this column is blue
#define GRN			(BLU+((GRAPHTOP-41)>>1))					// is green
#define YEL			(GRN+((GRAPHTOP-41)>>2)+((GRAPHTOP-41)>>3))	// is yellow

//	Audio constants

#define SAMPLELEN	1000				// sample buffer size
#define SAMPLEMIN	1000				// samples per second
#define SAMPLEMAX	44000
#define SAMPLEINC	1000
#define MAXBUF		0xFF
#define MINBUF		0x01

#define TRUE		1					// true value (C compatible)
#define FALSE		0					// false value (C compatible)

//	Math constants

#define N			16	// number of FFT terms; do not change this!
#define LOG2N		4	// Log2n (see N)

#define S0			0	// 4-bit SIN table S0 == sin(0)
#define S1 			3	// increasing precision will create integer overflows
#define S2 			6
#define S3 			9
#define S4			11
#define S5			13
#define S6			15
#define S7			16
#define S8			16	// S8 == sin(1)
#define SCALE		11	// scales FFT value to something manageable

#define MAXFFT		255	// maximum FFTs to hold

//
//	end of MORSE.H
//
