'
' DIALER.BAS
'
' Compile & link: PBCC DIALER.BAS
'

$INCLUDE "WSC32.BAS"
$INCLUDE "ERRORS32.BAS"
$INCLUDE "XYDRV32.BAS"
$INCLUDE "MIO32.BAS"
$INCLUDE "GETARGS.BAS"

FUNCTION PbMain() AS LONG

Dim I As Integer
Dim Code As Long
Dim Port As Long
Dim Baud As Long
Dim Result As Long
Dim Argc As Integer
Dim Args(3) As String
Dim PhoneNumber As String
Dim DialString As Asciiz * 50

PRINT "DIALER 8/2/98 (type ^Z to exit)"

'get command line arguments
Argc = Get3Args(Args(1), Args(2), Args(3))
IF Argc <> 3 THEN
  PRINT "Usage: DIALER <Port> <Baud> <PhoneNumber>"
  PRINT "Example: DIALER 1 19200 1,256,880,9748"
  EXIT FUNCTION
END IF  
'Get COM port
Port = VAL(Args(1)) - 1
Baud = VAL(Args(2))
PhoneNumber = Args(3)

'''PRINT "COM";1+Port;" @";Baud;", [";PhoneNumber;"]"

'reset port (8N1 is default)
Code = SioReset(Port,1024&,1024&)
IF Code < 0 THEN
  Call SayError(Code)
  EXIT FUNCTION
END IF

'set baud rate
Code = SioBaud(Port,Baud)
IF Code < 0 THEN
  Call SayError(Code)
  EXIT FUNCTION
END IF

' set DTR & RTS
Code = SioDTR(Port,ASC("S"))
Code = SioRTS(Port,ASC("S"))

' look for DSR
IF SioDSR(Port) = 0 THEN
  PRINT "Error: DSR must be set by the modem."
  Code = SioDone(Port)
  EXIT FUNCTION
END IF

' create dial string
DialString = Chr$(13) + "ATDT " + PhoneNumber + Chr$(13)
PRINT "Dialing ";PhoneNumber;" (type Control-BREAK to abort)"
Code = mioSendTo(Port, 200&, DialString)

' dial
WHILE mioDriver(Port) <> %MIO_IDLE 
WEND

' wait up to 60 seconds for CONNECT
Code = mioWaitFor(Port, 60000&, "CONNECT")
WHILE mioDriver(Port) <> %MIO_IDLE 
WEND

Code = mioResult(Port)
IF Code = 0 THEN
  PRINT "Error: CONNECT not seen."
  EXIT FUNCTION
END IF

' wait for a second and a half of silence
Code = mioQuiet(Port,15000&)

' send carriage return
Code = SioPutc(Port, 13)

' enter terminal loop
DO
  'Anything incoming ?
  Code = SioGetc(Port)
  IF Code = 13 THEN
    PRINT
  ELSEIF Code >= &H20 THEN
    PRINT CHR$(Code);
  END IF
  'Anything to send ?
  AnyKey$ = INKEY$
  IF AnyKey$ <> "" THEN
    'Exit if user types Control-Z or ESC
    IF AnyKey$ = CHR$(26) THEN EXIT DO
    IF AnyKey$ = CHR$(27) THEN EXIT DO
    Code = SioPutc(Port,ASC(AnyKey$))
  END IF
LOOP

Code = SioDone(Port)
END FUNCTION
