'
' ECHOPORT.BAS
'
' Compile & link: PBCC SIMPLE.BAS -ID:\PBCC10\WINAPI
'   where the include specification reference where WINAPI.INC 
'   is located on your system.
'
' Echoes characters incoming on COM1 and COM2 using threads. 
' Compile with -MT flag.
' 
' Connect COM1 and/or COM2 to another computer using a NULL modem cable.
' Start SIMPLE on other computer(s) at 38400 baud.
' Start ECHOPORT. 
' Anything transmitted from remote is echoed back to remote by ECHOPORT.
'
' To terminate ECHOPORT, type ^C or disconnect cables (which drops DSR).
'

$INCLUDE "WSC32.BAS"
$INCLUDE "ERRORS32.BAS"
$INCLUDE "WIN32API.INC"

FUNCTION PbMain() AS LONG

Dim I As Integer
Dim Code As Long
Dim Port As Long
Dim Result As Long
Dim ThreadID(2) As Long
Dim Counter As Integer
Dim IsRunning(2) As Integer

PRINT "ECHOPORT 7/20/98 (Type ^Z to exit)"

IF LEN(COMMAND$) > 0 THEN
  PRINT "ECHOPORT takes no arguments!"
  EXIT FUNCTION
END IF
' start 2 threads
FOR I = %COM1 TO %COM2
  THREAD CREATE ComThread(I) to ThreadID(I)
NEXT
PRINT "***"
PRINT "*** Type Control-BREAK to terminate main"
PRINT "***"
Call Sleep(100)
DO
  Counter = 0
  FOR I = %COM1 TO %COM2
    THREAD STATUS ThreadID(I) TO Result
    'count running thread
    IF Result <> 0 THEN
      Incr Counter
    END IF
  NEXT I
  'any threads running ?
  IF Counter = 0 THEN
    PRINT "All threads terminated."
    EXIT Function
  END IF
  Call Sleep(0)
LOOP

END FUNCTION

FUNCTION ComThread(ByVal Port As Long) As Long
Dim Code As Long
PRINT "Starting thread for COM";LTRIM$(STR$(Port+1))
'reset port (8N1 is default)
Code = SioReset(Port,1024&,1024&)
IF Code < 0 THEN
  Call SayError(Code)
  EXIT FUNCTION
END IF
'set baud rate to 19200
Code = SioBaud(Port,19200)
IF Code < 0 THEN
  Call SayError(Code)
  EXIT FUNCTION
END IF
' set DTR & RTS
Code = SioDTR(Port,ASC("S"))
Code = SioRTS(Port,ASC("S"))
Call Sleep(100)
PRINT "Online for COM";Port+1
DO
  'this thread is done when DSR is dropped 
  IF SioDSR(Port) = 0 THEN
    PRINT "COM";LTRIM$(STR$(Port+1));" DSR dropped, aborting thread."
    Code = SioDone(Port)
    EXIT FUNCTION
  END IF
  'Anything incoming ?
  Code = SioGetc(Port)
  IF Code = 13 THEN
    PRINT
  ELSEIF Code >= &H20 THEN
    PRINT CHR$(Code);
  END IF
  'give up rest of time slice
  Call sleep(0)
LOOP
END FUNCTION
