' 
' FINDER.BAS
'
' Connect a modem to one of COM1 to COM4, and turn it on.
' FINDER will search for the modem.
'
'

$INCLUDE "WSC32.BAS"
$INCLUDE "ERRORS32.BAS"

SUB LocalWait(ByVal Delay As Long)
DIM TimeMark As Long
TimeMark = SioTimer() + Delay
WHILE SioTimer() < TimeMark
WEND
END SUB

FUNCTION PbMain() AS Long

DIM Port AS Long
DIM Code AS Long
DIM Expect AS String
DIM TimeMark AS Long

CLS
PRINT "FINDER: Searching for connected modem."
PRINT

'search each port in turn
FOR Port = %COM1 TO %COM4
  ' set parmameters for the port
  Code = SioParms(Port,%WSC_NoParity,%WSC_OneStopBit,%WSC_WordLength8)
  ' reset port
  Code = SioReset(Port, 512&, 512&)
  PRINT "COM";LTRIM$(STR$(1+Port))
  IF Code >= 0 THEN
     'found UART
     Code = SioBaud(Port, 19200&)
     Code = SioDTR(Port, ASC("S"))
     Code = SioRTS(Port, ASC("S"))
     'modem should set DSR
     Code = SioPutc(Port,13)
     Call LocalWait(250&)
     IF SioDSR(Port) = 0 THEN
       'DSR not set
       PRINT "  DSR is not set."
       Code = SioDone(Port)
     ELSE
       'modem has set DSR
       PRINT "  DSR is set."
       'send "AT"
       Code = SioPutc(Port,13)
       Call LocalWait(250&)
       Code = SioPutc(Port,ASC("A"))
       Call LocalWait(250&)
       Code = SioPutc(Port,ASC("T"))
       Call LocalWait(250&)
       Code = SioPutc(Port,13)
       Call LocalWait(250&)
       'expect "OK" back
       Expect = "O"
       TimeMark = SioTimer() + 3000&
       WHILE SioTimer() < TimeMark
         Code = SioGetc(Port)
         IF Code = 13 THEN
           PRINT
         ELSEIF Code >= &H20 THEN
           PRINT CHR$(Code);
           IF CHR$(Code) = Expect THEN
             IF Expect = "O" THEN
               EXPECT = "K"
             ELSE
               PRINT "  Modem detected."
               Code = SioDone(Port)
               EXIT FUNCTION
             END IF
           END IF
         END IF
       WEND
       'modem does not respond
       Code = SioDone(Port)
     END IF
  ELSE
     PRINT "Error ";Code;
     Call SayError(Code)
     PRINT
  END IF
NEXT Port
END FUNCTION


 