'
' RS485.BAS
'
' Compile & link: PBCC RS485.BAS -ID:\PBCC10\WINAPI
'
' 

$INCLUDE "WSC32.BAS"
$INCLUDE "ERRORS32.BAS"
$INCLUDE "WIN32API.INC"

' wait till last bit of last byte has been transmitted

SUB Wait4TxDone(ByVal Port As Long)
Dim Code As Long
DO
 Code = SioRead(Port, 5) 
 IF (&H0060 AND Code) = &H0060 THEN
   EXIT SUB
 END IF
 Call Sleep(0)
LOOP
END SUB

FUNCTION PbMain() AS LONG
Dim I As Integer
Dim Code As Long
Dim Port As Long
Dim Baud AS Long
Dim Arg1 As String
Dim Arg2 As String
Dim Parms As String
Dim Version As Integer
Dim A As String
Dim B As String
Dim C As String
  
PRINT "RS485 5/24/99 (Type ^Z to exit)"

' display WSC version
Version = SioInfo(ASC("V"))
C = Hex$(&HF And Version)
Version = Version / 16
B = Hex$(&HF And Version)
Version = Version / 16
A = Hex$(&HF And Version)
PRINT "WSC Version " + A + "." + B + "." + C

'get command line arguments
PARMS$ = RTRIM$(COMMAND$)
I = INSTR(PARMS$, " ")
IF I < 1 THEN
  PRINT "  Usage: RS485 <Port> <BaudRate>"
  PRINT "Example: RS485 1 9600"
  EXIT FUNCTION 
END IF
ARG1$ = LEFT$(PARMS$, I - 1)
ARG2$ = LTRIM$(RIGHT$(PARMS$, LEN(PARMS$) - I))

'Get COM port
Port = VAL(ARG1$) - 1
Baud = VAL(ARG2$)
'''PRINT "COM";1+Port;" @";Baud

'reset port (8N1 is default)
Code = SioReset(Port,1024&,1024&)
IF Code < 0 THEN
  Call SayError(Code)
  EXIT FUNCTION
END IF

'set baud rate
Code = SioBaud(Port,Baud)
IF Code < 0 THEN
  Call SayError(Code)
  EXIT FUNCTION
END IF

' set DTR & RTS
Code = SioDTR(Port,ASC("S"))
Code = SioRTS(Port,ASC("S"))

' enter terminal loop
DO
  'Anything incoming ?
  Code = SioGetc(Port)
  IF Code = 13 THEN
    PRINT
  ELSEIF Code >= &H20 THEN
    PRINT CHR$(Code);
  END IF
  'Anything to send ?
  AnyKey$ = INKEY$
  IF AnyKey$ <> "" THEN
    'Exit if user types Control-Z or ESC
    IF AnyKey$ = CHR$(26) THEN EXIT DO
    IF AnyKey$ = CHR$(27) THEN EXIT DO
    ' set RTS 
    Code = SioRTS(Port,%WSC_SET_LINE)
    ' transmit character 
    Code = SioPutc(Port,ASC(AnyKey$))
    ' wait till TX queue is empty
    IF SioTxQue(Port) > 1 THEN
       Code = SioEvent(Port, %EV_TXEMPTY)
    END IF
    ' wait for last bit of last character to be transmitted 
    '''CALL Wait4TxDone(Port)  '<=== use for Windows 95/98 
    Call Sleep(1)              '<=== use for Windows NT 
    ' drop RTS 
    Code = SioRTS(Port,%WSC_CLEAR_LINE)
  END IF
LOOP

Code = SioDone(Port)
END FUNCTION
