'
' SELFTEST.BAS
'
' SELFTEST performs an external loopback test. Your serial port must be
' terminated by a loopback adapter (TX and RX pins are connected). A
' modem will usually also function as a loopback adapter.
'
' See LOOPBACK.TXT for directions on making a loopback adapter. Very easy!
'
' *** IMPORTANT: Boot to DOS before running under Windows! ***
'

$INCLUDE "WSC32.BAS"
$INCLUDE "ERRORS32.BAS"

SUB LocalWait(ByVal Delay As Long)
DIM TimeMark As Long
TimeMark = SioTimer() + Delay
WHILE SioTimer() < TimeMark
WEND
END SUB

FUNCTION PbMain() AS LONG

' Global Variables

DIM ThePort AS INTEGER
DIM BaudRate AS LONG
DIM TestString AS STRING
DIM TestLength AS INTEGER
DIM ComLimit AS INTEGER
DIM C AS BYTE
DIM LibVer AS INTEGER
DIM I AS INTEGER
DIM L AS INTEGER
DIM Code AS INTEGER
DIM Parms AS STRING
DIM Args(10) AS STRING
DIM nArgs AS INTEGER
DIM X AS STRING
DIM RxQue AS INTEGER

DIM CharPerInt AS SINGLE

' initialize

X = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz" + CHR$(10)
TestString = X + X + X + X

CLS

' get command line arguments

nArgs = 0
Parms = LTRIM$(RTRIM$(COMMAND$)) + " "
DO
   I = INSTR(Parms, " ")
   L = LEN(Parms)
   IF I <= 1 THEN EXIT DO
   nArgs = nArgs + 1
   Args(nArgs) = UCASE$(LEFT$(Parms, I - 1))
   Parms = LTRIM$(MID$(Parms,I,L-I+1))
LOOP

IF nArgs <> 2 THEN
   PRINT "Usage: selftest port baudrate"
   EXIT FUNCTION
END IF

ThePort = VAL(Args(1)) -1
PRINT "ThePort  = COM";(1+ThePort)
IF ThePort < %COM1 THEN
   PRINT "Port must be >= COM1"
   EXIT FUNCTION
END IF
BaudRate = VAL(Args(2)) 
PRINT "BaudRate = "; BaudRate

' reset ThePort
Code = SioReset(ThePort, 1014&, 1024&)
IF Code < 0 THEN
  Call SayError(Code)
  EXIT FUNCTION
END IF
Code = SioBaud(ThePort, BaudRate)
CLS

PRINT  "SELFTEST (7/14/98)"
PRINT "   Port : COM"; LTRIM$(STR$(1+ThePort))
PRINT "   Baud : ";BaudRate

'init

TestLength = LEN(TestString)
'send string
PRINT "  Sending: ";
FOR I = 1 TO TestLength
   X$ = MID$(TestString,I,1)
   C = ASC(X$)
   Code = SioPutc(ThePort,C)
   IF C = 10 THEN
     PRINT
   ELSE
     PRINT X$;
   END IF
NEXT I
' receive string
PRINT
PRINT "Receiving: ";
RxQue = SioRxQue(ThePort)
FOR I = 1 TO TestLength
   Code = SioGetc(ThePort)
   IF Code < 0 THEN
       PRINT "ERROR: ";
       Call SayError(Code)
       Code = SioDone(ThePort)
       EXIT FUNCTION
    END IF
    ' echo just received char
    IF Code = 10 THEN
      PRINT
    ELSE
      PRINT CHR$(Code);
    END IF
    ' compare character
    X$ = MID$(TestString,I,1)
    IF CHR$(Code) <> X$ THEN
       PRINT
       PRINT "ERROR: Expecting '";X$;"', received '";CHR$(Code)
       Code = SioDone(ThePort)
       EXIT FUNCTION
    END IF
 NEXT I
 PRINT
 PRINT "SUCCESS: Test AOK !"
 Code = SioDone(ThePort)
END FUNCTION


 