'
' SIMPLE.BAS
'
' Compile & link: PBCC SIMPLE.BAS
'

$INCLUDE "WSC32.BAS"
$INCLUDE "ERRORS32.BAS"

FUNCTION PbMain() AS LONG

Dim I As Integer
Dim Code As Long
Dim Port As Long
Dim Baud AS Long
Dim Arg1 As String
Dim Arg2 As String
Dim Parms As String
Dim Version As Integer
Dim A As String
Dim B As String
Dim C As String
  
PRINT "SIMPLE 7/6/98 (Type ^Z to exit)"

' display WSC version
Version = SioInfo(ASC("V"))
C = Hex$(&HF And Version)
Version = Version / 16
B = Hex$(&HF And Version)
Version = Version / 16
A = Hex$(&HF And Version)
PRINT "WSC Version " + A + "." + B + "." + C

'get command line arguments
PARMS$ = RTRIM$(COMMAND$)
I = INSTR(PARMS$, " ")
IF I < 1 THEN
  PRINT "  Usage: SIMPLE <Port> <BaudRate>"
  PRINT "Example: SIMPLE 1 9600"
  EXIT FUNCTION 
END IF
ARG1$ = LEFT$(PARMS$, I - 1)
ARG2$ = LTRIM$(RIGHT$(PARMS$, LEN(PARMS$) - I))

'Get COM port
Port = VAL(ARG1$) - 1
Baud = VAL(ARG2$)
'''PRINT "COM";1+Port;" @";Baud

'reset port (8N1 is default)
Code = SioReset(Port,1024&,1024&)
IF Code < 0 THEN
  Call SayError(Code)
  EXIT FUNCTION
END IF

'set baud rate
Code = SioBaud(Port,Baud)
IF Code < 0 THEN
  Call SayError(Code)
  EXIT FUNCTION
END IF

' set DTR & RTS
Code = SioDTR(Port,ASC("S"))
Code = SioRTS(Port,ASC("S"))

' enter terminal loop
DO
  'Anything incoming ?
  Code = SioGetc(Port)
  IF Code = 13 THEN
    PRINT
  ELSEIF Code >= &H20 THEN
    PRINT CHR$(Code);
  END IF
  'Anything to send ?
  AnyKey$ = INKEY$
  IF AnyKey$ <> "" THEN
    'Exit if user types Control-Z or ESC
    IF AnyKey$ = CHR$(26) THEN EXIT DO
    IF AnyKey$ = CHR$(27) THEN EXIT DO
    Code = SioPutc(Port,ASC(AnyKey$))
  END IF
LOOP

Code = SioDone(Port)
END FUNCTION
