'
' XMS.BAS [XMODEM Send]
'
' Compile & link: PBCC XMS.BAS
' Requires XYDRV32 version 2.3.5 or higher

$INCLUDE "WSC32.BAS"
$INCLUDE "XYDRV32.BAS"
$INCLUDE "ERRORS32.BAS"
$INCLUDE "GETARGS.BAS"

%ONE_K = 0
%XMODEM = 0

Sub RunXY(Port As Long)
  Dim Code As Integer
  Dim Buffer As Asciiz * 81
  Dim Packet As Long
  Dim LastPacket As Long
  LastPacket = -1
  DO
    ' run the driver
    Code = xyDriver(Port)
    ' any messages from xyDriver ?
    While xyGetMessage(Port, Buffer, 80) > 0
      PRINT Buffer
    Wend
    If Code = %XY_IDLE Then
      EXIT SUB
    Else
      'xyDriver is running
      Packet = xyGetParameter(Port, %XY_GET_PACKET)
      If Packet <> LastPacket Then
         'show packet number
         PRINT " P" + LTRIM$(Str$(Packet));
         IF Packet Mod 10 = 9 THEN
           PRINT
         END IF
         LastPacket = Packet
       End If
    End If
  LOOP
End Sub

FUNCTION PbMain() AS LONG
Dim I As Integer
Dim Code As Long
Dim Port As Long
Dim Baud AS Long
Dim FileName As Asciiz * 40
Dim Argc As Integer
Dim Args(3) As String
Dim S As String

PRINT "_______________"
PRINT
PRINT "XMS 01/09/98 (PBCC)"

'get command line arguments
Argc = Get3Args(Args(1), Args(2), Args(3))
IF Argc <> 3 THEN
  PRINT "Usage: XMS <port> <baud> <filename>"
  PRINT "Example: XMS 1 19200 myfile.dat"
  EXIT FUNCTION
END IF  
'Get COM port
Port = VAL(Args(1)) - 1
Baud = VAL(Args(2))
Filename = Args(3)

PRINT "Port : COM";1+Port
PRINT "Baud :";Baud
PRINT "File : ";Filename
PRINT "_______________"

'reset port (8N1 is default)
Code = SioReset(Port,1040&,1040&)
IF Code < 0 THEN
  Call SayError(Code)
  EXIT FUNCTION
END IF

'set baud rate
Code = SioBaud(Port,Baud)
IF Code < 0 THEN
  Call SayError(Code)
  EXIT FUNCTION
END IF

' set DTR & RTS
Code = SioDTR(Port,ASC("S"))
Code = SioRTS(Port,ASC("S"))

' set parms
Code = SioParms(Port, %WSC_NoParity, %WSC_OneStopBit, %WSC_WordLength8)
' set hardware flow control
Code = SioFlow(Port, ASC("H"))
'acquire xyDriver
Code = xyAcquire(Port, Port)
'set xyDriver debug level
Code = xyDebug(0)
PRINT "Starting XMODEM send (type Control-BREAK to quit)"
Code = xyStartTX(Port, Filename, %ONE_K, %XMODEM)

'run the XMODEM driver
Call RunXY(Port)
PRINT 
PRINT "All done."

Code = xyRelease()
Code = SioDone(Port)
END FUNCTION
