'
' YMR.BAS [YMODEM Receive]
'
' Compile & link: PBCC YMR.BAS
'

$INCLUDE "WSC32.BAS"
$INCLUDE "XYDRV32.BAS"
$INCLUDE "ERRORS32.BAS"
$INCLUDE "GETARGS.BAS"

%NCG = &H43
%YMODEM = 1

Sub RunXY(Port As Long)
  Dim Code As Integer
  Dim Buffer As Asciiz * 81
  Dim FileName As Asciiz * 65
  Dim Packet As Long
  Dim LastPacket As Long
  LastPacket = -1
  FileName = ""
  DO    
    ' run the driver
    Code = xyDriver(Port)
    ' any messages from xyDriver ?
    While xyGetMessage(Port, Buffer, 80) > 0
      PRINT Buffer
    Wend
    If Code = %XY_IDLE Then
      EXIT SUB
    Else
      'xyDriver is running
      Packet = xyGetParameter(Port, %XY_GET_PACKET)
      If Packet <> LastPacket Then
         'show packet #
         PRINT " P" + LTRIM$(Str$(Packet));
         IF Packet Mod 10 = 9 THEN
           PRINT
         END IF
         LastPacket = Packet
         IF LastPacket = 1 THEN
           'already get filename ?
           IF LEN(FileName) = 0 THEN
             'get filename from packet 0
             Code = xyGetFilename(Port,FileName,64)
             PRINT " [";FileName;"]";
           END IF
         END IF
       End If
    End If
  LOOP
End Sub

FUNCTION PbMain() AS LONG
Dim I As Integer
Dim Code As Long
Dim Port As Long
Dim Baud AS Long
Dim FileName As Asciiz * 40
Dim Argc As Integer
Dim Args(3) As String
Dim S As String

PRINT "_______________"
PRINT
PRINT "YMR 01/10/98 (PBCC)"

'get command line arguments
Argc = Get3Args(Args(1), Args(2), Args(3))
IF Argc <> 2 THEN
  PRINT "Usage: YMR <port> <baud>"
  PRINT "Example: YMR 1 19200"
  EXIT FUNCTION
END IF  
'Get COM port
Port = VAL(Args(1)) - 1
Baud = VAL(Args(2))
Filename = ""

PRINT "Port : COM";1+Port
PRINT "Baud :";Baud
'''PRINT "File : ";Filename
PRINT "_______________"

'reset port (8N1 is default)
Code = SioReset(Port,1040&,1040&)
IF Code < 0 THEN
  Call SayError(Code)
  EXIT FUNCTION
END IF

'set baud rate
Code = SioBaud(Port,Baud)
IF Code < 0 THEN
  Call SayError(Code)
  EXIT FUNCTION
END IF

' set DTR & RTS
Code = SioDTR(Port,ASC("S"))
Code = SioRTS(Port,ASC("S"))

' set parms
Code = SioParms(Port, %WSC_NoParity, %WSC_OneStopBit, %WSC_WordLength8)
' set hardware flow control
Code = SioFlow(Port, ASC("H"))
'acquire xyDriver
Code = xyAcquire(Port, Port)
'set xyDriver debug level
Code = xyDebug(0)
PRINT "Starting YMODEM receive (type Control-BREAK to quit)"
Code = xyStartRX(Port, Filename, %NCG, %YMODEM)

'run the YMODEM driver
Call RunXY(Port)
PRINT 
PRINT "All done."

Code = xyRelease()
Code = SioDone(Port)
END FUNCTION
