
;   DOTS.LSP by Javier Betelu
;   Agosto 1993
;   Marca No 1779049


(defun lname (/ initname index char)

;;; name for the linetype to be created: "DOTTED_scale factor_ltscale"

	(INITGET (+ 1 2 4))
	(setq scale (GETREAL "Scale factor: "))
	(setq lts (GETVAR "ltscale"))
	(setq initname (STRCAT "DOTTED_" (RTOS scale 2 2) "_" (RTOS lts 2 2)))
	(setq index 1)
	(setq linename "")

;;; there is the need to get rid of the invalid character "." for a linename

	(REPEAT (STRLEN initname)
		(setq char (SUBSTR initname index 1))
		(IF (/= char ".")
			(setq linename (STRCAT linename char))
			(setq linename (STRCAT linename "point"))
		)
		(setq index (+ 1 index))
	)
)

;---------------------------------------------------------------------------

(defun create ()

;;; numeric values required to simulate the uniform "dots" pattern

	(setvar "HPNAME" "U")
	(setvar "HPANG" (atan 2))
	(setvar "HPSPACE" (/ scale (SQRT 320)))
	(setvar "HPDOUBLE" 0)

;;; now, we create the file pattern

	(setq pat (/ scale lts (SQRT 204.8)))
)

;---------------------------------------------------------------------------

(defun ritto (/ arch) 

;;; write to a file of new creation

	(setq lin (GETVAR "dwgprefix"))
	(setq lin (STRCAT lin "DOTTED.LIN"))
	(setq arch (OPEN lin "w"))
	(WRITE-LINE (STRCAT "*" linename) arch)
	(WRITE-LINE (STRCAT "A,0,-" (RTOS pat 2 15)) arch)
	(CLOSE arch)
)

;-------------------------- UNIFORM DOTS R12 -----------------------------------

(defun c:dots12 (/ scale lts linename pat lin current)

;;; sets the dotted linetype and executes the boundary_hatch command

	(setvar "cmdecho" 0)
	
	(setq current (GETVAR "celtype"))
	(lname)
	(create)
	(ritto)
	(COMMAND "_linetype" "_l" linename lin "" ^C)
	(COMMAND "_linetype" "_s" linename "")
	(C:BHATCH)
	(COMMAND "_linetype" "_s" current "")
)

