--***************************************************************--
--                                                               --
--  TITLE:          AN ADA SOFTWARE METRIC                       --
--                                                               --   
--  MODULE NAME:    PACKAGE SPECIFICATION PARSER_1               --
--  FILE NAME:      PARSER_1.ADS                                 --
--                                                               --
--  LAST MODIFIED:  02 MAR 90                                    --
--                                                               --
--  DESCRIPTION:  This package contains thirty-six functions     --
--       that make up the top level productions for our top-down,--
--       recursive descent parser. Each function is preceded     --
--       by the grammar productions they are implementing.       --
--                                                               --  
--  CHANGE LOG:                                                  --
--              - changed function GENERIC_DECLARATION to check  --
--                for iterations, vice optional choice, of       --
--                GENERIC_PARAMETER_DECLARATION                  --
--                                                               --
--              - changed function FUNCTION_UNIT to allow for    --
--                renaming of functions.  Revised function will  --
--                more closely resemble function PROCEDURE_UNIT. --
--                Functions FUNCTION_BODY, FUNCTION_BODY_TAIL,   --
--                and FUNCTION_UNIT_TAIL have been deleted.      --
--                                                               --
--              - modified the production rules in functions     --
--                PACKAGE_DECLARATION and SUBPROGRAM_BODY to     --
--                make them more regular with other library unit --
--                functions.  Functions PACKAGE_BODY, PACKAGE_   --
--                BODY_TAIL, and PACKAGE_TAIL_END have been      --
--                deleted.                                       --
--                                                               --
--              - modified the production rules in function      --
--                TASK_DECLARATION to make them more regular     --
--                with other library unit functions.  Functions  --
--                TASK_BODY and TASK_BODY_TAIL were deleted.     --
--                                                               --
--              - modified function SELECT_STATEMENT to check    --
--                for optional SELECT_ENTRY_CALL vice required   --
--                SELECT_ENTRY_CALL. Also removed the check for  --
--                the optional name on BLOCK_STATEMENT and LOOP_ --
--                STATEMENT since the name will have been parsed --
--                before these functions could be called.        --
--                                                               --
--  COPYRIGHT:  The Ada source code in this file is Copyright    --
--              1990 by Source Translation & Optimization. There --
--              are no restrictions to the use of this source    --
--              code in any product or system that is released   --
--              in non-source code form. Resale of this source   --
--              code, without permission of STO, is a violation  --
--              of our Copyright.                                --
--                                                               --
--                                                               --
--  HELP:       For more information contact: Gregory Aharonian  --
--              Source Translation & Optimization, P.O. Box 404  --
--              Belmont, MA, 02178-0404            617-489-3727  --
--***************************************************************--

package PARSER_1 is

  function  GENERIC_DECLARATION   return boolean;
  function  PROCEDURE_UNIT        return boolean;
  function  FUNCTION_UNIT         return boolean;
  function  PACKAGE_DECLARATION   return boolean;
  function  PROPER_BODY           return boolean;

--
-- The following procedures are declared locally in the package body
--
--    function  GENERIC_PARAMETER_DECLARATION   return boolean;
--    function  GENERIC_FORMAL_PART             return boolean;
--    function  SUBPROGRAM_BODY                 return boolean;
--    function  TASK_DECLARATION                return boolean;
--    function  PACKAGE_UNIT                    return boolean;
--    function  BASIC_DECLARATIVE_ITEM          return boolean;
--    function  DECLARATIVE_PART                return boolean;
--    function  BASIC_DECLARATION               return boolean;
--    function  LATER_DECLARATIVE_ITEM          return boolean;
--    function  SEQUENCE_OF_STATEMENTS          return boolean;
--    function  STATEMENT                       return boolean;
--    function  COMPOUND_STATEMENT              return boolean;
--    function  BLOCK_STATEMENT                 return boolean;
--    function  IF_STATEMENT                    return boolean;
--    function  CASE_STATEMENT                  return boolean;
--    function  CASE_STATEMENT_ALTERNATIVE      return boolean;
--    function  LOOP_STATEMENT                  return boolean;
--    function  EXCEPTION_HANDLER               return boolean;
--    function  ACCEPT_STATEMENT                return boolean;
--    function  SELECT_STATEMENT                return boolean;
--    function  SELECT_STATEMENT_TAIL           return boolean;
--    function  SELECT_ALTERNATIVE              return boolean;
--    function  SELECT_ENTRY_CALL               return boolean;
--    function  TASK_DECLARATION                return boolean is separate;
--    function  PACKAGE_UNIT                    return boolean is separate;
--    function  BASIC_DECLARATIVE_ITEM          return boolean is separate;
--    function  DECLARATIVE_PART                return boolean is separate;
--    function  BASIC_DECLARATION               return boolean is separate;
--    function  LATER_DECLARATIVE_ITEM          return boolean is separate;
--    function  SEQUENCE_OF_STATEMENTS          return boolean is separate;
--    function  STATEMENT                       return boolean is separate;
--    function  COMPOUND_STATEMENT              return boolean is separate;
--    function  BLOCK_STATEMENT                 return boolean is separate;
--    function  IF_STATEMENT                    return boolean is separate;
--    function  CASE_STATEMENT                  return boolean is separate;
--    function  CASE_STATEMENT_ALTERNATIVE      return boolean is separate;
--    function  LOOP_STATEMENT                  return boolean is separate;
--    function  EXCEPTION_HANDLER               return boolean is separate;
--    function  ACCEPT_STATEMENT                return boolean is separate;
--    function  SELECT_STATEMENT                return boolean is separate;
--    function  SELECT_STATEMENT_TAIL           return boolean is separate;
--    function  SELECT_ALTERNATIVE              return boolean is separate;
--    function  SELECT_ENTRY_CALL               return boolean is separate;

end PARSER_1;
