-- **************************************************
-- *                                                *
-- *  Spacecraft_Sensor_Interface                   *  BODY
-- *                                                *
-- **************************************************
package body Spacecraft_Sensor_Interface is

  type PRESSURE_TABLE is array (NATURAL range <>) of PRESSURE;
  type TEMPERATURE_TABLE is array (NATURAL range <>) of TEMPERATURE;
  type RADIATION_TABLE is array (NATURAL range <>) of RADIATION_LEVEL;
  type INDEX_VECTOR is array (SPACECRAFT_SECTION) of NATURAL;

  P_Index : INDEX_VECTOR :=
    (5, 2, 1, 4, 3, 7, 6, 8, 9, 10);
  T_Index : INDEX_VECTOR :=
    (1, 2, 3, 4, 5, 6, 7, 8, 9, 10);
  R_Index : INDEX_VECTOR :=
    (10, 9, 8, 7, 6, 5, 4, 3, 2, 1);

  P_Table : constant PRESSURE_TABLE :=
    (32.5, 32.5, 32.5, 32.5, 50.0, 75.0, 80.0, 90.0, 110.0, 32.5, 32.5,
     20.0, 10.0, 30.0, 32.5, 32.5, 40.0, 250.0, 32.5);
  T_Table : constant TEMPERATURE_TABLE :=
    (70.0, 70.0, 71.0, 75.0, 80.0, 100.0, 120.0, 140.0, 130.0, 140.0,
     135.0, 130.0, 125.0, 120.0, 100.0, 80.0, 75.0, 73.0, 70.0);
  R_Table : constant RADIATION_TABLE :=
    (10.0, 20.0, 15.0, 20.0, 50.0, 100.0, 400.0, 500.0, 600.0, 700.0,
     1000.0, 50.0, 30.0, 20.0, 10.0, 5.0, 5.0, 8.0, 10.0);

  -- .................................................
  -- .                                               .
  -- .  Spacecraft_Sensor_Interface.Sensed_Value     .  BODY
  -- .                                               .
  -- .................................................
  function Sensed_Value
      (Location : in SPACECRAFT_SECTION) return PRESSURE is
  begin
    return P_Table(P_Index(Location));
  end Sensed_Value;

  function Sensed_Value
      (Location : in SPACECRAFT_SECTION) return TEMPERATURE is
  begin
    return T_Table(T_Index(Location));
  end Sensed_Value;

  function Sensed_Value
      (Location : in SPACECRAFT_SECTION) return RADIATION_LEVEL is
  begin
    return R_Table(R_Index(Location));
  end Sensed_Value;

  -- .................................................
  -- .                                               .
  -- .  Spacecraft_Sensor_Interface.Update           .  SPEC
  -- .                                               .
  -- .................................................
  procedure Update is

  begin

    for Location in SPACECRAFT_SECTION loop
      P_Index(Location) := P_Index(Location) + 1;
      if P_Index(Location) > P_Table'LAST then
        P_Index(Location) := 0;
      end if;

      T_Index(Location) := T_Index(Location) + 1;
      if T_Index(Location) > T_Table'LAST then
        T_Index(Location) := 0;
      end if;

      R_Index(Location) := R_Index(Location) + 1;
      if R_Index(Location) > R_Table'LAST then
        R_Index(Location) := 0;
      end if;
    end loop;

  end Update;

end Spacecraft_Sensor_Interface;

