--::::::::::
--clialsys.ada
--::::::::::
-- This implementation of Package Body CLI is Alsys-specific (SUN).
-- It requires the Alsys package DOS.
-- Alsys Ada, Version 5
with DOS;
package body CLI is

   LOCAL_ARGC : NATURAL;

   type TOKEN_SCAN_STATE is (OUTSIDE_OF_TOKEN, INSIDE_OF_TOKEN);

   function ARGC_VALUE (TOKENS : in STRING) return NATURAL is
      COUNTER : NATURAL := 0;
      CURRENT_STATE : TOKEN_SCAN_STATE := OUTSIDE_OF_TOKEN;
   begin
      for I in TOKENS'FIRST .. TOKENS'LAST loop
          case CURRENT_STATE is
              when OUTSIDE_OF_TOKEN =>
                  if TOKENS(I) > ' ' then
                      COUNTER := COUNTER + 1;
                      CURRENT_STATE := INSIDE_OF_TOKEN;
                  end if;
              when INSIDE_OF_TOKEN =>
                  if TOKENS(I) <= ' ' then
                      CURRENT_STATE := OUTSIDE_OF_TOKEN;
                  end if;
          end case;
      end loop;
      return COUNTER;
   end ARGC_VALUE;

   procedure INITIALIZE (PROGRAM_NAME        : in STRING;
                         COMMAND_LINE_PROMPT : in STRING) is
      
      --========================= PDL ===========================
      --|ABSTRACT:
      --|    INITIALIZE performs necessary initializations.
      --|DESIGN DESCRIPTION:
      --|    Set the value of LOCAL_ARGC by parsing tokens.
      --=========================================================
      
   begin
      LOCAL_ARGC := ARGC_VALUE (DOS.GET_PARMS) + 1;
   end INITIALIZE;
   
   function ARGC return NATURAL is
      
      --========================= PDL ===========================
      --|ABSTRACT:
      --|    ARGC returns the argument count.
      --|DESIGN DESCRIPTION:
      --|    Return LOCAL_ARGC.
      --=========================================================
      
   begin
      return LOCAL_ARGC;
   end ARGC;

   function ARG_VALUE (TOKENS : in STRING; INDEX : in NATURAL)
     return STRING is
       FIRST, LAST, COUNTER : NATURAL;
       CURRENT_STATE : TOKEN_SCAN_STATE := OUTSIDE_OF_TOKEN;
   begin
      FIRST := TOKENS'FIRST;
      LAST := TOKENS'FIRST-1;
      COUNTER := 0;
      if INDEX = 0 then
          return DOS.GET_PROGRAM_NAME;
      else
          for I in TOKENS'FIRST .. TOKENS'LAST loop
              case CURRENT_STATE is
                  when OUTSIDE_OF_TOKEN =>
                      if TOKENS(I) > ' ' then
                          COUNTER := COUNTER + 1;
                          CURRENT_STATE := INSIDE_OF_TOKEN;
                          if COUNTER = INDEX then
                              FIRST := I;
                              LAST := TOKENS'LAST;
                          end if;
                      end if;
                  when INSIDE_OF_TOKEN =>
                      if TOKENS(I) <= ' ' then
                          CURRENT_STATE := OUTSIDE_OF_TOKEN;
                          if COUNTER = INDEX then
                              LAST := I - 1;
                          end if;
                      end if;
              end case;
          end loop;
          if LAST < FIRST then
            return "";
          else
            return TOKENS(FIRST .. LAST);
          end if;
      end if;
   end ARG_VALUE;

   function ARGV (INDEX : in NATURAL) return STRING is
      
      --========================= PDL ===========================
      --|ABSTRACT:
      --|    ARGV returns the indicated argument string.
      --|DESIGN DESCRIPTION:
      --|    If INDEX is out of range, raise INVALID_INDEX
      --|    Run parse and return desired token.
      --=========================================================
      
   begin
      if INDEX >= LOCAL_ARGC then
         raise INVALID_INDEX;
      end if;
      return ARG_VALUE (DOS.GET_PARMS, INDEX);
   exception
      when INVALID_INDEX  =>
         raise ;
      when others    =>
         raise UNEXPECTED_ERROR;
   end ARGV;

begin -- Initialization section
  INITIALIZE("", "");   
end CLI;
