{$A+,B-,D-,E-,F-,I+,L-,N-,O-,R+,S+,V-}
{$IFDEF VER60}
  {$G-,X-}
{$ENDIF}
{$IFDEF VER70}
  {$G-,P-,Q-,T-,X-,Y-}
{$ENDIF}
{$M 1024, 0, 0}

program GUS_WriteConfig;    { Append or update configuration }
                            { information to or in GUS.EXE    for v1.70 !!!  }
uses DOS;

type
    FNameStr = string[12];

    ArcType = (ARC, ARp, ARJ, DWC, HA, HAP, HPK, HYP, LZH, PAK, SQZ, ZIP, ZOO);
    ArcCmds = (Extract, Replace, Display, Test);

    ArcData = record
                Ext : string[3];
                Prog: FNameStr;
                Cmd : array [ArcCmds] of string[10];
                Pth,
                Pwd : string[5];
              end;

    ArcCfg  = record
                Marker  : longint;
                ArcTable: array [ArcType] of ArcData;
              end;

const
    GUSname     = 'GUS.EXE';
    CfgMarker   = $AA535547;       {'GUS'+chr(170)}
    Unsupported = '**********';
    ArcInfo     : ArcCfg
    = (Marker   : CfgMarker;
       ArcTable :                         {     Extract       Replace       Display       Test        }
       ((Ext: 'ARC'; Prog: 'PKUNPAK .EXE'; Cmd:('-n        ', '-r        ', '-c        ', '-t        '); Pth: Unsupported;
                                                                                                       Pwd: 'g    '     ),
        (Ext: 'A7+'; Prog: 'XARC    .EXE'; Cmd:('          ', '/o        ', Unsupported , Unsupported ); Pth: Unsupported;
                                                                                                       Pwd: '/g   '     ),
        (Ext: 'ARJ'; Prog: 'ARJ     .EXE'; Cmd:('e -uy     ', 'e -y      ', 'p         ', 't         '); Pth: '<x   '    ;
                                                                                                       Pwd: ' -g  '     ),
        (Ext: 'DWC'; Prog: 'DWC     .EXE'; Cmd:('xow       ', 'xw        ', 'p         ', 't         '); Pth: 'r    '    ;
                                                                                                       Pwd: 'g    '     ),
        (Ext: 'HA '; Prog: 'HA      .EXE'; Cmd:('et        ', 'ety       ', Unsupported , 't         '); Pth: '<x   '    ;
                                                                                                       Pwd: Unsupported ),
        (Ext: 'HAP'; Prog: 'PAH     .EXE'; Cmd:('e         ', 'e         ', Unsupported , Unsupported ); Pth: Unsupported;
                                                                                                       Pwd: Unsupported ),
        (Ext: 'HPK'; Prog: 'HPACK   .EXE'; Cmd:('x -on -r  ', 'x -oa -r  ', 'p -r      ', 't -r      '); Pth: ' -p  '    ;
                                                                                                       Pwd: ' -c  '     ),
        (Ext: 'HYP'; Prog: 'HYPER   .EXE'; Cmd:('-x        ', '-xo       ', Unsupported , Unsupported ); Pth: 'p    '    ;
                                                                                                       Pwd: Unsupported ),
        (Ext: 'LZH'; Prog: 'LHA     .EXE'; Cmd:('e /m+     ', 'e /m+c+   ', 'p /m+     ', 't /m+     '); Pth: 'x+   '    ;
                                                                                                       Pwd: Unsupported ),
        (Ext: 'PAK'; Prog: 'PAK     .EXE'; Cmd:('e/WO      ', 'e/WA      ', 'p         ', 't         '); Pth: '/PATH'    ;
                                                                                                       Pwd: '/g=  '     ),
        (Ext: 'SQZ'; Prog: 'SQZ     .EXE'; Cmd:('e /o0     ', 'e /o1     ', 'p         ', 't         '); Pth: '<x   '    ;
                                                                                                       Pwd: Unsupported ),
        (Ext: 'ZIP'; Prog: 'PKUNZIP .EXE'; Cmd:('-n        ', '-o        ', '-c        ', '-t        '); Pth: ' -d  '    ;
                                                                                                       Pwd: ' -s  '     ),
        (Ext: 'ZOO'; Prog: 'ZOO     .EXE'; Cmd:('e:O       ', 'e:OS      ', 'e:p       ', 'e:N       '); Pth: '//   '    ;
                                                                                                       Pwd: Unsupported )
       )
      );  {NOTE: if the first character of an option string is a '<', then it means that the following letter
           should REPLACE the first letter of the command string and not be added to it like the other options.}
var
    CfgData : ArcCfg;
    GUSfile : file;


procedure ReadData (var F   : file;
                    var Data: ArcCfg);
 begin
  {$I-} reset(F, 1); {$I+}
  if IOresult <> 0
   then begin
         writeln('Can''t open ', GUSname);
         Halt(1);
        end;
  {$I-} seek(F, filesize(F)-sizeof(ArcCfg)); {$I+}
  if IOresult <> 0
   then begin
         writeln('Problem: cannot seek to byte location ', filesize(F), ' - ', sizeof(ArcCfg));
         Halt(1);
        end;
  {$I-} BlockRead(F, Data, sizeof(ArcCfg)); {$I+}
  if IOresult <> 0
   then begin
         writeln('Problem: cannot read ', sizeof(ArcCfg), ' bytes in ', GUSname, ' at offset ', filepos(F));
         Halt(1);
        end;
  close(F);
  writeln('Reading configuration information from ', GUSname)
 end; {ReadData}


procedure AppendData (var F   : file;
                      var Data: ArcCfg);
 begin
  Data.Marker:=CfgMarker;
  reset(F, 1);
  seek(F, filesize(F));
  BlockWrite(F, Data, sizeof(ArcCfg));
  close(F);
  writeln('Appending configuration information to ', GUSname)
 end; {AppendData}


procedure UpdateData (var F   : file;
                      var Data: ArcCfg);
 begin
  Data.Marker:=CfgMarker;
  reset(F, 1);
  seek(F, filesize(F)-sizeof(ArcCfg));
  BlockWrite(F, Data, sizeof(ArcCfg));
  close(F);
  writeln('Updating configuration information in ', GUSname)
 end; {UpdateData}

begin {=MAIN=}
 assign(GUSfile, GUSname);
 ReadData(GUSfile, CfgData);
 if CfgData.Marker = CfgMarker
  then UpdateData(GUSfile, ArcInfo)
  else AppendData(GUSfile, ArcInfo)
end.
