comment $

   +----------------------------------------------------------------------+
   |                                                                      |
   |           ASMWIZ  Copyright (c) 1990  Thomas G. Hanlin III           |
   |                                                                      |
   |                          ASMWIZ Demo Program                         |
   |                                                                      |
   |              assembled with the excellent OPTASM by SLR              |
   |                                                                      |
   +----------------------------------------------------------------------+

   The code here has been designed to be easily understandable and is not as
   efficient as the coding used in the actual library.
$


; the use of a dummy stack segment here eliminates the meaningless error
; message from LINK about there being no stack defined.

Sseg          segment byte stack 'prog'     ; dummy stack segment
Sseg          ends

Cseg          segment byte public 'prog'
                                                        assume cs:Cseg, ds:Cseg, ss:Sseg

              org            100h



extrn  MV_INIT:NEAR, MV_LOCATE:NEAR, MV_MODE:NEAR, MV_GETMODE:NEAR
extrn  MV_POPUP:NEAR, MV_STROUT:NEAR, MV_HIDECURSOR:NEAR
extrn  MV_SHOWCURSOR:NEAR, MV_STROUT:NEAR, MV_INSLINE:NEAR, MV_DELLINE:NEAR
extrn  MV_INSCHR:NEAR, MV_DELCHR:NEAR, MV_COLOR:NEAR, MV_CLS:NEAR
extrn  MV_FIXCOLOR:NEAR, MD_TICK:NEAR, MI_GETSCREEN:NEAR, MI_PARSE:NEAR
extrn  S0_LENGTH:NEAR, S0_UPCASE:NEAR, ME_BLOAD:NEAR



MAIN          proc           far       ; ASMWIZ example program
              call           Initialize     ; initialize screen and colors
              call           ShowWelcome    ; display welcome message
              call           SlideWelcome   ; slide welcome message left
              call           ShowWindow     ; display pop-up window w/ text
              call           WaitOnKey      ; display "press any" and wait
              call           Picture        ; display picture (if CGA/EGA/VGA)
              call           Terminate      ; restore original screen mode, etc
              mov            ax,4C00h       ;
              int            21h            ; exit program
MAIN          endp                     ; ASMWIZ example program



Initialize    proc           near      ; initialize the screen
              call           MV_GETMODE     ; get current screen mode
              mov            OldMode,al     ; save it
              call           MV_INIT        ; initialize display routines
              mov            al,3           ; mode 3: 80x25 color text
              call           MV_MODE        ; set display mode
              call           MV_HIDECURSOR  ; turn off the cursor
              mov            si,0080h       ; pointer to the command line
              lea            di,FileBuf     ; pointer to filename buffer
              lea            bx,OptBuf      ; pointer to option buffer
              mov            al,"/"         ; use normal DOS switch character
              call           MI_PARSE       ; parse the command line
              or             ah,ah          ; is there an option?
              jz             CheckCRT       ;   no, go check the CRT type
              mov            si,bx          ; pointer to first option
              mov            di,bx          ;
              call           S0_UPCASE      ; convert it to uppercase
              cmp byte ptr   [bx],"B"       ; is it /B for monochrome mode?
              jne            CheckCRT       ;   no, check CRT type
              mov            al,1           ; set to mono
              jmp            SetCRT         ;   go set type
CheckCRT:     call           MI_GETSCREEN   ; see what the screen type is
SetCRT:       call           MV_FIXCOLOR    ; set the color handler to suit
              mov            al,2Fh         ; bright white on green
              call           MV_COLOR       ; set text color
              call           MV_CLS         ; clear screen to new color
              ret                           ;
Initialize    endp                     ; initialize the screen



ShowWelcome   proc           near      ; display welcome message
              mov            dx,0125h       ; row 1, column 37
              call           MV_LOCATE      ; set cursor location
              lea            dx,WelcomeMsg  ; ptr to "Welcome"
              call           MV_STROUT      ; display it
              mov            cx,8           ;
Welcome1:     call           MV_INSLINE     ; scroll it down
              push           cx             ;
              mov            cx,1           ;
              call           MD_TICK        ; delay an 18th of a second
              pop            cx             ;
              loop           Welcome1       ; ...nine times
              mov            dx,0B25h       ; row 11, column 37
              call           MV_LOCATE      ; set cursor location
              lea            dx,ToTheMsg    ; ptr to "to the"
              call           MV_STROUT      ; display it
              mov            dx,0D01h       ; row 13, column 1
              call           MV_LOCATE      ; set cursor location
              lea            dx,AsmMsg      ; ptr to "ASM" <cr>
              call           MV_STROUT      ; display it
              mov            cx,37          ;
Welcome2:     call           MV_INSCHR      ; scroll it right
              push           cx             ;
              mov            cx,1           ;
              call           MD_TICK        ; delay an 18th of a second
              pop            cx             ;
              loop           Welcome2       ; ...37 times
              mov            dx,0D4Dh       ; row 13, column 73
              call           MV_LOCATE      ;
              lea            dx,WizMsg      ; ptr to "WIZ"
              call           MV_STROUT      ; display it
              mov            dx,0D29h       ; row 13, column 41
              call           MV_LOCATE      ; set cursor location
              mov            cx,36          ;
Welcome3:     call           MV_DELCHR      ; scroll it left
              push           cx             ;
              mov            cx,1           ;
              call           MD_TICK        ; delay an 18th of a second
              pop            cx             ;
              loop           Welcome3       ; ...36 times
              mov            dx,1925h       ; row 25, column 37
              call           MV_LOCATE      ; set cursor location
              lea            dx,LibraryMsg  ; ptr to "Library"
              call           MV_STROUT      ; display it
              mov            dx,0E01h       ; row 14, column 1
              call           MV_LOCATE      ; set cursor location
              mov            cx,10          ;
Welcome4:     call           MV_DELLINE     ; scroll it up
              push           cx             ;
              mov            cx,1           ;
              call           MD_TICK        ; delay an 18th of a second
              pop            cx             ;
              loop           Welcome4       ; ...10 times
              ret                           ;
ShowWelcome   endp                     ; display welcome message



SlideWelcome  proc           near      ; slide welcome message left
              mov            dx,0901h       ; row 9, column 1
              mov            ax,4           ;
ScrollAll:    mov            cx,20          ; columns to scroll
LineLeft:     call           MV_LOCATE      ; set cursor position
              call           MV_DELCHR      ; scroll it left
              loop           LineLeft       ;   go for all columns
              add            dh,2           ; move to next line
              dec            ax             ; done yet?
              jnz            ScrollAll      ;   no, go for next row
              ret                           ;
SlideWelcome  endp                     ; slide welcome message left



ShowWindow    proc           near      ; display pop-up window w/ text
              lea            dx,ScrWindow   ;
              call           MV_POPUP       ; pop up intro window
              lea            si,WindowText  ; pointer to window text
              mov            dx,word ptr ScrWindow
              xchg           dl,dh          ;
              add            dx,0102h       ; starting text position
ShowText:     call           MV_LOCATE      ; set cursor position
              call           S0_LENGTH      ; determine length of text
              jcxz           ShoWindowXit   ;   if zero, we're done-- go exit
              mov            al,[si]        ; get text color
              call           MV_COLOR       ; set it
              inc            si             ; skip over color to actual text
              xchg           dx,si          ;
              call           MV_STROUT      ; display the text
              xchg           dx,si          ;
              add            si,cx          ; move to next text line
              inc            dh             ; move to next screen line
              jmp            ShowText       ;   go for all text
ShoWindowXit: ret                           ;
ShowWindow    endp                     ; display pop-up window w/ text



WaitOnKey     proc           near      ; display "press any key", wait for it
              mov            dx,191Bh       ; row 25, column 26
              call           MV_LOCATE      ; set cursor location
              mov            al,74h         ; red on white
              call           MV_COLOR       ;
              lea            dx,PressAnyMsg ; ptr to "Press any key..."
              call           MV_STROUT      ; display it
              mov            al,07h         ; normal video
              call           MV_COLOR       ;
              mov            ah,7           ; get a key
              int            21h            ;
              or             al,al          ; is it extended?
              jnz            WaitOnKeyXit   ;   no, go exit
              mov            ah,7           ; get the rest of the key
              int            21h            ;
WaitOnKeyXit: ret                           ;
WaitOnKey     endp                     ; display "press any key", wait for it



Picture       proc           near      ; display picture (if CGA/EGA/VGA)
              call           MI_GETSCREEN   ; get active display type
              or             al,al          ; color display?
              jnz            PictureXit     ;   no, go exit
              cmp            ah,3           ; CGA?
              je             CGApic         ;   yep, go do CGA picture
              cmp            ah,4           ; EGA?
              je             EGApic         ;   yep, go do EGA picture
              cmp            ah,6           ; VGA?
              jne            PictureXit     ;   no, go exit
EGApic:       mov            al,16          ; EGA/VGA 640x350 graphics mode
              call           MV_MODE        ; set the screen mode
              lea            dx,EGAfile     ; EGA file name
              call           ME_BLOAD       ; load it onto the screen
              jmp            WaitForKey     ;   go wait for a keypress
CGApic:       mov            al,6           ; CGA 640x200 graphics mode
              call           MV_MODE        ; set the screen mode
              lea            dx,CGAfile     ; CGA file name
              call           ME_BLOAD       ; load it onto the screen
WaitForKey:   mov            ah,7           ; get a key
              int            21h            ;
              or             al,al          ; is it extended?
              jnz            PictureXit     ;   no, go exit
              mov            ah,7           ; get the rest of the key
              int            21h            ;
              mov            al,3           ; text mode
              call           MV_MODE        ; set the video mode
PictureXit:   ret                           ;
Picture       endp                     ; display picture (if CGA/EGA/VGA)



Terminate     proc           near      ; restore original screen mode, etc
              mov            al,OldMode     ; get old screen mode
              call           MV_MODE        ; set video mode
              call           MV_SHOWCURSOR  ; restore the cursor
              ret                           ;
Terminate     endp                     ; restore original screen mode, etc



WelcomeMsg    db "Welcome",0
ToTheMsg      db "to the",0
AsmMsg        db "ASM",13,0
WizMsg        db "WIZ",0
LibraryMsg    db "Library",0
PressAnyMsg   db "Press any key to continue",0

ScrWindow     db 2,40,23,79        ; window coordinates
              db 1,4Eh             ; frame type and color
              dw offset ScrTitle   ; pointer to title
ScrTitle      db "The Assembly Wizard's Library",0   ; window title

WindowText    db 41h,"Since you're evidently an assembly  ",0
              db 41h,"language programmer and may be      ",0
              db 41h,"considered reasonably sophisticated,",0
              db 41h,"I'll skip the sales pitch here and  ",0
              db 41h,"just list a few of the capabilities ",0
              db 41h,"of the ASMWIZ library:              ",0
              db 41h,0
              db 70h,"DOS, BIOS, and machine-level display",0
              db 30h,"Save/restore any part of the display",0
              db 70h,"Base conversions (integer and long) ",0
              db 30h,"Long integer math support           ",0
              db 70h,"Delay and countdown services        ",0
              db 30h,"Pseudo-random number generation     ",0
              db 70h,"File matching, command-line parsing ",0
              db 30h,"Environment scanning                ",0
              db 70h,"Handling of Break and Control-C     ",0
              db 30h,"String functions                    ",0
              db 70h,"Mouse support and sound generation  ",0
              db 30h,"Checksum and CRC calculation        ",0
              db 70h,"International time and date support ",0,0

FileBuf   db 80 dup(?)
OptBuf    db 80 dup(?)

OldMode   db 3

CGAfile   db "EXAMPLE.CGA",0
EGAfile   db "EXAMPLE.EGA",0

Cseg          ends
              end            MAIN
