	name	pmode
	page	55,80
	title	'PMODE - set printing mode directly from DOS
;	
;	PMODE utility to set printing modes directly from DOS for LPT1
;
;	by	Chris Lindberg
;
;	Uncopyright 1982
;
;	Command syntax is 
;
;		A>pmode [c,c,c...]
;
;			and c is one or more characters
;			in upper or lower case
;			from the following list:
;
;			I = Italics on
;			C = Compressed on
;			E = Emphasized on
;			X = Expanded on
;			D = Double strike on
;
;			Pmode without any arguments resets the printer
;			to a cold start setting.
;
;		PMODE is a simple assembly language program that sends 
;		escape sequences to the printer for the various print
;		modes available.  This version is set up for the IBM
;		equivalents of the MX-80 and MX-100.  It should work as
;		well for the MX-80, MX-100 and other Epson models.  If
;		your printer uses other escape sequences, I've provided
;		the assembler listing so that you can make the necessary
;		changes.  If you don't have an assembler, you can use
;		DEBUG to change the program.  The escape sequences used
;		in this program are:
;
;					CODES SENT
;		MODE		HEXADECIMAL		DECIMAL
;		---------	-----------           -----------
;
;		Italics on	  1b + 34		27 + 52
;		Compressed on	  1b + 50		27 + 80
;		Expanded on	  1b + 53		27 + 83
;		Emphasized on	  1b + 45		27 + 69
;		Double strike on  1b + 47		27 + 71
;
;
;	The actual code segment star4s here:
;
	input	equ	08h	;command tail line buffer address
	cr	equ	0dh	;ASCII carraige return
;
	cseg	segment	byte
		assume	cs:cseg,ds:cseg
;
		org	0100h	;since this will be a .COM file
;
	reset:	mov	al,0	;reset the printer to a cold
		mov	ah,1	;start setting
		mov	dx,0
		int	17h
;
		mov	si,offset input
		cld		;get address of command tail and...
		lodsb		;move it forward.  Check length
		or 	al,al	;of buffer.  
		jz	done 	;If zero, then we're done
;
	read:	lodsb		;get next byte of buffer
		cmp	al,cr	;Is it a CR?
		je	done	;if it is, then we're done
		or	al,20h	;otherwise, fold it to lower case
		cmp	al,'a'  ;make sure it's between 'a'
		jb	read
		cmp	al,'z'	;and 'z'
		ja	read	;otherwise, skip it.
;
		cmp	al,'i'	;Is it 'i
		jne	emph	;if it isn't, go on
		mov	al,1bh	;send escape sequence...
		call 	print	;...to printer
		mov	al,34h	;and send code for italics...
		call 	print	;.... to printer
		jmp	short read
;
	emph:	cmp	al,'e'	;is it 'e'?
		jne	double
		mov	al,1bh
		call	print
		mov	al,45h
		call	print
		jmp	short read
;
	double:	cmp	al,'d'	;is it 'd'?
		jne	compr
		mov	al,1bh
		call	print
		mov	al,47h
		call	print
		jmp	short read
;
	compr:	cmp	al,'c'	;is it a 'c'?
		jne	expan	
		mov	al,1bh
		call	print
		mov	al,50h
		call	print
		jmp	short read
;
	expan:	cmp	al,'x'	;is it a 'x'?
		jne	read	
		mov	al,1bh
		call	print
		mov	al,53h
		call	print
		jmp	sh/rt read
;
	done:	int	20h	;all done...return to DOS
;
	print	proc	near	;routine to send contents of 
		push	dx	;al to printer
		mov	dx,0
		mov	ah,0
		int	17h
		pop	dx
		ret
	print	endp
;
	cseg	ends
;
end contents of 
		push	dx	;al to printer
		mov	dx,0
		mov	ah,0
		int	17h
		pop	dx
		ret
	print	endp
;
	