/****************************************************************

	ui_init.c       Initialization routines for
			The Bywater Graphical User Interface

			Copyright (c) 1991, Ted A. Campbell

			Bywater Software
			P. O. Box 4023 
			Duke Station 
			Durham, NC  27706

			email: tcamp@hercules.acpub.duke.edu

	Copyright and Permissions Information:

	All U.S. and international copyrights are claimed by the
	author. The author grants permission to use this code
	and software based on it under the following conditions:
	(a) in general, the code and software based upon it may be 
	used by individuals and by non-profit organizations; (b) it
	may also be utilized by governmental agencies in any country,
	with the exception of military agencies; (c) the code and/or
	software based upon it may not be sold for a profit without
	an explicit and specific permission from the author, except
	that a minimal fee may be charged for media on which it is
	copied, and for copying and handling; (d) the code must be 
	distributed in the form in which it has been released by the
	author; and (e) the code and software based upon it may not 
	be used for illegal activities. 

****************************************************************/

#include "stdio.h"
#include "gr.h"
#include "kb.h"
#include "dr.h"
#include "ui.h"

#ifdef __STDC__
#include "stdlib.h"
#else
extern char *getenv();
#endif

static struct  gr_window ui_fullscreen;
char ui_tbuf[ 128 ];
int  ui_screen = GR_PRIMARY;
int  x_savescreen;
struct gr_window    *ui_grwind;
char   ui_ready = 0;
char   ui_fontpath[ 128 ];
struct pbm_struct ui_elicon;         /* elevator icon */
struct pbm_struct ui_lefticn;        /* left icon */
struct pbm_struct ui_righticn;       /* right icon */
struct pbm_struct ui_upicn;          /* up icon */
struct pbm_struct ui_downicn;        /* down icon */
struct pbm_struct ui_clicon;         /* close window icon */
struct pbm_struct ui_reicon;         /* resize window icon */
struct pbm_struct ui_mvicon;         /* move window icon */
struct pbm_struct ui_deficon;        /* default file icon */
struct pbm_struct ui_foldicon;       /* file folder icon */
struct pbm_struct ui_exicon;         /* executable file icon */

ui_init()
   {
   char *pp;                            /* temp path pointer */

   /* See if BWPATH variable is set */

   if ( ( pp = getenv( BWENVARNAME ) ) != NULL )
      {
      sprintf( ui_fontpath, "%s%c", pp, dr_fs );
      }

   /* Initialize the screen and keyboard */

   gr_init( &ui_fullscreen, ui_fontpath );
   kb_init();

   gr_font( GR_PRIMARY, F_DEFAULT,
      ui_fullscreen.ymax / DEFAULT_FONT_SIZE );

   ui_grwind = &ui_fullscreen;
   ui_setscreen( GR_PRIMARY );

   ui_ready = TRUE;

   /* initialize icons */

   ui_seticons( BLACK, WHITE );

   }

ui_setscreen( screen )
   int screen;
   {
   ui_screen = screen;
   }

ui_push()
   {
   x_savescreen = ui_screen;
   }

ui_pop()
   {
   ui_screen = x_savescreen;
   }

ui_seticons( foreground, background )
   int foreground, background;
   {

   ui_pbmread( "elevator.pbm", &ui_elicon, background, foreground );
   ui_pbmread( "left.pbm", &ui_lefticn, foreground, background );
   ui_pbmread( "right.pbm", &ui_righticn, foreground, background );
   ui_pbmread( "up.pbm", &ui_upicn, foreground, background );
   ui_pbmread( "down.pbm", &ui_downicn, foreground, background );
   ui_pbmread( "close.pbm", &ui_clicon, foreground, background );
   ui_pbmread( "resize.pbm", &ui_reicon, foreground, background );
   ui_pbmread( "move.pbm", &ui_mvicon, foreground, background );
   ui_pbmread( "default.pbm", &ui_deficon, foreground, background );
   ui_pbmread( "folder.pbm", &ui_foldicon, foreground, background );
   ui_pbmread( "exec.pbm", &ui_exicon, foreground, background );

   }
