/*
   Module:  hpcodes.h
   Date:    3/9/92
   Version: 1.0
   Author:  Dave Lutz
   Email:   lutz@psych.rochester.edu
   Copyright: 1992 University of Rochester, Psychology Dept.

   Disclaimer:  This software is distributed free of charge.  As such, it
                comes with ABSOLUTELY NO WARRANTY.  The user of the software
                assumes ALL RISKS associated with its use.

                Your rights to modify and/or distribute this software are
                outlined in the file ADI7221.DOC.

   Purpose: This module provides the code definitions for HP 7221 plotting
            devices.  These codes can be used to convert an AutoCad ADI
            file to a file that can be sent directly to the plotter for
            plotting.

            The codes in this file work for either the 7221A (4 pen plotter)
            or the 7221C (10 pen plotter).  They would probably work for
            any plotter in the 7221 series, but that has not been verified.
*/

/* maximum pen speed setting */
#define HP_MAXSPEED 36

/* HP_BEGINPLOT actually just sends the pen to the upper right grid point */
#define HP_BEGINPLOT "pb>@_P}"
#define HPBP_BYTES   7
/* HP_ENDPLOT actually just sends the pen to the upper right grid point */
#define HP_ENDPLOT   "pb>@_P}"
#define HPEP_BYTES   7
#define HP_MOVE      "p"
#define HPM_BYTES    1
#define HP_END_MOVE  "}"
#define HPEM_BYTES   1
#define HP_DRAW      "q"
#define HPD_BYTES    1
#define HP_END_DRAW  "}"
#define HPED_BYTES   1
#define HP_NEWPEN    "v"
#define HPNP_BYTES   1
#define HP_SETSPEED  "~V"
#define HPSS_BYTES   2
#ifdef VARIABLE_DASHES
# define HP_LINETYPE "~R"
# define HPLT_BYTES  2
#else
# define HP_LINETYPE "~Q"
# define HPLT_BYTES  2
#endif
/* PEN_CHANGE is really just a pen up command. */
#define HP_PENCHANGE "p}"
#define HPPC_BYTES   2
/* 
   HP_ABORTPLOT is empty because it should never actually be called.  If a
   plot is aborted in AutoCad while it is being sent to a file, AutoCad will
   not create the file.
*/
#define HP_ABORTPLOT ""
#define HPAP_BYTES   0

/*
  The following section contains the defines for the individual line types.
  If you want to modify these, you should probably read the HP manual, but
  I've included some pointers here to make things a little easier.

  To define a line type, you specify the pattern of dashes, dots, and spaces
  that are to be used, and then specify the length (in plotter units) for the
  entire pattern.  I based the following line types on the assumption that
  a dash of length 1 should use 10 plotter units.  This was done partly
  because I like that length, and partly because working with 10's is easier.

  For example, the longest pattern (PHANTOM), looks like this:

        '----- - - '

  This pattern has can be divided into 10 units of length 1, so the length
  of the pattern is 100 plotter units.

  When the pattern is specified, you have to add 32 to the length of a dash
  so that it can be differentiated from a space.  This results in the
  following pattern specification:

       37 1 33 1 33 1

  To specify the code for the #define, the numbers in the pattern spec must
  be converted to SBN format.  I've already done this for dots, dashes up to
  length 10, and spaces up to length 10.  You can find them in the table
  shown below.

        SBN code for Dot = SPACE

        SBN codes for Dashes and Spaces

     Length   Dash  Space
             +-----------+
       1     |  !  |  A  |
       2     |  "  |  B  |
       3     |  #  |  C  |
       4     |  $  |  D  |
       5     |  %  |  E  |
       6     |  &  |  F  |
       7     |  '  |  G  |
       8     |  (  |  H  |
       9     |  )  |  I  |
      10     |  *  |  J  |
             +-----------+

  When specifying the length of the pattern, you must convert that length
  to MBN format.  To simplify this procedure, I've converted all multiples
  of 10 from 20 to 150.  You can find them in the table shown below.

        MBN codes for lengths 20 - 150 (step 10)

           20  `T
           30  `^
           40  `(
           50  `2
           60  `<
           70  aF
           80  aP
           90  aZ
          100  a$
          110  a.
          120  a8
          130  bB
          140  bL
          150  bV

  As you can see from the above table, you will have to do the math by hand
  if you want lengths that are not multiples of 10 (ie there is no easy
  pattern to the second character in each code).

  When you look at the following #defines remember that the last two chars
  in each #define represent the length of the pattern in plotter units.  If
  you modify these, and end up with a plotter unit length that requires more
  than two chars, you should probably include a comment indicating that
  fact.
  
  There is a name_BYTES #defined for each pattern. This specifies the total 
  number of bytes used in the string that will be sent to the plotter.  This 
  can be passed to funtions that need to know the byte counts, saving you 
  from calculating it each time the codes are used.
  
  Now for the codes...
*/

#define LT_SOLID     "" /* solid is the default, thus a NULL string */
#define LTS_BYTES    0

#define LT_DASHED    "\"A`^"
#define LTDA_BYTES    4

#define LT_HIDDEN    "!A`T"
#define LTH_BYTES    4

#define LT_CENTER    "$A!AaF"
#define LTC_BYTES    6

#define LT_PHANTOM   "%A!A!Aa$"
#define LTP_BYTES    8

#define LT_DOT       " A`T"
#define LTDO_BYTES   4

#define LT_DASHDOT   "\" A`("
#define LTDD_BYTES   5

#define LT_BORDER    "\"A\"A AaP"
#define LTB_BYTES    8

#define LT_DIVIDE    "\"A A AaF"
#define LTDI_BYTES   8
