@echo off
if (%1)==(SUBROUTINE1) goto %1
cls
goto EndDoc
----------------------------------------------------------------------
This demo batch file shows how to use /If (input format = file) and
/Ftcomp (function = time compare) to list files that are younger than,
or at least as old as, %numdays%.  The basic logic in SUBROUTINE1 could
be customized to do some more useful work, rather than just listing the
filename.

If environment variable RAMDISK is set before running this batch
file, then it will use the RAM disk and run a bit faster.
----------------------------------------------------------------------
:EndDoc

rem set the number of days in the past that will be our cutoff point
SET NUMDAYS=3

rem save today's date, so we can restore it later
fdate /Ff /Omm-dd-yy /P"@set today=">%RAMDISK%JUNKTEMP.BAT
call %RAMDISK%JUNKTEMP.BAT

rem determine the date %numdays% in the past
fdate /Fsub /N%numdays%  /Omm-dd-yy /P"@set pastdate=">%RAMDISK%JUNKTEMP.BAT
call %RAMDISK%JUNKTEMP.BAT
del %RAMDISK%JUNKTEMP.BAT>nul

rem set current system date to %pastdate%
DATE %pastdate%

rem create a file (whose creation date will be %pastdate%) to test against
echo File created to bear creation date: %pastdate%> %RAMDISK%DATETEST.TMP

rem set current system date back to %today%
DATE %today%


echo ------------------------------------------------------------------
Fdate /Fsub /N%numdays% /Ofull /P"FILES CREATED LESS THAN %numdays% DAYS AGO (AFTER " /S")"
echo ------------------------------------------------------------------
rem call a subroutine to list all of the files in this directory
rem whose file date is greater than (after) %pastdate%
rem ------------------------------------------------------------------
for %%v in (*.*) do  CALL %0 SUBROUTINE1 %%v
echo ------------------------------------------------------------------
echo END: FILES CREATED LESS THAN %numdays% DAYS AGO
echo ------------------------------------------------------------------
PAUSE

CLS
echo ------------------------------------------------------------------
Fdate /Fsub /N%numdays% /Ofull /P"FILES CREATED AT LEAST %numdays% DAYS AGO (BEFORE " /S")"
echo ------------------------------------------------------------------
rem call a subroutine to list all of the files in this directory
rem whose file date is less than or equal (earlier than) %pastdate%
rem ------------------------------------------------------------------
for %%v in (*.*) do  CALL %0 SUBROUTINE1 %%v  NOT
echo ------------------------------------------------------------------
echo END: FILES CREATED AT LEAST %numdays% DAYS AGO
echo ------------------------------------------------------------------
PAUSE

rem Delete these environment variables.  We don't need them any more.
set numdays=
set today=
set pastdate=
set tcomp=
del %RAMDISK%JUNKTEMP.BAT>nul

goto endit



:SUBROUTINE1
shift
Fdate /Ftcomp /If /A%1 /B%RAMDISK%DATETEST.tmp /P"@set Tcomp=">%RAMDISK%JUNKTEMP.BAT
CALL %RAMDISK%JUNKTEMP.BAT
if %2 (%Tcomp%)==(GT) Fdate /Ff /If /A%1 /P"%1 created at " /Ofull
rem fall through to endit

:endit
