	PAGE ,132
; XECHO.ASM  version 1.1  -  by John Wright, 19-March-1988
;
; Utility for generating character strings which include control and special
; characters.  Strings are specified on the command line using "Lotus 1-2-3"
; like syntax with "\nnn" being translated as the ASCII code for decimal 'nnn'.
; Strings are sent to the standard output and may be redirected to a file or a
; device.  Note that unlike the ECHO command in DOS, XECHO does not append a
; CR,LF pair to the output string.
;
; Usage:
; 		XECHO [xxxxx....] [> file or device spec]
;
;	where "x" can be either:
;	- any character which can be entered on a DOS command line (ie. blanks
;	  and any keyboard characters or ALT-key sequences not filtered by DOS 
;	  such as CR (Enter), LF, BS, DEL, ^C, ^P, ">", "<", "|", etc.);  all
;	  characters are sent to standard output as is.
;       - a sequence of characters beginning with "\":
;	  - "\" followed by 1 to 3 digits is translated as the ASCII code 
;	    represented by interpreting the digits as a decimal value modulo
;	    256; the sequence is terminated by a non-digit, the end of the
;	    command line or a fourth digit.
;	 - "\" followed by a non-digit character is translated as that char.
;
; Notes:
;	- TAB characters in the command line string are not expanded.
;       - leading blanks and TABs (between "xecho" and the first visible char.
;	  following on the command line are skipped; to send strings beginning
;	  with a blanks or tabs use \20 or \9 for at least for the first one.
;       - trailing blanks and TABs (between the last visible character of the
;	  command and the CR, ">", "<", or "|") are preserved and sent as is.
;       - "\1", "\01" and "\001" are equivalent (assuming for the first two
;	  cases that the following character is not a digit) to ^A; 
;       - "\0001" would be translated as ASCII NUL followed by "1".
;       - to send the back-slash character, "\", use "\\" in the command line.
;       - "\" at the end of the command line is ignored.
;       - the command "xecho >null" creates an empty file "null".
; 
; XECHO is particularly useful for sending control strings to on-line devices
; such as printers or modems.  For instance "xecho \15>prn" selects condensed
; printing on an Epson compatible printer, "xecho \027@>prn" sends a printer
; reset, and "xecho \12>prn" sends a form-feed.
;
; Revisions:
;	1.0 -  2-March-88, J.W. - original
;	1.1 - 19-March-88, J.W. - limited no. digits after '\' to 3 for
;		compatibility with Lotus-style strings + improved code
;
; And lest we forget,
;	"Lotus" *and* "1-2-3" are trademarks of Lotus Development Corp.
; 	"Epson" is a trademark of Seiko Epson Corp.
;
; XECHO is declared in the public domain by its author.
;
;
escchar	equ '\'		; escape char for special processing
;
blank	equ 20h		; blank char.
tab	equ 09h		; tab char.
;
params  equ 80h		; address of DOS command line buffer
;
writefh	equ 40h		; DOS function code to write to a file handle
dosexit	equ 4ch		; DOS function code to exit program
;
stdout	equ 1		; file handle for standard output
;
;
doscall	MACRO function	;; Call the DOS interrupt 
	mov ah,function	;; Put function number in AH 
	int 21h
	ENDM
;
;
	org	0100h
code	segment	public 'CODE'
	assume	cs:code, ds:code, es:code, ss:code
start	proc	far
	mov si,params	; SI = address of command line buffer
	lodsb		; load number of chars in param string.
	mov cl,al	; save it in CX register.
	xor ch,ch	; (zero high byte)
	mov di,si	; DI = SI (now params+1) so that the output string
			; overwrites the parameter string as it is processed.
;
;			  loop for leading blanks and tabs
;
loop1:	jcxz term	; if no more chars, exit without doing anything
	dec cx		; else decrement CX
	lodsb		; and load next char.
	cmp al,blank	; if a blank, loop.
	jz loop1
	cmp al,tab	; if a tab, loop.
	jz loop1
	jmp chkesc	; else process it.
;
;			  loop for characters to be processed
;
loop2:	jcxz fin	; if no more, goto output string
	dec cx		; else decrement CX
	lodsb		; and load next char.
chkesc:	cmp al,escchar	; if the escape char ('\')
	jz escape	; go to process it
store:	stosb		; else store as output char.
	jmp loop2	; continue.
;
;			  process special escape sequences
;
escape:	jcxz fin	; if no more, ignore escape and go to output string
	dec cx		; else decrement CX
	lodsb		; and load next char.
	cmp al,'0'	; if less than "0", treat as regular char
	jl store	; (go store it).
	cmp al,'9'	; if greater than "9" treat as regular char
	jg store	; (go store it).
	xor bx,bx	; else zero BX to hold converted digit
	mov bp,3	; and set BP to 3, max no. of digits to convert
;
;			  loop for digits in escape seq.
;
loop3:	sub al,'0'	; convert digit char to byte value in AX.
	xor ah,ah	; (zero high byte)
	add bx,ax	; BX = BX+AX
	jcxz endesc	; if no more char in line, finish escape processing
	dec bp		; else decrement BP
	jz endesc	; if zero, stop converting & finish escape processing
	dec cx		; else decrement CX
	lodsb		; and load next char.
	cmp al,'0'	; if less than "0", treat as reqular char and
	jl backup	; end of escape seq.
	cmp al,'9'	; if greater than "9", treat as regular char and
	jg backup	; end of escape seq.
			; else multiply BX by 10
	mov dx,bx	; (DX = BX)
	shl dx,1	; (DX = DX*2)
	shl dx,1	; (DX = DX*4)
	add bx,dx	; (BX = BX+DX)
	shl bx,1	; (BX = BX*2).
	jmp loop3	; goto add new digit into BX and continue
;
;			  backup posn in command line buffer
;
backup: inc cx		; increment CX
	dec si		; decrement SI
;
;			  end of escape seq processing
;
endesc:	mov al,bl	; AL = low byte of escape seq number in BX
	jmp store	; go to store it
;
;			  output string
;
fin:	mov dx,params+1	; DX = address of start of output string.
	mov cx,di	; CX = DI = address of end of output string + 1.
	sub cx,dx	; CX = CX-DX = number of chars in output string.
	jcxz term	; if zero, end without doing anything
	mov bx,stdout	; else BX = file handle for standard output.
	doscall writefh	; write to file handle
term:	xor al,al	; zero al for exit code
	doscall dosexit	; exit program
start	endp
	code	ends
	end
