/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*  (C) Copyright 1987-91, Bit Bucket Software Co., a Delaware Corporation. */
/*                                                                          */
/*                                                                          */
/*                      BinkleyTerm "WaZOO" Processor                       */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.250.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:491/0                          */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*                                                                          */
/*  This module is based largely on a similar module in OPUS-CBCS V1.03b.   */
/*  The original work is (C) Copyright 1987, Wynn Wagner III. The original  */
/*  author has graciously allowed us to use his code in this work.          */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/* Include this file before any other includes or defines! */

#include "includes.h"

extern int WaZOO_callback (char *);
extern int WaZOO_time (long);

/*--------------------------------------------------------------------------*/
/* WaZOO                                                                    */
/*--------------------------------------------------------------------------*/
void WaZOO (int originator)
{
   int stat;
   int i = 0;
   char j[200];
   char k[100];
   
   /*--------------------------------------------------------------------*/
   /* Initialize WaZOO                                                   */
   /*--------------------------------------------------------------------*/
   stat         =
   made_request =
   got_arcmail  =
   got_packet   = 0;

   Netmail_Session = 1;

   isOriginator = originator;

   if (originator &&
      ((remote_addr.Zone != called_addr.Zone)   ||
       (remote_addr.Net != called_addr.Net)     ||
       (remote_addr.Node != called_addr.Node)   ||
       (remote_addr.Point != called_addr.Point)))
      {
      (void) sprintf (k, "%s", Full_Addr_Str (&remote_addr));
      (void) sprintf (j, MSG_TXT(M_CALLED), Full_Addr_Str (&called_addr), k);
      status_line (j);
      }
   else if (!originator)
      called_addr = remote_addr;

   if (!CARRIER)
      return;

   if (flag_file (TEST_AND_SET, &called_addr, 1))
      goto endwazoo;

   /* Try Janus first */
   if ((((unsigned) remote_capabilities) & DOES_IANUS) && ((janus_baud >= cur_baud.rate_value) || (janus_OK)))
      {
      status_line ("%s Janus", MSG_TXT(M_WAZOO_METHOD));
      Janus ();
      goto endwazoo;
      }


   /* See if we can both do ZEDZAP */
   if ((remote_capabilities & ZED_ZAPPER) && (!no_zapzed))
      {
      status_line ("%s ZedZap", MSG_TXT(M_WAZOO_METHOD));
      remote_capabilities &= ~ZED_ZIPPER;
      }
   else if ((remote_capabilities & ZED_ZIPPER) && (!no_zapzed))
      {
      status_line ("%s ZedZip", MSG_TXT(M_WAZOO_METHOD));
      remote_capabilities &= ~ZED_ZAPPER;
      }
   else
      {
      status_line ("%s DietIFNA", MSG_TXT(M_WAZOO_METHOD));
      if (originator)
         {
         FTSC_sender (1);
         }
      else
         {
         (void) FTSC_receiver (1);
         }
      goto endwazoo;
      }


   /*--------------------------------------------------------------------*/
   /* ORIGINATOR: send/receive/send                                      */
   /*--------------------------------------------------------------------*/
   if (originator)
      {

      (void) send_WaZOO ();
      if (!CARRIER)
         goto endwazoo;
      if (!get_Zmodem (CURRENT.sc_Inbound, NULL))
         goto endwazoo;

      if (!CARRIER)
         goto endwazoo;
      stat = respond_to_file_requests (i, WaZOO_callback, WaZOO_time);
      if (stat)
         (void) Send_Zmodem (NULL, NULL, ((stat) ? END_BATCH : NOTHING_TO_DO), DO_WAZOO);
      mail_finished = 1;
      }

   /*--------------------------------------------------------------------*/
   /* CALLED SYSTEM: receive/send/receive                                */
   /*--------------------------------------------------------------------*/
   else
      {
      if (!get_Zmodem (CURRENT.sc_Inbound, NULL))
         goto endwazoo;
      if (!CARRIER)
         goto endwazoo;
      (void) send_WaZOO ();
      if (!CARRIER || !made_request)
         goto endwazoo;
      (void) get_Zmodem (CURRENT.sc_Inbound, NULL);
      }

endwazoo:
   (void) flag_file (CLEAR_FLAG, &called_addr, 1);
   status_line (MSG_TXT(M_WAZOO_END));

}                                                /* wazoo */

/*--------------------------------------------------------------------------*/
/* RESPOND TO FILE REQUEST                                                  */
/*--------------------------------------------------------------------------*/
int respond_to_file_requests (int f_sent, 
                              int (*callback)(char *), int (*calltime)(long))
{
   char req[80];
   struct stat buf;
   int nfiles = 0;
   FILE *fp;
   int np;
   char *s;
   int fsent;
   ADDR foo;

   fsent = f_sent;                              /* copy into local var  */
                                                /* this is for callback */
   if (!(matrix_mask & TAKE_REQ))
      goto done;

   for (np = 0; np <= ALIAS_CNT; np++)
      {
      foo = alias[np];

      if (foo.Net == 0)
         break;

   /* For a point, massage the address to get the right .REQ filename */

      if (foo.Point != 0)
         {
         foo.Node  = foo.Point;
         foo.Point = 0;
         foo.Net   = (pvtnet > 0) ? (unsigned int) pvtnet : 0;
         }        

      (void) sprintf (req, request_template, CURRENT.sc_Inbound, Hex_Addr_Str (&foo));

      if (!stat (req, &buf))
         {
         if ((fp = fopen (req, read_ascii)) == NULL)
            {
            (void) got_error (MSG_TXT(M_OPEN_MSG), req);
            goto done;
            }

         while (!feof (fp))
            {
            req[0] = 0;
            if (fgets (req, 79, fp) == NULL)
               break;

            /* ; as the first char is a comment */
            if (req[0] == ';')
               continue;

            /* Get rid of the newline at the end */
            s = (char *) (req + strlen (req) - 1);
            while ((s >= req) && isspace (*s))
               *s-- = '\0';

            if (req[0] == '\0')
               continue;

            if ((nfiles = n_frproc (req, nfiles, callback, calltime)) < 0)
               break;
            }

         (void) fclose (fp);

         (void) sprintf (req, request_template, CURRENT.sc_Inbound, Hex_Addr_Str (&foo));
         (void) unlink (req);
         /* once we have satisfied a request, we can get out of here */
         break;
         }
      }

done:
   return fsent;
}
