/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*  (C) Copyright 1987-91, Bit Bucket Software Co., a Delaware Corporation. */
/*                                                                          */
/*                                                                          */
/*         Routines for writing stuff to windows within BinkleyTerm         */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.250.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:491/0                          */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*                                                                          */
/*   This module is derived from code developed by Augie Hansen in his      */
/*   book "Proficient C" published by Microsoft Press.  Mr. Hansen was      */
/*   kind enough to give us verbal permission to use his routines, and      */
/*   Bob, Vince and Alan (and all our full screen users) are grateful.      */
/*   If you decide to use this code in some package you are doing, give     */
/*   some thought to going out and buying the book. He deserves that.       */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/* Include this file before any other includes or defines! */

#include "includes.h"

extern BUFFER Sbuf;
extern CELLP Scrnbuf;

void sb_wa (REGIONP win, int attr, int n)
{
   int i;
   int row;
   int col;

   i = n;
   row = win->r0 + win->row;
   col = win->c0 + win->col;

   while (i--)
      (Scrnbuf + row * SB_COLS + col + i)->b.attr = (unsigned char) attr;

   /* marked the changed region */
   if (col < Sbuf.lcol[row])
      Sbuf.lcol[row] = col;
   if (col + n > Sbuf.rcol[row])
      Sbuf.rcol[row] = col + n;

   Sbuf.flags |= SB_DELTA;

   return; /* ((i == 0) ? SB_OK : SB_ERR); */
}

void sb_wc (REGIONP win, int ch, int n)
{
   int i;
   int row;
   int col;

   i = n;
   row = win->r0 + win->row;
   col = win->c0 + win->col;

   while (i--)
      (Scrnbuf + row * SB_COLS + col + i)->b.ch = (unsigned char) ch;

   /* marked the changed region */
   if (col < Sbuf.lcol[row])
      Sbuf.lcol[row] = col;
   if (col + n > Sbuf.rcol[row])
      Sbuf.rcol[row] = col + n;

   Sbuf.flags |= SB_DELTA;

   return; /* ((i == 0) ? SB_OK : SB_ERR); */
}

void sb_wca (REGIONP win, int ch, int attr, int n)
{
   int i;
   int row;
   int col;
   unsigned int ca;

   i = n;
   ca = (((unsigned) attr) << 8) | (unsigned) ch;
   row = win->r0 + win->row;
   col = win->c0 + win->col;

   while (i--)
      (Scrnbuf + row * SB_COLS + col + i)->cap = ca;

   /* marked the changed region */
   if (col < Sbuf.lcol[row])
      Sbuf.lcol[row] = col;
   if (col + n > Sbuf.rcol[row])
      Sbuf.rcol[row] = col + n;

   Sbuf.flags |= SB_DELTA;

   return; /* ((i == 0) ? SB_OK : SB_ERR); */
}

