#include "copyleft.h"

/*
    GEPASI - a simulator of metabolic pathways and other dynamical systems
    Copyright (C) 1989, 1992, 1993  Pedro Mendes
*/

/*************************************/
/*                                   */
/*        MS-WINDOWS front end       */
/*                                   */
/*         Topology files I/O        */
/*                                   */
/*          QuickC/WIN 1.0           */
/*                                   */
/*   (include here compilers that    */
/*   compiled GWSIM successfully)    */
/*                                   */
/*************************************/


/*
  this file is used both by GWSIM and GWTOP and GWTOP
  must define the symbol GWTOP, otherwise, this file
  will generate stuff for GWSIM
*/

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <io.h>
#include <sys\types.h>
#include <sys\stat.h>
#include "globals.h"
#include "iotop.h"
#include "strtbl.h"						/* symbols for the string table			*/
#ifdef GWTOP
#include "gwtop.h"
#include "topgvar.h"
#include "gep1.h"
#else
#include "gwsim.h"
#include "simgvar.h"
#include "gep2.h"
#endif

#pragma alloc_text( CODE12, TreeToBuf, BufToTree, TopToBuf, WriteTop, BufToTop, ReadTop )

/* write a rate equation tree to a buffer							*/

void TreeToBuf( int i, LPSTR Buff )
{
 char a1[128];
 int j;

 wsprintf( (LPSTR) Buff, "\f%s\n", (LPSTR) tree[i].descr );
 wsprintf( (LPSTR) a1, "%d %d %d %d %d %d %d %d\n", tree[i].nnode,
                                           		    tree[i].nid,
                                                    tree[i].nnum,
                                                    tree[i].nconst,
                                                    tree[i].nsub,
                                                    tree[i].npro,
                                                    tree[i].nmodf,
                                                    tree[i].revers );
 lstrcat( Buff, (LPSTR) a1 );
 for( j=0; j<tree[i].nnode; j++ )
 {
  wsprintf( (LPSTR) a1, "%c %d %d %d,", tree[i].node[j].item, (int) tree[i].node[j].val,
                                  (int) tree[i].node[j].left, (int) tree[i].node[j].right );
  lstrcat( Buff , (LPSTR) a1 );
 }
 lstrcat( Buff, (LPSTR) "\n" );
 for( j=0; j<tree[i].nid; j++ )
 {
  wsprintf( (LPSTR) a1, "%d %s\n", (int) tree[i].id[j][9], (LPSTR) tree[i].id[j] );
  lstrcat( Buff, (LPSTR) a1 );
 }
 for( j=0; j<tree[i].nnum; j++ )
 {
  gcvt( tree[i].constant[j], 8, a1 );
  lstrcat( Buff, (LPSTR) a1 );
  lstrcat( Buff, (LPSTR) "\n" );
 }
}


char *BufToTree( char *Buff )
{
 int i;
 char *paux;
 int daux, daux1, daux2;
 char caux[10];
 float faux;

 /* copy the title from the buffer								*/
 paux = strchr( Buff, '\n' );
 if( paux == NULL )
  return (char *) NULL;
 /* take care of CR if one existed before LF						*/
 if( *(paux-1)=='\r' ) *(paux-1) = '\0';
 *paux = '\0';
 if( strlen( Buff ) > 63 ) Buff[63] = '\0';
 lstrcpy( (LPSTR) tr.descr, (LPSTR) Buff );
 Buff = paux+1;

 /* read nnode from the buffer										*/
 if ( sscanf( Buff, "%d", &daux ) < 1 )
  return (char *) NULL;
 tr.nnode = daux;

 Buff = strchr( Buff, ' ' );
 /* read nid from the buffer										*/
 if( (Buff == NULL ) || ( sscanf( ++Buff, "%d", &daux ) < 1 ) )
  return (char *) NULL;
 tr.nid = daux;

 Buff = strchr( Buff, ' ' );
 /* read nnum from the buffer										*/
 if( (Buff == NULL ) || ( sscanf( ++Buff, "%d", &daux ) < 1 ) )
  return (char *) NULL;
 tr.nnum = daux;

 Buff = strchr( Buff, ' ' );
 /* read nconst from the buffer									*/
 if( (Buff == NULL ) || ( sscanf( ++Buff, "%d", &daux ) < 1 ) )
  return (char *) NULL;
 tr.nconst = daux;

 Buff = strchr( Buff, ' ' );
 /* read nsub from the buffer										*/
 if( (Buff == NULL ) || ( sscanf( ++Buff, "%d", &daux ) < 1 ) )
  return (char *) NULL;
 tr.nsub = daux;

 Buff = strchr( Buff, ' ' );
 /* read npro from the buffer										*/
 if( (Buff == NULL ) || ( sscanf( ++Buff, "%d", &daux ) < 1 ) )
  return (char *) NULL;
 tr.npro = daux;

 Buff = strchr( Buff, ' ' );
 /* read nmodf from the buffer									*/
 if( (Buff == NULL ) || ( sscanf( ++Buff, "%d", &daux ) < 1 ) )
  return (char *) NULL;
 tr.nmodf = daux;

 Buff = strchr( Buff, ' ' );
 /* read revers from the buffer									*/
 if( (Buff == NULL ) || ( sscanf( ++Buff, "%d", &daux ) < 1 ) )
  return (char *) NULL;
 tr.revers = daux;

 Buff = strchr( Buff, '\n' );
 if( Buff==NULL ) return (char *) NULL;
 Buff++;

 for( i=0; i<tr.nnode; i++ )
 {
  if( ( sscanf( Buff, "%c %d %d %d", &caux[0],
                                     &daux,
                                     &daux1,
                                     &daux2 ) < 4 ) )
   return (char *) NULL;
  tr.node[i].item  = caux[0];
  tr.node[i].val   = (unsigned char) daux;
  tr.node[i].left  = (unsigned char) daux1;
  tr.node[i].right = (unsigned char) daux2;
  Buff = strchr( Buff, ',' );
  if( Buff==NULL ) return (char *) NULL;
  Buff++;
 }
 for( i=0; i<tr.nid; i++ )
 {
  Buff = strchr( Buff, '\n' );
  if( Buff==NULL ) return (char *) NULL;
  Buff++;
  if( sscanf( Buff, "%d %8s", &daux, caux ) < 2 )
   return (char *) NULL;
  lstrcpy( tr.id[i], (LPSTR) caux );
  tr.id[i][8] = '\0';
  tr.id[i][9] = (char) daux;
 }
 for( i=0; i<tr.nnum; i++ )
 {
  Buff = strchr( Buff, '\n' );
  if( Buff==NULL ) return (char *) NULL;
  Buff++;
  if( sscanf( Buff, "%g", &faux ) < 1 )
   return (char *) NULL;
  tr.constant[i] = faux;
 }
/*Buff = strchr( Buff, '\n' );*/
 return Buff;
}


void TopToBuf( LPSTR Buff )
{
 int i, j;
 char auxstr[260];

 /* first line: version number											*/
 wsprintf( (LPSTR) Buff, FILE_VERSION );
 /* topology's title in one line										*/
 wsprintf( (LPSTR) auxstr, "%s\n", (LPSTR) topname );
 lstrcat( Buff, (LPSTR) auxstr);
 /* number of steps and metabolites	in one line							*/
 wsprintf( (LPSTR) auxstr, "%d %d\n", nsteps, totmet );
 lstrcat( Buff, (LPSTR) auxstr);
 /* stoicheiometry matrix												*/
 for(i=0;i<totmet;i++)
 {
  for(j=0;j<nsteps;j++)
  {
#ifdef GWTOP
   wsprintf( (LPSTR) auxstr, "%2d ", stoiu[i*MAX_MET + j] );
#else
   wsprintf( (LPSTR) auxstr, "%2d ", stoi[i*MAX_MET + j] );
#endif
   lstrcat( Buff, (LPSTR) auxstr);
  }
  lstrcat( Buff, (LPSTR) "\n" );
 }
 /* kinetic types, reversability status and step names, one per line	*/
 for(i=0;i<nsteps;i++)
 {
  wsprintf( (LPSTR) auxstr, "%2d %2d %s\n", kinetu[i],
  										    revers[i],
  											(LPSTR) stepname[i] );
  lstrcat( Buff, (LPSTR) auxstr);
 }
 /* rstr matrix															*/
 for(i=0;i<nsteps;i++)
 {
  for(j=0;j<MAX_MOL;j++)
  {
   wsprintf( (LPSTR) auxstr, "%2d ", (*rstr)[i][j] );
   lstrcat( Buff, (LPSTR) auxstr);
  }
  lstrcat( Buff, (LPSTR) "\n" );
 }
 /* loop matrix															*/
 for(i=0;i<nsteps;i++)
 {
  for(j=0;j<totmet;j++)
  {
   wsprintf( (LPSTR) auxstr, "%2d ", (*loop)[i][j] );
   lstrcat( Buff, (LPSTR) auxstr);
  }
  lstrcat( Buff, (LPSTR) "\n" );
 }
 /* metabolite status and names, one per line										*/
 for(i=0;i<totmet;i++)
 {
  wsprintf( (LPSTR) auxstr, "%d %s\n", intmet[i], (LPSTR) metname[i] );
  lstrcat( Buff, (LPSTR) auxstr );
 }
}

int WriteTop( LPSTR FName )
{
 GLOBALHANDLE hBuff;
 HCURSOR hSaveCursor;
 LPSTR Buff;
 int ch1, i, udt;
 WORD bufsize;
 OFSTRUCT OfStruct;

 /* display the wait cursor											*/
 hSaveCursor = SetCursor(hHourGlass);

 /* set the maximum buffer size for the topology w/o user-def kin		*/
 bufsize = (WORD) (20 + 256 + 2 + 5 + 2 +
                   totmet*(nsteps*3 + 2) +
                   nsteps*(5 + NAME_L + 2) +
                   nsteps*(MAX_MOL*4 + 2) +
                   nsteps*(totmet*4 + 2) +
                   totmet*(NAME_L + 2 + 2)
                  );
 hBuff = GlobalAlloc( GMEM_MOVEABLE | GMEM_ZEROINIT, bufsize );
 Buff = (LPSTR) GlobalLock( hBuff );
 /* write the information on the buffer									*/
 TopToBuf( Buff );
 /* open the file														*/
 if( (ch1 = OpenFile( FName, &OfStruct, OF_CREATE | OF_WRITE )) != -1 )
 {
  /* write the buffer to the file and close it							*/
  _lwrite( ch1, Buff, (WORD) lstrlen( Buff ) );
  ch1 = _lclose( ch1 );
 }
 if( ch1 == -1 )
 {
  GlobalUnlock( hBuff );
  GlobalFree( hBuff );
  SetCursor(hSaveCursor);
  return IDS_ERR_SAVE;
 }
 /* check if model contains user-defined kinetic types					*/
 for( i=0, udt=0; i<nsteps; i++ )
  if( kinetu[i] >= MAX_TYP )
  {
   udt = 1;
   kfl[i] = 0;
  }
 /* if there are any, output them to the file							*/
 if( udt )
 {
  /* reallocate Buff to accomodate one function							*/
  udt = GlobalUnlock( hBuff );
  hBuff = GlobalReAlloc( hBuff, (WORD) 5500 , GMEM_ZEROINIT | GMEM_MOVEABLE );
  Buff = (LPSTR) GlobalLock( hBuff );
  for( i=0; i<nsteps; i++ )
   if( kinetu[i] >= MAX_TYP )
   {
    /* write the tree function to the buffer							*/
    TreeToBuf( kinetu[i]-MAX_TYP, (LPSTR) Buff );
    /* reopen the file and write this tree to it						*/
    if( (ch1 = OpenFile( (LPSTR) NULL, &OfStruct, OF_REOPEN | OF_WRITE )) != -1 )
    {
     /* write the buffer to the file and close it							*/
     _lseek( ch1, (LONG) 0, 2 );
     _lwrite( ch1, (LPSTR) Buff, (WORD) lstrlen( Buff ) );
     ch1 = _lclose( ch1 );
    }
    if( ch1 == -1 )
    {
     GlobalUnlock( hBuff );
     GlobalFree( hBuff );
     SetCursor(hSaveCursor);
     return IDS_ERR_SAVE;
    }
    kfl[i] = 1;
   }
 }
 GlobalUnlock( hBuff );
 GlobalFree( hBuff );
 SetCursor(hSaveCursor);
 return 0;
}

int BufToTop( char *Buff, char **endoftop )
{
 int i,j;
 int daux;
 unsigned char uaux;
 char *paux;
 char saux[NAME_L];

 /* reset the version number to zero							*/
 ver_no = 0;
 /* copy the first line											*/
 paux = strchr( Buff, '\n' );
 if( paux == NULL )
   return IDS_ERR_BAD_TOPNAM;
 /* take care of CR if one existed before LF					*/
 if( *(paux-1)=='\r' ) *(paux-1) = '\0';
 *paux = '\0';
 if( strlen( Buff ) > 255 ) Buff[255] = '\0';
 lstrcpy( topname, (LPSTR) Buff );
 Buff = paux+1;
 /* is this line a version number ?								*/
 sscanf( topname, "version %f", &ver_no );
 if( ver_no != 0 )
 {
  /* YES! so let's read another line, with the title			*/
  paux = strchr( Buff, '\n' );
  if( paux == NULL )
   return IDS_ERR_BAD_TOPNAM;
  if( *(paux-1)=='\r' ) *(paux-1) = '\0';
  *paux = '\0';
  if( strlen( Buff ) > 255 ) Buff[255] = '\0';
  lstrcpy( topname, (LPSTR) Buff );
  Buff = paux+1;
 }

  /* read nstep from the buffer									*/
  if ( ( sscanf( Buff, " %d", &daux ) < 1) ||
       ( daux < 1 ) || ( daux > MAX_STEP ) )
   return IDS_ERR_BAD_NSTEP;
  nsteps = daux;

  Buff = strchr( Buff, ' ' );
  /* read totmet from the buffer								*/
  if( (Buff == NULL ) || ( sscanf( ++Buff, " %d", &daux ) < 1) ||
      ( daux < 1 )   || ( daux > MAX_MET ) )
   return IDS_ERR_BAD_TOTMET;
  totmet = daux;

  /* read stoiu from the buffer										*/
  for(i=0;i<totmet;i++)
   for(j=0;j<nsteps;j++)
   {
    if(j==0)
    {
     Buff = strchr( Buff, '\n' );
     if( Buff != NULL )
     {
      Buff++;
      for( ;*Buff == ' '; Buff++);
     }
    }
    else
    {
     Buff = strchr( Buff, ' ' );
     if( Buff != NULL ) for( ;*Buff == ' '; Buff++);
    }
    if ( (Buff == NULL) || (sscanf( Buff, "%d", &daux ) < 1) )
     return IDS_ERR_BAD_STOI;
    stoiu[i*MAX_MET + j] = daux;
   }

  Buff = strchr( Buff, '\n' );
  if( Buff == NULL )
   return IDS_ERR_BAD_KINTYPE;
  Buff++;
  /* read kinetu, revers and metname from the buffer				*/
  for( i=0; i<nsteps; i++ )
  {
   for( ;*Buff == ' '; Buff++);
   if ( (Buff == NULL) || (sscanf( Buff, "%d", &daux ) < 1)
        || (daux < -1) )
    return IDS_ERR_BAD_KINTYPE;
   kinetu[i] = daux;

   Buff = strchr( Buff, ' ' );
   if( Buff != NULL ) for( ;*Buff == ' '; Buff++);
   if ( (Buff == NULL) || (sscanf( Buff, "%d", &uaux ) < 1)
        || (uaux < 0) || (uaux > 1) )
    return IDS_ERR_BAD_KINTYPE;
   revers[i] = uaux;

   Buff = strchr( Buff, ' ' );
   if( Buff != NULL ) for( ;*Buff == ' '; Buff++);
   paux = strchr( Buff, '\n' );
   if( paux == NULL )
    return IDS_ERR_BAD_KINTYPE;
   /* take care of CR if one existed before LF						*/
   if( *(paux-1)=='\r' ) *(paux-1) = '\0';
   *paux = '\0';
   if( strlen( Buff ) >= NAME_L ) Buff[NAME_L-1] = '\0';
   lstrcpy( (LPSTR) stepname[i], (LPSTR) Buff );
   Buff = paux+1;
  }

  *(--Buff) = '\n';
  /* read rstr from the buffer										*/
  for(i=0;i<nsteps;i++)
   for(j=0;j<MAX_MOL;j++)
   {
    if(j==0)
    {
     Buff = strchr( Buff, '\n' );
     if( Buff != NULL )
     {
      Buff++;
      for( ;*Buff == ' '; Buff++);
     }
    }
    else
    {
     Buff = strchr( Buff, ' ' );
     if( Buff != NULL ) for( ;*Buff == ' '; Buff++);
    }
    if ( (Buff == NULL) || (sscanf( Buff,"%d", &daux ) < 1) )
     return IDS_ERR_BAD_LOOP;
    (*rstr)[i][j] = (signed char) daux;
   }

  /* read loop from the buffer										*/
  for(i=0;i<nsteps;i++)
   for(j=0;j<totmet;j++)
   {
    if(j==0)
    {
     Buff = strchr( Buff, '\n' );
     if( Buff != NULL )
     {
      Buff++;
      for( ;*Buff == ' '; Buff++);
     }
    }
    else
    {
     Buff = strchr( Buff, ' ' );
     if( Buff != NULL ) for( ;*Buff == ' '; Buff++);
    }
    if ( (Buff == NULL) || (sscanf( Buff,"%u", &uaux ) < 1)
          || (uaux < (unsigned) 0) )
     return IDS_ERR_BAD_LOOP;
    (*loop)[i][j] = uaux;
   }

  /* read metabolite status and names from the buffer				*/
  for(i=0;i<totmet;i++)
  {
   Buff = strchr( Buff, '\n' );
   if ( (Buff == NULL) || (sscanf( ++Buff, "%d %21s", &daux, &saux ) < 2) )
    return IDS_ERR_BAD_INTMET;
   intmet[i] = daux;
   lstrcpy( metname[i], (LPSTR) saux );
  }

  /* point endofbuf to the end of the topology section				*/
  if( endoftop != NULL )
   *endoftop = Buff;

  return 0;
}

/*
  add a new function read from a .TOP file
  and renumber references to this type in the .TOP
*/

int addtr( int e )
{
 int i, j, k, nRc;

 j = nudf;
 k = kinetu[e];
 eqefl = 0;
 if( (nRc = new_tree( j )) != 0 ) return nRc;
 if( (nRc = new_rateq( j )) != 0 ) return nRc;
 for( i=e; i<nsteps; i++ )
  if( (kinetu[i]==k) && (kfl[i]) )
  {
   kinetu[i] = MAX_TYP+j;
   kfl[i] = 0;
  }
 notsaved = 1;
 return 0;
}


/*
	read topology from file
*/

int ReadTop( LPSTR FName )
{
 int i, j, k, fl, ty, nRc;
 HANDLE hBuff;
 HCURSOR hSaveCursor;
 unsigned int bufsize;
 char *Buff;
 int ch1;
 OFSTRUCT OfStruct;
 struct stat fst;

 /* display the wait cursor											*/
 hSaveCursor = SetCursor(hHourGlass);

 /* open the file													*/
 ch1 = OpenFile( FName, &OfStruct, OF_READ );
 if( ch1 != -1 )
 {
  /* get the file statistics										*/
  fstat( ch1, &fst );

  /* set the buffer to the size of the file plus one				*/
  bufsize = (unsigned int) fst.st_size;

  /* allocate space for the read buffer and lock it					*/
  hBuff = LocalAlloc( GMEM_MOVEABLE | GMEM_ZEROINIT, (WORD) (bufsize+1) );
  if( hBuff == NULL )
  {
   SetCursor(hSaveCursor);
   return IDS_ERR_NOEXEC;
  }
  Buff = (char *) LocalLock( hBuff );

  /*read the file and close it										*/
  if( read( ch1, Buff, bufsize ) == -1 )
  {
   LocalUnlock( hBuff );
   LocalFree( hBuff );
   SetCursor(hSaveCursor);
   return IDS_ERR_LOAD;
  }
  close( ch1 );

  fl = 0;

  if( ( nRc = BufToTop( Buff, &Buff ) ) != 0 )
  {
   /* release the memory allocated for the buffer					*/
   LocalUnlock( hBuff );
   LocalFree( hBuff );
   SetCursor(hSaveCursor);
   return nRc;
  }
  /* set flags 														*/
  for( i=0; i<nsteps; i++ ) kfl[i] = 1;
  /* check if model contains user-defined kinetic types				*/
  /* if there are any, check if they have to be read				*/
  for( i=0; i<nsteps; i++ )
   if( (kinetu[i] >= MAX_TYP) )
   {
    /* look for a form-feed											*/
    Buff = strchr( Buff, '\f' );
    Buff = BufToTree( ++Buff );
    for( j=0, ty=-1; j<nudf; j++ )
     if( lstrcmp( (LPSTR) tree[j].descr, (LPSTR) tr.descr ) == 0 )
     {
      ty = j;
      break;
     }
    if( ty == -1 )
    {
     if( (nRc=addtr( i )) !=0 ) return nRc;
     fl = 1;
    }
    else
     for( j=i,k=kinetu[i]; j<nsteps; j++ )
      if( (kinetu[j]==k) && (kfl[j]) )
      {
       kinetu[j] = MAX_TYP+ty;
       kfl[j] = 0;
      }
   }

   SetCursor(hSaveCursor);

#ifdef GWTOP
  if( fl )
  {
   LoadString( hInst, IDS_INF_NEWKIN, szString, sizeof(szString) );
   MessageBox( NULL, szString, (LPSTR) "GEPASI - Topology", MB_ICONINFORMATION );
  }
#endif

  return 0;
 }
 else
 {
  SetCursor(hSaveCursor);
  return IDS_ERR_LOAD;
 }
}

