@echo off
REM *************************************************************************
REM *** AllDirs.bat - Perform the given command in the current directory  ***
REM ***               and in all subdirectories of the current directory. ***
REM ***               perform in directories top-down.                    ***
REM *************************************************************************

REM *****************************************************************
REM *** Build ALLDIRS_CMD environment variable to all input parms ***
REM *****************************************************************
   SET ALLDIRS_CMD=
   :NEXT_ARG
      IF q%1q == qq GOTO NO_MORE_ARGS
      SET ALLDIRS_CMD=%ALLDIRS_CMD% %1
      SHIFT
      GOTO NEXT_ARG
   :NO_MORE_ARGS

CEnvi.exe AllDirs.bat
GOTO CENVI_EXIT

main()
{
   if ( !defined(ALLDIRS_CMD)  ||  !strcmp(ALLDIRS_CMD,"/?") )
      Instructions();
   else {
      // build a tree of all directories from the current point downward
      list = Directory(FullPath("*.*"),TRUE,FATTR_RDONLY|FATTR_HIDDEN|FATTR_SYSTEM|FATTR_SUBDIR|FATTR_ARCHIVE,FATTR_SUBDIR)
      // first perform command in current directory
      RememberDir = FullPath(".")
      PerformCommand()
      if ( NULL != list ) {
         listCount = 1 + GetArraySpan(list)
         for ( i = 0; i < listCount; i++ ) {
            // change to each subdirectory and perform command there
            ChangeToDirectory(list[i].name)
            PerformCommand()
         }
         ChangeToDirectory(RememberDir)
      }
   }
}

PerformCommand()
{
   printf("%s",ALLDIRS_CMD)
   system(ALLDIRS_CMD);
}

ChangeToDirectory(DirName)
{
   printf("\n%s: ",DirName)
   system("cd %s",DirName);
}

Instructions()
{
   printf("\n")
   printf("AllDirs - Perform a command in this directory and all subdirectories\n")
   printf("\n")
   printf("SYNTAX: AllDirs commands...\n")
   printf("\n")
   printf("Where: commands is any commands to perform in each directory\n")
   printf("\n")
   printf("Examples: This example deletes all *.bak files in this directory and in\n")
   printf("          directories below this one:\n")
   printf("            AllDirs del *.bak\n")
   printf("\n")
}

:CENVI_EXIT
SET ALLDIRS_CMD=
