@echo off
REM KeyState - Macro to set, unset, or display the state of keys.
cenvi %0.bat %1 %2 %3 %4
GOTO CENVI_EXIT

#define  NUMLOCK_BIT    0x20
#define  CAPSLOCK_BIT   0x40
#define  KEYS_SEGMENT   0x0040
#define  KEYS_OFFSET    0x0017
KeysAddress = Address(KEYS_SEGMENT,KEYS_OFFSET)

main(argc,argv)
{
   // check that the input is valid
   if ( argc != 3
     || ( argv[1][1] != 0  ||  !strchr("+?-",argv[1][0]) )
     || ( strnicmp("CAP",argv[2],3)  &&  strnicmp("NUM",argv[2],3) ) ) {
      Instructions()
   } else {
      // determine whether to apply to CapsLock or NumLock
      if ( !strnicmp("CAP",argv[2],3) ) {
         KeyName = "CapsLock", KeyBit = CAPSLOCK_BIT
      }
      else {
         KeyName = "NumLock",  KeyBit = NUMLOCK_BIT
      }
      // perform action on the selected key
      CurrentState = peek(KeysAddress)
      switch( argv[1][0] ) {
         case '+':   // Set Key ON
            poke(KeysAddress,CurrentState | KeyBit)
            break
         case '-':   // Turn KEY OFF
            poke(KeysAddress,CurrentState & ~KeyBit)
            break
         case '?':   // display and return state of key
            printf("%s is currently set %s.\n",KeyName,CurrentState & KeyBit ? "ON" : "OFF")
            return( CurrentState & KeyBit ? 1 : 0 )
      }
   }
}


Instructions()
{
   printf("\a\n")
   printf("KeyState - Set, Clear, or Show the keyboard state of NumLock or CapsLock\n");
   printf("\n");
   printf("SYNTAX: KeyState < + | - | ? > < CAP | NUM >\n");
   printf("\n");
   printf("Where:  +    Set KeyState ON\n");
   printf("        -    Set KeySTate OFF\n");
   printf("        ?    Display current Key State, and return ERRORLEVEL 1 if set\n");
   printf("             and ERRORLEVEL 0 if clear\n");
   printf("        NUM  Apply comman < + | - | ? > to the NumLock key\n");
   printf("        CAP  Apply comman < + | - | ? > to the CapsLock key\n");
   printf("\n");
   printf("Examples: KeyState + Num      Turn on the Numlock key\n");
   printf("          KeyState - Cap      Turn of the CapsLock key\n");
   printf("          KeyState ? Num      Show state of NumLock, return ERRORLEVEL if set\n");
   printf("\n")
}

:CENVI_EXIT
