/**************************************************************
* ACO.C - this program calculates the execution time of the   *
*   ACO -- the average C operator.                            *
*                                                             *
* To compile: "cl /Od /Fa /Gs aco.c"                          *
* RHS 9/30/90																  *
**************************************************************/
#include<time.h>
#include<process.h>
#include<stdio.h>
#include<stdlib.h>

#define DEF_ITERATIONS  10000000L
#define TRUE 1
#define FALSE 0
#define MAXOPS  50

typedef struct _op {
    char *name;
    void (*fptr)();
    float elapsed;
    } Op;

void cdecl main(void);
int  cdecl time_ops(Op*, float*);

/**************************************************************
* global variable declarations                                *
**************************************************************/
struct _dummy
    {
    int i;
    float f;
    double d;
    } dummy;

struct _dummy *dum = &dummy;

int    nArray[10];
float  fArray[10];
int    i1, i2 = 3, i3 = 7, i4, *ip1, *ip2;
float  f1, f2=3.0, f3=7.0, f4, *fp1;
double d1, d2;
long   l1, l2;
char   c1;

/**************************************************************
* Non-floating point operations -- test functions             *
**************************************************************/
void nEmptyfunc(void) { i1 = i2;   }
void n00(void) { i1 = i4 = i3;     }
void n01(void) { i1 = dummy.i;     }
void n02(void) { i1 = dum->i;      }
void n03(void) { i1 = nArray[i2];  }
void n04(void) { i1 = *ip1;        }
void n05(void) { i1 = 10;          }
void n06(void) { i1 = (long)i2;    }
void n07(void) { i1 = (char)i2;    }
void n08(void) { i1 = (int)l2;     }
void n09(void) { i1 = ~i2;         }
void n10(void) { i1 = ++i2;        }
void n11(void) { i1 = i2++;        }
void n12(void) { i1 = !i2;         }
void n13(void) { i1 = -i2;         }
void n14(void) { i1 = i2 * i3;     }
void n15(void) { i1 = i2 / i3;     }
void n16(void) { i1 = i2 % i3;     }
void n17(void) { i1 = i2 + i3;     }
void n18(void) { i1 = i2 - i3;     }
void n19(void) { i1 = i2 << i3;    }
void n20(void) { i1 = i2 >> i3;    }
void n21(void) { i1 = i2 <= i3;    }
void n22(void) { i1 = i2 != i3;    }
void n23(void) { i1 = i2 && i3;    }
void n24(void) { i1 = i2 || i3;    }
void n25(void) { i1 = i2 & i3;     }
void n26(void) { i1 = i2 | i3;     }
void n27(void) { i1 = i2 ^ i3;     }
void n28(void) { i1 = i1 ? i2 : i3;}
void n29(void) { i1 += i2;         }

Op nOperations[MAXOPS] =
    {
    { "empty function..............", nEmptyfunc, (float)0},
    { "integer assignment..........", n00, (float)0},
    { "member reference............", n01, (float)0},
    { "member reference via pointer", n02, (float)0},
    { "array reference.............", n03, (float)0},
    { "pointer reference...........", n04, (float)0},
    { "constant reference..........", n05, (float)0},
    { "cast long to int............", n06, (float)0},
    { "cast int to char............", n07, (float)0},
    { "cast long to int............", n08, (float)0},
    { "compliment..................", n09, (float)0},
    { "pre-increment...............", n10, (float)0},
    { "post-increment..............", n11, (float)0},
    { "not.........................", n12, (float)0},
    { "negative....................", n13, (float)0},
    { "multiply....................", n14, (float)0},
    { "divide......................", n15, (float)0},
    { "modulo......................", n16, (float)0},
    { "addition....................", n17, (float)0},
    { "subtraction.................", n18, (float)0},
    { "shift-left..................", n19, (float)0},
    { "shift-right.................", n20, (float)0},
    { "integer compare.............", n21, (float)0},
    { "integer equality............", n22, (float)0},
    { "logical and.................", n23, (float)0},
    { "logical or..................", n24, (float)0},
    { "bit-wise and................", n25, (float)0},
    { "bit-wise or.................", n26, (float)0},
    { "exclusive or................", n27, (float)0},
    { "conditional.................", n28, (float)0},
    { "plus/equals.................", n29, (float)0},
    { "", NULL, (float)0 }
    };

/**************************************************************
* Floating point operations -- test functions                 *
**************************************************************/
void fEmptyfunc(void) { f1 = f2;   }
void f00(void) { f1 = f4 = f2;     }
void f01(void) { f1 = dummy.f;     }
void f02(void) { f1 = dum->f;      }
void f03(void) { f1 = fArray[i1];  }
void f04(void) { f1 = *fp1;        }
void f05(void) { f1 = 10.0;        }
void f06(void) { f1 = (float)c1;   }
void f07(void) { f1 = (float)i1;   }
void f08(void) { f1 = (float)l1;   }
void f09(void) { f1 = ++f2;        }
void f10(void) { f1 = f1++;        }
void f11(void) { f1 = !f2;         }
void f12(void) { f1 = -f2;         }
void f13(void) { f1 = f2 * f3;     }
void f14(void) { f1 = f2 / f3;     }
void f15(void) { f1 = f2 + f3;     }
void f16(void) { f1 = f2 - f3;     }
void f17(void) { f1 = f2 <= f3;    }
void f18(void) { f1 = f2 != f3;    }

Op fOperations[MAXOPS] =
    {
    { "empty function..............", fEmptyfunc, (float)0},
    { "floating point assignment...", f00, (float)0},
    { "member reference............", f01, (float)0},
    { "member reference via pointer", f02, (float)0},
    { "array reference.............", f03, (float)0},
    { "pointer reference...........", f04, (float)0},
    { "constant reference..........", f05, (float)0},
    { "cast to fp from char........", f06, (float)0},
    { "cast to fp from int.........", f07, (float)0},
    { "cast to fp from long........", f08, (float)0},
    { "pre-increment...............", f09, (float)0},
    { "post-increment..............", f10, (float)0},
    { "not.........................", f11, (float)0},
    { "negative....................", f12, (float)0},
    { "multiply....................", f13, (float)0},
    { "divide......................", f14, (float)0},
    { "addition....................", f15, (float)0},
    { "subtraction.................", f16, (float)0},
    { "compare.....................", f17, (float)0},
    { "equality....................", f18, (float)0},
    { "", NULL, (float)0 }
    };

/**************************************************************
* time_ops - time each operation in table Operations[]        *
* through successive iterations. The number of iterations     *
* is specified in the global variable "settings".             *
*                                                             *
* INP: Operations - the NULL terminated table containing      *
*                   operations to be performed.               *
*      ACOval     - holds the ACO value upon return.          *
* OUT: the number of operations tested.                       *
**************************************************************/
int time_ops(Op *Operations, float *ACOval)
    {
    long start, end;
    unsigned long iterations, setting = DEF_ITERATIONS;
    float test,empty,total = (float)0;
    int i;

    for( i = 0; Operations[i].name[0] ; i++)
        {
        printf("Testing %s...",Operations[i].name);
        iterations = setting;
        start = clock();
        for( ; iterations; iterations--)
            Operations[i].fptr();
        end = clock();
        test = (float)(end-start);
        test /= CLK_TCK;

        if(i == 0)      // testing empty function on i == 0
            Operations[i].elapsed = empty = test;
        else            // all other functions on i > 0
            {
            if(test < empty)
                test = empty;
            Operations[i].elapsed = test - empty;
            total += Operations[i].elapsed;
            }

        printf("%04.02f seconds, net %04.02f\n",
                 test, Operations[i].elapsed);
        }

    printf("Empty function required: %04.02f\n",empty);
    printf("%d operations netted %04.02f seconds"
           " over %ld iterations\n", i, total, setting);
    printf("An average of %04.02f seconds per operations"
           "  for %ld iterations\n", total=total/i, setting);
    *ACOval = 1E6 * total/setting;
    return(i);
    }

/**************************************************************
* main - calculates ACO, ACON and ACOF based on a subset of   *
* C operations.                                               *
**************************************************************/
void main(void)
    {
    int   n1, n2;
    float ACO, ACON, ACOF;

    printf("\n=====Non-Floating Point Operations=====\n");
    n1 = time_ops(nOperations, &ACON);
    printf("ACON = %04.2f microseconds\n", ACON);

    printf("\n=====Floating Point Operations=====\n");
    n2 = time_ops(fOperations, &ACOF);
    printf("ACOF = %04.2f microseconds\n", ACOF);

    printf("\n=====Combined Operations=====\n");
    ACO = (ACON*n1 + ACOF*n2) / (float)(n1+n2);
    printf("ACO = %04.2f microseconds\n", ACO);
    }

