/****************************************************************************
*
*								Buildrsp
*
*					Copyright (C) 1991 Kendall Bennett.
*							All rights reserved.
*
* Filename:		$RCSfile: buildrsp.c $
* Version:		$Revision: 1.1 $
*
* Language:		ANSI C
* Environment:	MS DOS
*
* Description:	Program to build a response file from a file containing
*				a simple list of files. The format of the response file
*				is specified using a standard printf style format string.
*
* $Id: buildrsp.c 1.1 92/04/18 17:25:52 kjb Exp $
*
* Revision History:
* -----------------
*
* $Log:	buildrsp.c $
* Revision 1.1  92/04/18  17:25:52  kjb
* Initial revision
* 
****************************************************************************/

#include <stdio.h>
#include <malloc.h>
#include <process.h>
#include <string.h>
#include <ctype.h>

#ifdef __MSDOS__
#include <dir.h>
#endif

#define	MAX_FILES		200			/* 200 files maximum				*/

#define	true			1
#define	false			0

/*------------------------- Global variables ------------------------------*/

char	*rcsid = "$Id: buildrsp.c 1.1 92/04/18 17:25:52 kjb Exp $";
char	*filenames[MAX_FILES];

/* Open a file returning true if successful */

int openfile(FILE **in,char *filename,char *mode)
{
	if( (*in = fopen(filename,mode) ) == NULL) {
		return false;	/* Open failed									*/
		}
	else
		return true;	/* Open was successful							*/
}

void readfilenames(char *name,char *filenames[],int *numfiles)
/****************************************************************************
*
* Function:		readfilenames
* Parameters:	name		- Name of file to read filenames from
*				filenames[]	- Array to place filenames in
*				numfiles	- Number of filenames read
*
* Description:	Reads the names of the files to translate from the
*				specified file 'name'. We expect each file name to we
*				a whole word on the line and ignore all whitespace.
*
****************************************************************************/
{
	char	buf[MAXPATH];
	FILE	*f;

	if (!openfile(&f,name,"rt")) {
		printf("Unable to open the file: %s\n",name);
		exit(1);
		}

	*numfiles = 0;
	while (!feof(f) && (fscanf(f," %s ",buf) == 1)) {
		filenames[*numfiles] = strdup(buf);
		(*numfiles)++;
		}

	fclose(f);
}

int main(int argc,char *argv[])
{
	int		i,numfiles;

	if (argc != 2) {
		printf("Usage: buildrsp <filelist>\n\n");
		printf("where <filelist> is the name of a file containing the\n");
		printf("filenames to build the turbo librarian response file with.\n");
		printf("The response file is sent to the standard output device.\n");
		exit(1);
		}

	readfilenames(argv[1],filenames,&numfiles);

	/* Build each line of the response file */

	for (i = 0; i < numfiles-1; i++)
		printf("+-%s &\n",filenames[i]);
    printf("+-%s\n\n",filenames[i]);

	return 0;
}
