--************************************************************************
--
--  TYPES.ADB
--
--  A copyright-reserved, free use program.
--  (c)John H. McCoy, 1993, Sam Houston St. Univ., TX 77341-2206
--************************************************************************

with bit_ops, unchecked_conversion;
package body Types is

function byte_to_byte_integer is new
   unchecked_conversion(byte, byte_integer);
function byte_integer_to_byte is new
   unchecked_conversion(byte_integer, byte);

function "+"(left, right: byte) return byte is
begin
   return byte_integer_to_byte(byte_to_byte_integer(left) +
                               byte_to_byte_integer(right));
end "+";

function "OR"(left, right: byte) return byte is
use bit_ops;
begin
   return byte_integer_to_byte(byte_to_byte_integer(left) OR
                               byte_to_byte_integer(right));
end "OR";

function word_to_integer is new
   unchecked_conversion(word, integer);
function integer_to_word is new
   unchecked_conversion(integer, word);

function "+"(left, right: word) return word is
begin
   return integer_to_word(word_to_integer(left) +
                          word_to_integer(right));
end "+";

function "OR"(left, right: word) return word is
use bit_ops;
begin
   return integer_to_word(word_to_integer(left) OR
                          word_to_integer(right));
end "OR";

function W_to_integer is new
   unchecked_conversion(W, integer);
function integer_to_W is new
   unchecked_conversion(integer, W);

function "+"(left, right: W) return W is
begin
   return integer_to_W(W_to_integer(left) +
                          W_to_integer(right));
end "+";

function "OR"(left, right: W) return W is
use bit_ops;
begin
   return integer_to_W(W_to_integer(left) OR
                          W_to_integer(right));
end "OR";

end Types;