;Boolean expressions:
true            equ     1
false           equ     0

;Special characters for strings (Bell, Carriage Return, Line Feed, and End of
;String):
bell		equ	7
cr		equ	13
lf		equ	10
eos		equ	'$'

;The following colors can be used as forground or background colors:
enum		colors	black=0,blue,green,cyan,red,magenta,brown,lightGrey

;The following colors can be used only as forground colors:
enum		moreColors	grey=8,lightBlue,lightGreen,lightCyan, {
				lightRed,lightMagenta,yello,white}





;Simple change you can make to PhilTime.EXE:

;These set the attributes of the clock:
forgroundColor  equ     white
backgroundColor equ     black
blinking        equ     false

;This program is safer with watchScrollLock==true.  This program is smaller
;with watchScrollLock==false.
watchScrollLock	equ	true

;This program is safer with watchVideoMode==true.  This program is smaller
;with watchVideoMode==false.
watchVideoMode  equ     true

;redrawTime specifies how often the clock is redrawn, measured in clock ticks.
;1092 clock ticks make approximately 1 minute.
redrawTime      equ     109

;firstRedraw specifies how long to wait before the first time the clock is
;drawn.  If the clock is drawn immediatly, it will usually scroll off before
;you can see it.  firstRedraw is measured in clock ticks.
firstRedraw	equ	9

;The clock takes more memory when twelveHourTime is true.
twelveHourTime	equ	true

;The clock takes more memory when leadingZero if false.
leadingZero	equ	false

;This "string" is printed each time the program starts.
;Please leave my name in, AND add your own.
macro           bannerString
banner		db	'Phil Time',cr,lf
		db	'Version 1.0',cr,lf
		db	'By Philip Smolen',cr,lf,lf
if		watchScrollLock
		db	'Use the Scroll Lock button to turn the clock on and off.',cr,lf,lf
endif
		db	eos
endm		bannerString
