//--------------------------------------------------------
//  this is a demo program to illustrate the use the
//  bFAST library
///
//  include DEMO.CPP and BFAST.LIB in the project file
//
//  In order to run both demo program you neeed to execute
//  Btrieve.exe first.
//
//  Chaolin Chang
//--------------------------------------------------------
#include <stdio.h>

#include "btrieve.hpp"
#include "order.def"   // include the field definition file
#include "order.hpp"   // include the field symbol file

void main()
{
    //
    // create a Btrieve ans open it at the same time
    //
	Btrieve f("", "ORDER.DAT", order, FLD_ORDER);
	if (f.Err())
	{
		printf("error code: %d\n", f.Err());
		return;
	}
	int count=0;
	printf("Record Order Ref    Customer\n");
    printf("------ ------------ --------\n");
    //
    // read the first record
    //
    f.GetFirst();
    for (;;)
    {
        //
        // use Eof(), if you like
        //
        if (f.Err())
            break;
        //
        // it will cause error if you do this
        // printf("%s %s", f.fStr(ORDER_REFERENCE), f.fStr(CUSTOMER));
        // because fStr() uses a static char [] as the common buffer
        // to store the returned value
        //
        printf("%.6d ", ++count);
        printf("%s ", f.fStr(ORDER_REFERENCE));
        printf("%s\n", f.fStr(CUSTOMER));
        //
        // read the next record
        //
        f.GetNext();
    }
    //
    // as f is destoryed, file is closed automatically
}

