
// Copyright 1992, David Perelman-Hall & Jamshid Afshar


#ifndef CATEGORY_H
#define CATEGORY_H

#include <iostream.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "misc.h"

const MAX_STRING_LEN = 20;
const MAX_CATEGORIES = 20;

const ALIVE=1225;
const DEAD=666;
class Category {
friend ostream& operator << ( ostream& os, const Category& cat );
private:
   int alive;
   char _s[MAX_STRING_LEN+1];
public:
   //empty constructor
   Category() {
      alive = ALIVE;
      _s[0] = '\0';
      }
   //copy constructor
   Category( const Category& cat ) {
      alive = ALIVE;
      strcpy( _s, cat._s );
      strupr( _s );
      }
   //constructor from a passed in string
   Category( const char* str ) {
      alive = ALIVE;
      strcpy( _s, str );
      }
   //ensure automatic conversion to const char pointer
   operator const char* () const {
      return _s;
      }
   //assignment operator
   void operator = ( const Category& cat) {
      strcpy( _s, cat._s );
      }
   //user define ==
   bool operator == ( const Category& cat) const {
      return strcmp( _s, cat._s ) == 0;
      }
   //user defined !=
   bool operator != ( const Category& cat) const {
      return !( *this == cat );
      }
   //destructor
   ~Category();
   //clear
   void clear(){
      _s[0] = '\0';
      }
};

class Category_Sequence {
friend ostream& operator << ( ostream& os, const Category_Sequence& seq );
friend istream& operator >> ( istream& is, Category_Sequence& seq );
private:
   int alive;
   struct CategoryNode {
      Category _category;
      CategoryNode *_nextp;
      CategoryNode( Category category, CategoryNode *nextp )
         : _category(category), _nextp(nextp) {}
      };
   CategoryNode *_first_node;
public:
   Category_Sequence();
   Category_Sequence( const Category_Sequence& );
   Category_Sequence( const Category& category );
   ~Category_Sequence();

   Category pop();
   void operator = ( const Category_Sequence& seq);
   Category_Sequence& operator += ( const Category& category);
   Category_Sequence& operator += ( const Category_Sequence& seq);
   void clear();

   const Category& first() const {
      assert( !isEmpty() );
      return _first_node->_category;
      }      

   Category_Sequence rest() const;
   int length() const;
   bool operator == ( const Category_Sequence& seq) const;
   bool isEmpty() const {
      return _first_node == NULL;
      }
};


inline
Category_Sequence operator + ( const Category_Sequence& a, const Category& b)
   {  Category_Sequence temp = a; return temp += b; }

inline
Category_Sequence operator + ( const Category_Sequence& a, const Category_Sequence& b)
   {  Category_Sequence temp = a; return temp += b; }

#endif

